/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.convolution.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.comp.Dimension2D;
import org.neuroph.nnet.comp.layer.FeatureMapLayer;
import org.neuroph.nnet.comp.layer.FeatureMapsLayer;

public class LayerVisialize {
    private static final int RATIO = 20;
    private List<List<Double>> layerMaps = new ArrayList<List<Double>>();
    private FeatureMapsLayer featureMapsLayer;
    private Dimension2D mapDimensions;

    public LayerVisialize(FeatureMapsLayer featureMapsLayer) {
        this.featureMapsLayer = featureMapsLayer;
        this.mapDimensions = featureMapsLayer.getMapDimensions();
        this.initWeights();
    }

    private void initWeights() {
        for (FeatureMapLayer featureMap : this.featureMapsLayer.getFeatureMaps()) {
            ArrayList<Double> map = new ArrayList<Double>();
            for (Neuron neuron : featureMap.getNeurons()) {
                map.add(neuron.getOutput());
            }
            this.layerMaps.add(map);
        }
    }

    public void displayWeights() {
        for (List<Double> currentKernel : this.layerMaps) {
            this.displayWeight(currentKernel);
        }
    }

    private void displayWeight(List<Double> currentKernel) {
        JFrame frame = new JFrame("Weight Visualiser: ");
        frame.setSize(400, 400);
        JLabel label = new JLabel();
        Dimension d = new Dimension(this.mapDimensions.getWidth() * 20, this.mapDimensions.getHeight() * 20);
        label.setSize(d);
        label.setPreferredSize(d);
        frame.getContentPane().add((Component)label, "Center");
        frame.pack();
        frame.setVisible(true);
        BufferedImage image = new BufferedImage(this.mapDimensions.getWidth(), this.mapDimensions.getHeight(), 10);
        int[] rgb = this.convertWeightToRGB(currentKernel);
        image.setRGB(0, 0, this.mapDimensions.getWidth(), this.mapDimensions.getHeight(), rgb, 0, this.mapDimensions.getWidth());
        label.setIcon(new ImageIcon(image.getScaledInstance(this.mapDimensions.getWidth() * 20, this.mapDimensions.getHeight() * 20, 4)));
    }

    private int[] convertWeightToRGB(List<Double> pixels) {
        this.normalizeWeights(pixels);
        int[] data = new int[this.mapDimensions.getWidth() * this.mapDimensions.getHeight()];
        int i = 0;
        for (Double weight : pixels) {
            int val = (int)(weight * 255.0);
            data[i++] = new Color(val, val, val).getRGB();
        }
        return data;
    }

    private void normalizeWeights(List<Double> weights) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (Double weight : weights) {
            min = Math.min(min, weight);
            max = Math.max(max, weight);
        }
        for (int i = 0; i < weights.size(); ++i) {
            double value = (weights.get(i) - min) / (max - min);
            weights.set(i, value);
        }
    }
}

