/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.adalineDigits;

import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.events.LearningEvent;
import org.neuroph.core.events.LearningEventListener;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.samples.adalineDigits.Data;

public class DigitsRecognition {
    public static void main(String[] args) {
        DataSet dataSet = DigitsRecognition.generateTraining();
        int inputCount = 35;
        int outputCount = Data.DIGITS.length;
        int hiddenNeurons = 19;
        MultiLayerPerceptron neuralNet = new MultiLayerPerceptron(inputCount, hiddenNeurons, outputCount);
        BackPropagation learningRule = (BackPropagation)neuralNet.getLearningRule();
        learningRule.setLearningRate(0.5);
        learningRule.setMaxError(0.001);
        learningRule.setMaxIterations(5000);
        learningRule.addListener(new LearningEventListener(){

            @Override
            public void handleLearningEvent(LearningEvent event) {
                BackPropagation bp = (BackPropagation)event.getSource();
                if (event.getEventType().equals((Object)LearningEvent.Type.LEARNING_STOPPED)) {
                    System.out.println();
                    System.out.println("Training completed in " + bp.getCurrentIteration() + " iterations");
                    System.out.println("With total error " + bp.getTotalNetworkError() + '\n');
                } else {
                    System.out.println("Iteration: " + bp.getCurrentIteration() + " | Network error: " + bp.getTotalNetworkError());
                }
            }
        });
        neuralNet.learn(dataSet);
        DigitsRecognition.testNeuralNetwork(neuralNet, dataSet);
    }

    public static void testNeuralNetwork(NeuralNetwork neuralNet, DataSet testSet) {
        System.out.println("--------------------------------------------------------------------");
        System.out.println("***********************TESTING NEURAL NETWORK***********************");
        for (DataSetRow testSetRow : testSet.getRows()) {
            neuralNet.setInput(testSetRow.getInput());
            neuralNet.calculate();
            int izlaz = DigitsRecognition.maxOutput(neuralNet.getOutput());
            String[] niz = Data.convertDataIntoImage(testSetRow.getInput());
            for (int i = 0; i < niz.length; ++i) {
                if (i != niz.length - 1) {
                    System.out.println(niz[i]);
                    continue;
                }
                System.out.println(niz[i] + "----> " + izlaz);
            }
            System.out.println("");
        }
    }

    public static DataSet generateTraining() {
        DataSet dataSet = new DataSet(35, Data.DIGITS.length);
        for (int i = 0; i < Data.DIGITS.length; ++i) {
            DataSetRow inputRow = Data.convertImageIntoData(Data.DIGITS[i]);
            double[] input = inputRow.getInput();
            double[] output = new double[Data.DIGITS.length];
            for (int j = 0; j < Data.DIGITS.length; ++j) {
                output[j] = j == i ? 1.0 : 0.0;
            }
            DataSetRow row = new DataSetRow(input, output);
            dataSet.addRow(row);
        }
        return dataSet;
    }

    public static int maxOutput(double[] array) {
        double max = array[0];
        int index = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            index = i;
            max = array[i];
        }
        return index;
    }
}

