/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.nnet.learning.BackPropagation;

public class QuickPropagation
extends BackPropagation {
    private double maximumGrowthFactor = 1.75;

    @Override
    public void calculateWeightChanges(Neuron neuron) {
        double delta = neuron.getDelta();
        for (Connection con : neuron.getInputConnections()) {
            Weight w = con.getWeight();
            QuickPropData qpData = (QuickPropData)w.getTrainingData();
            double input = con.getInput();
            if (input == 0.0) continue;
            double gradient = delta * input;
            double previousWeightChange = qpData.previousWeightChange;
            double prevGradient = qpData.prevGradient;
            double currentWeightChange = 0.0;
            if (prevGradient * gradient > 0.0 && gradient < prevGradient) {
                currentWeightChange = gradient / (prevGradient - gradient) * previousWeightChange;
                if (Math.abs(currentWeightChange) >= Math.abs(this.maximumGrowthFactor * previousWeightChange)) {
                    currentWeightChange = this.maximumGrowthFactor * previousWeightChange;
                }
            } else if (prevGradient * gradient > 0.0 && gradient >= prevGradient) {
                currentWeightChange = this.maximumGrowthFactor * previousWeightChange;
            } else if (prevGradient * gradient < 0.0) {
                currentWeightChange = gradient / (prevGradient - gradient) * previousWeightChange;
                if (Math.abs(currentWeightChange) >= Math.abs(this.maximumGrowthFactor * previousWeightChange)) {
                    currentWeightChange = this.maximumGrowthFactor * previousWeightChange;
                }
            } else {
                currentWeightChange = -this.learningRate * delta * input;
            }
            w.weightChange += currentWeightChange;
            qpData.previousWeightChange = currentWeightChange;
            qpData.prevGradient = gradient;
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        for (Layer layers : this.neuralNetwork.getLayers()) {
            for (Neuron neuron : layers.getNeurons()) {
                for (Connection connection : neuron.getInputConnections()) {
                    Weight<QuickPropData> qpWeight = new Weight<QuickPropData>();
                    qpWeight.setTrainingData(new QuickPropData());
                    connection.setWeight(qpWeight);
                }
            }
        }
    }

    public static class QuickPropData {
        private double previousWeightChange;
        private double previousError;
        private double prevGradient;
    }
}

