/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class OtsuBinarizeFilter
implements ImageFilter,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        int[] histogram = this.imageHistogram(this.originalImage);
        int totalNumberOfpixels = height * width;
        int treshold = this.treshold(histogram, totalNumberOfpixels);
        int black = 0;
        int white = 255;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int gray = new Color(this.originalImage.getRGB(i, j)).getRed();
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int newColor = gray > treshold ? white : black;
                newColor = ImageUtilities.colorToRGB(alpha, newColor, newColor, newColor);
                this.filteredImage.setRGB(i, j, newColor);
            }
        }
        return this.filteredImage;
    }

    public int[] imageHistogram(BufferedImage image) {
        int i;
        int[] histogram = new int[256];
        for (i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int gray;
                int n = gray = new Color(image.getRGB(i, j)).getRed();
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    private int treshold(int[] histogram, int total) {
        float sum = 0.0f;
        for (int i = 0; i < 256; ++i) {
            sum += (float)(i * histogram[i]);
        }
        float sumB = 0.0f;
        int wB = 0;
        int wF = 0;
        float varMax = 0.0f;
        int threshold = 0;
        for (int i = 0; i < 256; ++i) {
            float mF;
            float varBetween;
            if ((wB += histogram[i]) == 0) continue;
            wF = total - wB;
            if (wF == 0) break;
            float mB = (sumB += (float)(i * histogram[i])) / (float)wB;
            if (!((varBetween = (float)wB * (float)wF * (mB - (mF = (sum - sumB) / (float)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = i;
        }
        return threshold;
    }

    public String toString() {
        return "Otsu Binarize Filter";
    }
}

