/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class Dilation
implements ImageFilter,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private int width;
    private int height;
    private int[][] kernel;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.originalImage = image;
        this.width = this.originalImage.getWidth();
        this.height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(this.width, this.height, this.originalImage.getType());
        this.kernel = this.createKernel();
        int white = 255;
        int black = 0;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int color = new Color(this.originalImage.getRGB(i, j)).getRed();
                if (color == black) {
                    this.convolve(i, j);
                    continue;
                }
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int rgb = ImageUtilities.colorToRGB(alpha, white, white, white);
                this.filteredImage.setRGB(i, j, rgb);
            }
        }
        return this.filteredImage;
    }

    private int[][] createKernel() {
        int[][] kernel = new int[][]{{0, 1, 1, 1, 0}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {0, 1, 1, 1, 0}};
        return kernel;
    }

    private void convolve(int i, int j) {
        for (int x = i - 2; x <= i + 2; ++x) {
            for (int y = j - 2; y <= j + 2; ++y) {
                if (x < 0 || y < 0 || x >= this.width || y >= this.height) continue;
                int black = 0;
                int alpha = new Color(this.originalImage.getRGB(x, y)).getAlpha();
                int rgb = ImageUtilities.colorToRGB(alpha, black, black, black);
                this.filteredImage.setRGB(x, y, rgb);
            }
        }
    }

    public String toString() {
        return "Dilation";
    }
}

