/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.eval.classification;

import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.eval.classification.ClassificationResult;
import org.neuroph.eval.classification.Utils;

public class McNemarTest {
    private int[][] contigencyMatrix = new int[2][2];

    public boolean evaluateNetworks(NeuralNetwork network1, NeuralNetwork network2, DataSet dataSet) {
        for (DataSetRow dataRow : dataSet.getRows()) {
            this.forwardPass(network1, dataRow);
            this.forwardPass(network2, dataRow);
            double[] networkOutput1 = network1.getOutput();
            double[] networkOutput2 = network2.getOutput();
            int maxNeuronIdx1 = Utils.maxIdx(networkOutput1);
            int maxNeuronIdx2 = Utils.maxIdx(networkOutput2);
            ClassificationResult output1 = new ClassificationResult(maxNeuronIdx1, networkOutput1[maxNeuronIdx1]);
            ClassificationResult output2 = new ClassificationResult(maxNeuronIdx2, networkOutput2[maxNeuronIdx2]);
            if (output1.getClassIdx() != output2.getClassIdx()) {
                if (output1.getClassIdx() == this.getDesiredClass(dataRow.getDesiredOutput())) {
                    int[] nArray = this.contigencyMatrix[1];
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                int[] nArray = this.contigencyMatrix[0];
                nArray[1] = nArray[1] + 1;
                continue;
            }
            if (output1.getClassIdx() == this.getDesiredClass(dataRow.getDesiredOutput())) {
                int[] nArray = this.contigencyMatrix[1];
                nArray[1] = nArray[1] + 1;
                continue;
            }
            int[] nArray = this.contigencyMatrix[0];
            nArray[0] = nArray[0] + 1;
        }
        this.printContingencyMatrix();
        double a = Math.abs(this.contigencyMatrix[0][1] - this.contigencyMatrix[1][0]) - 1;
        double hiSquare = a * a / (double)(this.contigencyMatrix[0][1] + this.contigencyMatrix[1][0]);
        System.out.println(hiSquare);
        return hiSquare > 3.841;
    }

    private void printContingencyMatrix() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                System.out.print(this.contigencyMatrix[i][j] + " ");
            }
            System.out.println();
        }
    }

    private int getDesiredClass(double[] output) {
        for (int i = 0; i < output.length; ++i) {
            if (output[i] != 1.0) continue;
            return i;
        }
        return -1;
    }

    private void forwardPass(NeuralNetwork neuralNetwork, DataSetRow dataRow) {
        neuralNetwork.setInput(dataRow.getInput());
        neuralNetwork.calculate();
    }
}

