/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.learning;

import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.core.transfer.TransferFunction;

public class SoftMax
extends TransferFunction {
    private Layer layer;
    private double totalLayerInput;

    public SoftMax(Layer layer) {
        this.layer = layer;
    }

    @Override
    public double getOutput(double netInput) {
        this.totalLayerInput = 0.0;
        double max = 0.0;
        for (Neuron neuron : this.layer.getNeurons()) {
            this.totalLayerInput += Math.exp(neuron.getNetInput() - max);
        }
        this.output = Math.exp(netInput - max) / this.totalLayerInput;
        return this.output;
    }

    @Override
    public double getDerivative(double net) {
        return this.output * (1.0 - this.output);
    }
}

