/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.graphml;

import java.util.ArrayList;
import org.neuroph.contrib.graphml.XMLAttribute;

public abstract class XMLElement {
    private ArrayList<XMLAttribute> attributes = new ArrayList();
    private ArrayList<XMLElement> childElements = new ArrayList();

    public void appendChild(XMLElement child) {
        this.childElements.add(child);
    }

    public void addAttribute(XMLAttribute attribute) {
        this.attributes.add(attribute);
    }

    public String toString() {
        String out = this.getStartTag() + ">";
        if (this.getChildElements().size() != 0) {
            out = out + "\n";
            out = out + this.getChildElementsString();
        }
        out = out + this.getEndTag();
        return out;
    }

    private String getStartTag() {
        return new String("<" + this.getTag() + this.getAttributesString());
    }

    private String getEndTag() {
        return new String("</" + this.getTag() + ">");
    }

    private String getAttributesString() {
        String out = "";
        for (XMLAttribute attribute : this.getAttributes()) {
            out = out + " " + attribute.toString();
        }
        return out;
    }

    private String getChildElementsString() {
        String out = "";
        for (XMLElement child : this.getChildElements()) {
            out = out + child.toString().replace("\n", "\n    ") + "\n";
        }
        return out;
    }

    public abstract String getTag();

    public ArrayList<XMLAttribute> getAttributes() {
        return this.attributes;
    }

    public ArrayList<XMLElement> getChildElements() {
        return this.childElements;
    }
}

