/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.bpbench;

import org.neuroph.contrib.bpbench.AbstractTraining;
import org.neuroph.contrib.bpbench.TrainingResult;
import org.neuroph.contrib.bpbench.TrainingSettings;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.learning.LearningRule;
import org.neuroph.nnet.learning.QuickPropagation;

public class QuickpropagationTraining
extends AbstractTraining {
    public QuickpropagationTraining(NeuralNetwork neuralNet, DataSet dataset, TrainingSettings settings) {
        super(neuralNet, dataset, settings);
    }

    public QuickpropagationTraining(DataSet dataset, TrainingSettings settings) {
        super(dataset, settings);
    }

    @Override
    public void testNeuralNet() {
        QuickPropagation qp = (QuickPropagation)this.setParameters();
        this.getNeuralNet().setLearningRule(qp);
        this.getNeuralNet().learn(this.getDataset());
        this.getStats().addData(new TrainingResult(qp.getCurrentIteration(), qp.getTotalNetworkError(), this.createMatrix()));
        this.getStats().calculateParameters();
    }

    @Override
    public LearningRule setParameters() {
        QuickPropagation qp = new QuickPropagation();
        qp.setBatchMode(true);
        qp.setLearningRate(this.getSettings().getLearningRate());
        qp.setMaxError(this.getSettings().getLearningRate());
        qp.setMaxIterations(this.getSettings().getMaxIterations());
        return qp;
    }
}

