/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.bpbench;

import org.neuroph.contrib.bpbench.AbstractTraining;
import org.neuroph.contrib.bpbench.TrainingResult;
import org.neuroph.contrib.bpbench.TrainingSettings;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.learning.LearningRule;
import org.neuroph.nnet.learning.BackPropagation;

public class BackpropagationTraining
extends AbstractTraining {
    public BackpropagationTraining(NeuralNetwork neuralNet, DataSet dataset, TrainingSettings settings) {
        super(neuralNet, dataset, settings);
    }

    public BackpropagationTraining(DataSet dataset, TrainingSettings settings) {
        super(dataset, settings);
    }

    @Override
    public void testNeuralNet() {
        BackPropagation bp = (BackPropagation)this.setParameters();
        this.getNeuralNet().setLearningRule(bp);
        this.getNeuralNet().learn(this.getDataset());
        this.getStats().addData(new TrainingResult(bp.getCurrentIteration(), bp.getTotalNetworkError(), this.createMatrix()));
        this.getStats().calculateParameters();
    }

    @Override
    public LearningRule setParameters() {
        BackPropagation bp = new BackPropagation();
        bp.setLearningRate(this.getSettings().getLearningRate());
        bp.setMaxError(this.getSettings().getMaxError());
        bp.setBatchMode(this.getSettings().isBatchMode());
        bp.setMaxIterations(this.getSettings().getMaxIterations());
        return bp;
    }
}

