/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml.pull;

import javolution37.javolution.lang.PersistentReference;
import javolution37.javolution.xml.pull.CharSequenceImpl;

final class Namespaces {
    private static final PersistentReference SIZE = new PersistentReference<Integer>("javolution37.javolution.xml.pull.Namespaces#SIZE", new Integer(64));
    private int[] _nspCounts = new int[((Integer)SIZE.get()).intValue()];
    private int _mapCount;
    private CharSequenceImpl[] _namespaces = new CharSequenceImpl[((Integer)SIZE.get()).intValue()];
    private int _depth;
    private CharSequenceImpl _default = CharSequenceImpl.EMPTY;
    private static final CharSequenceImpl XML_PREFIX = new CharSequenceImpl("xml");
    private static final CharSequenceImpl XML_URI = new CharSequenceImpl("http://www.w3.org/XML/1998/namespace");
    private static final CharSequenceImpl XMLNS_PREFIX = new CharSequenceImpl("xmlns");
    private static final CharSequenceImpl XMLNS_URI = new CharSequenceImpl("http://www.w3.org/2000/xmlns/");

    public CharSequenceImpl getDefault() {
        return this._default;
    }

    public int getNamespaceCount(int depth) {
        if (depth > this._depth) {
            return this._nspCounts[this._depth];
        }
        return this._nspCounts[depth];
    }

    public CharSequenceImpl getNamespacePrefix(int pos) {
        return this._namespaces[pos << 1];
    }

    public CharSequenceImpl getNamespaceUri(int pos) {
        return this._namespaces[(pos << 1) + 1];
    }

    public CharSequenceImpl getNamespaceUri(String prefix) {
        if (prefix == null) {
            return this._default;
        }
        int i = this._nspCounts[this._depth] + this._mapCount;
        while (i > 0) {
            CharSequenceImpl pfx;
            if ((pfx = this._namespaces[--i << 1]) == null || !pfx.equals(prefix)) continue;
            return this._namespaces[(i << 1) + 1];
        }
        if (XML_PREFIX.equals(prefix)) {
            return XML_URI;
        }
        if (XMLNS_PREFIX.equals(prefix)) {
            return XMLNS_URI;
        }
        return null;
    }

    CharSequenceImpl getNamespaceUri(CharSequenceImpl prefix) {
        int i = this._nspCounts[this._depth] + this._mapCount;
        while (i > 0) {
            CharSequenceImpl pfx;
            if ((pfx = this._namespaces[--i << 1]) == null || !pfx.equals(prefix)) continue;
            return this._namespaces[(i << 1) + 1];
        }
        if (XML_PREFIX.equals(prefix)) {
            return XML_URI;
        }
        if (XMLNS_PREFIX.equals(prefix)) {
            return XMLNS_URI;
        }
        return null;
    }

    public void map(CharSequenceImpl prefix, CharSequenceImpl uri) {
        int i;
        if ((i = this._nspCounts[this._depth] + this._mapCount++ << 1) + 1 >= this._namespaces.length) {
            this.resize();
        }
        this._namespaces[i] = prefix;
        this._namespaces[i + 1] = uri;
        if (prefix == null) {
            this._default = uri;
        }
    }

    public void flush() {
        if (this._mapCount != 0) {
            this.push();
            this.pop();
        }
    }

    public void push() {
        if (++this._depth >= this._nspCounts.length) {
            this.resize();
        }
        this._nspCounts[this._depth] = this._nspCounts[this._depth - 1] + this._mapCount;
        this._mapCount = 0;
    }

    public void pop() {
        this._mapCount = 0;
        int oldCount = this._nspCounts[this._depth];
        int newCount = this._nspCounts[--this._depth];
        int i = oldCount;
        block0: while (i > newCount) {
            if (this._namespaces[--i << 1] != null) continue;
            this._default = CharSequenceImpl.EMPTY;
            int j = i;
            while (j > 0) {
                if (this._namespaces[--j << 1] != null) continue;
                this._default = this._namespaces[(j << 1) + 1];
                continue block0;
            }
        }
    }

    public void reset() {
        this._depth = 0;
        this._nspCounts[0] = 0;
        this._default = CharSequenceImpl.EMPTY;
    }

    private void resize() {
        int size = this._nspCounts.length;
        int[] tmp0 = new int[size * 2];
        System.arraycopy(this._nspCounts, 0, tmp0, 0, size);
        this._nspCounts = tmp0;
        CharSequenceImpl[] tmp1 = new CharSequenceImpl[size * 2];
        System.arraycopy(this._namespaces, 0, tmp1, 0, size);
        this._namespaces = tmp1;
        SIZE.setMinimum(new Integer(this._namespaces.length));
    }
}

