/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml.pull;

import javolution37.javolution.realtime.ObjectFactory;
import javolution37.javolution.util.FastComparator;

final class CharSequenceImpl
implements CharSequence,
Comparable {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        protected Object create() {
            return new CharSequenceImpl();
        }
    };
    static final CharSequenceImpl EMPTY = new CharSequenceImpl("");
    char[] data;
    int offset;
    int length;

    CharSequenceImpl() {
    }

    CharSequenceImpl(String string) {
        this.data = string.toCharArray();
        this.offset = 0;
        this.length = string.length();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return this.data[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        CharSequenceImpl chars = (CharSequenceImpl)FACTORY.object();
        chars.data = this.data;
        chars.offset = this.offset + start;
        chars.length = end - start;
        return chars;
    }

    @Override
    public String toString() {
        return new String(this.data, this.offset, this.length);
    }

    public int hashCode() {
        int h = 0;
        int j = this.offset;
        for (int i = 0; i < this.length; ++i) {
            h = 31 * h + this.data[j++];
        }
        return h;
    }

    public boolean equals(Object that) {
        if (that instanceof CharSequenceImpl) {
            return this.equals((CharSequenceImpl)that);
        }
        if (that instanceof String) {
            return this.equals((String)that);
        }
        if (that instanceof CharSequence) {
            return this.equals((CharSequence)that);
        }
        return false;
    }

    public boolean equals(CharSequenceImpl that) {
        if (that == null) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        char[] thatData = that.data;
        int end = this.offset + this.length;
        int i = this.offset;
        int j = that.offset;
        while (i < end) {
            if (this.data[i++] == thatData[j++]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(String str) {
        if (str == null) {
            return false;
        }
        if (this.length != str.length()) {
            return false;
        }
        int i = 0;
        int j = this.offset;
        while (i < this.length) {
            if (this.data[j++] == str.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharSequence chars) {
        if (chars == null) {
            return false;
        }
        if (this.length != chars.length()) {
            return false;
        }
        int i = 0;
        int j = this.offset;
        while (i < this.length) {
            if (this.data[j++] == chars.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object seq) {
        return FastComparator.LEXICAL.compare(this, seq);
    }
}

