/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml.pull;

import javax.realtime.MemoryArea;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.lang.Text;
import javolution37.javolution.xml.pull.CharSequenceImpl;
import javolution37.javolution.xml.pull.Namespaces;
import javolution37.javolution.xml.sax.Attributes;

final class AttributesImpl
implements Attributes,
Reusable {
    private CharSequenceImpl[] _localNames = new CharSequenceImpl[16];
    private CharSequenceImpl[] _prefixes = new CharSequenceImpl[16];
    private CharSequenceImpl[] _qNames = new CharSequenceImpl[16];
    private CharSequenceImpl[] _values = new CharSequenceImpl[16];
    private final Namespaces _namespaces;
    private int _length;

    public AttributesImpl(Namespaces namespaces) {
        this._namespaces = namespaces;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public CharSequence getURI(int index) {
        return index >= 0 && index < this._length ? this._namespaces.getNamespaceUri(this._prefixes[index]) : null;
    }

    @Override
    public CharSequence getLocalName(int index) {
        return index >= 0 && index < this._length ? this._localNames[index] : null;
    }

    public CharSequence getPrefix(int index) {
        return index >= 0 && index < this._length ? this._prefixes[index] : null;
    }

    @Override
    public CharSequence getQName(int index) {
        return index >= 0 && index < this._length ? this._qNames[index] : null;
    }

    @Override
    public String getType(int index) {
        return index >= 0 && index < this._length ? "CDATA" : null;
    }

    @Override
    public CharSequence getValue(int index) {
        return index >= 0 && index < this._length ? this._values[index] : null;
    }

    @Override
    public int getIndex(String uri, String localName) {
        for (int i = 0; i < this._length; ++i) {
            if (!this._localNames[i].equals(localName) || !this._namespaces.getNamespaceUri(this._prefixes[i]).equals(uri)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String qName) {
        for (int i = 0; i < this._length; ++i) {
            if (!this._qNames[i].equals(qName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getType(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index >= 0 ? "CDATA" : null;
    }

    @Override
    public String getType(String qName) {
        int index = this.getIndex(qName);
        return index >= 0 ? "CDATA" : null;
    }

    @Override
    public CharSequence getValue(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index >= 0 ? this._values[index] : null;
    }

    @Override
    public CharSequence getValue(String qName) {
        int index = this.getIndex(qName);
        return index >= 0 ? this._values[index] : null;
    }

    @Override
    public void reset() {
        this._length = 0;
    }

    public void addAttribute(CharSequenceImpl localName, CharSequenceImpl prefix, CharSequenceImpl qName, CharSequenceImpl value) {
        if (this._length >= this._localNames.length) {
            this.increaseCapacity();
        }
        this._localNames[this._length] = localName;
        this._prefixes[this._length] = prefix;
        this._qNames[this._length] = qName;
        this._values[this._length++] = value;
    }

    public String toString() {
        Text text = Text.valueOf('[');
        Text equ = Text.valueOf('=');
        Text sep = Text.valueOf(", ");
        int i = 0;
        while (i < this._length) {
            text = text.concat(Text.valueOf(this._qNames[i]).concat(equ).concat(Text.valueOf(this._values[i])));
            if (++i == this._length) continue;
            text = text.concat(sep);
        }
        return text.concat(Text.valueOf(']')).toString();
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            @Override
            public void run() {
                int newCapacity = AttributesImpl.this._length * 2;
                CharSequenceImpl[] tmp = new CharSequenceImpl[newCapacity];
                System.arraycopy(AttributesImpl.this._localNames, 0, tmp, 0, AttributesImpl.this._length);
                AttributesImpl.access$102(AttributesImpl.this, tmp);
                tmp = new CharSequenceImpl[newCapacity];
                System.arraycopy(AttributesImpl.this._prefixes, 0, tmp, 0, AttributesImpl.this._length);
                AttributesImpl.access$202(AttributesImpl.this, tmp);
                tmp = new CharSequenceImpl[newCapacity];
                System.arraycopy(AttributesImpl.this._qNames, 0, tmp, 0, AttributesImpl.this._length);
                AttributesImpl.access$302(AttributesImpl.this, tmp);
                tmp = new CharSequenceImpl[newCapacity];
                System.arraycopy(AttributesImpl.this._values, 0, tmp, 0, AttributesImpl.this._length);
                AttributesImpl.access$402(AttributesImpl.this, tmp);
            }
        });
    }

    static /* synthetic */ CharSequenceImpl[] access$102(AttributesImpl x0, CharSequenceImpl[] x1) {
        x0._localNames = x1;
        return x1;
    }

    static /* synthetic */ CharSequenceImpl[] access$202(AttributesImpl x0, CharSequenceImpl[] x1) {
        x0._prefixes = x1;
        return x1;
    }

    static /* synthetic */ CharSequenceImpl[] access$302(AttributesImpl x0, CharSequenceImpl[] x1) {
        x0._qNames = x1;
        return x1;
    }

    static /* synthetic */ CharSequenceImpl[] access$402(AttributesImpl x0, CharSequenceImpl[] x1) {
        x0._values = x1;
        return x1;
    }
}

