/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.xml.ObjectReader;

public class XmlInputStream<T>
extends InputStream
implements Reusable {
    private final ObjectReader<T> _objectReader;
    private final XmlReader _xmlReader = new XmlReader();

    public XmlInputStream() {
        this(new ObjectReader());
    }

    public XmlInputStream(ObjectReader<T> reader) {
        this._objectReader = reader;
    }

    public XmlInputStream setInputStream(InputStream in) {
        if (this._xmlReader._inputStream != null) {
            throw new IllegalStateException("Stream not closed or reset");
        }
        this._xmlReader._inputStream = in;
        return this;
    }

    public T readObject() throws IOException {
        try {
            T t = this._objectReader.read(this._xmlReader);
            return t;
        }
        finally {
            this._xmlReader.resume();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._xmlReader._inputStream != null) {
            this._xmlReader._inputStream.close();
            this.reset();
        }
    }

    @Override
    public int read() throws IOException {
        if (this._xmlReader._start < this._xmlReader._end) {
            return this._xmlReader._bytes[this._xmlReader._start++];
        }
        return this._xmlReader.fillBuffer() ? this._xmlReader._bytes[this._xmlReader._start++] : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rem = this._xmlReader._end - this._xmlReader._start;
        if (rem == 0) {
            return this._xmlReader._inputStream.read(b, off, len);
        }
        int count = len < rem ? len : rem;
        System.arraycopy(this._xmlReader._bytes, this._xmlReader._start, b, off, count);
        XmlReader xmlReader = this._xmlReader;
        xmlReader._start = xmlReader._start + count;
        return count;
    }

    @Override
    public void reset() {
        this._objectReader.reset();
        this._xmlReader.reset();
    }

    private static final class XmlReader
    extends Reader
    implements Reusable {
        private InputStream _inputStream;
        private int _code;
        private int _moreBytes;
        private int _start;
        private int _end;
        private final byte[] _bytes = new byte[2048];
        private boolean _isHalted;

        private XmlReader() {
        }

        public void resume() {
            this._isHalted = false;
        }

        public boolean fillBuffer() throws IOException {
            if (this._inputStream == null) {
                throw new IOException("Stream closed");
            }
            this._start = 0;
            this._end = this._inputStream.read(this._bytes, 0, this._bytes.length);
            return this._end > 0;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this._isHalted) {
                return -1;
            }
            if (this._start >= this._end && !this.fillBuffer()) {
                return -1;
            }
            int off_plus_len = off + len;
            int i = off;
            while (i < off_plus_len) {
                byte b = this._bytes[this._start];
                if (b >= 0 && ++this._start < this._end) {
                    cbuf[i++] = (char)b;
                    continue;
                }
                if (b < 0) {
                    if (b == -2) {
                        ++this._start;
                        this._isHalted = true;
                        return i - off;
                    }
                    if (i < off_plus_len - 1) {
                        int code = this.read2();
                        if (code < 65536) {
                            cbuf[i++] = (char)code;
                        } else if (code <= 0x10FFFF) {
                            cbuf[i++] = (char)((code - 65536 >> 10) + 55296);
                            cbuf[i++] = (char)((code - 65536 & 0x3FF) + 56320);
                        } else {
                            throw new CharConversionException("Cannot convert U+" + Integer.toHexString(code) + " to char (code greater than U+10FFFF)");
                        }
                        if (this._start < this._end) continue;
                    }
                    return i - off;
                }
                cbuf[i++] = (char)b;
                return i - off;
            }
            return len;
        }

        @Override
        public void close() throws IOException {
        }

        private int read2() throws IOException {
            if (this._start < this._end) {
                byte b;
                if ((b = this._bytes[this._start++]) >= 0 && this._moreBytes == 0) {
                    return b;
                }
                if ((b & 0xC0) == 128 && this._moreBytes != 0) {
                    this._code = this._code << 6 | b & 0x3F;
                    if (--this._moreBytes == 0) {
                        return this._code;
                    }
                    return this.read2();
                }
                if ((b & 0xE0) == 192 && this._moreBytes == 0) {
                    this._code = b & 0x1F;
                    this._moreBytes = 1;
                    return this.read2();
                }
                if ((b & 0xF0) == 224 && this._moreBytes == 0) {
                    this._code = b & 0xF;
                    this._moreBytes = 2;
                    return this.read2();
                }
                if ((b & 0xF8) == 240 && this._moreBytes == 0) {
                    this._code = b & 7;
                    this._moreBytes = 3;
                    return this.read2();
                }
                throw new CharConversionException("Invalid UTF-8 Encoding");
            }
            if (this.fillBuffer()) {
                return this.read2();
            }
            if (this._moreBytes == 0) {
                return -1;
            }
            throw new CharConversionException("Unexpected end of stream");
        }

        @Override
        public void reset() {
            this._code = 0;
            this._end = 0;
            this._inputStream = null;
            this._moreBytes = 0;
            this._start = 0;
        }
    }
}

