/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import javax.realtime.MemoryArea;
import javolution37.javolution.lang.PersistentReference;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.realtime.RealtimeObject;
import javolution37.javolution.util.FastCollection;
import javolution37.javolution.util.FastComparator;

public class FastTable<E>
extends FastCollection<E>
implements List<E>,
Reusable,
RandomAccess {
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        @Override
        public Object create() {
            return new FastTable();
        }

        @Override
        public void cleanup(Object obj) {
            ((FastTable)obj).reset();
        }
    };
    private static final int D0 = 5;
    private static final int M0 = 31;
    private static final int C0 = 32;
    private static final int D1 = 7;
    private static final int R1 = 5;
    private static final int M1 = 127;
    private static final int C1 = 4096;
    private static final int D2 = 9;
    private static final int R2 = 12;
    private static final int M2 = 511;
    private static final int C2 = 0x200000;
    private static final int D3 = 11;
    private static final int R3 = 21;
    private E[][] _elems1 = new Object[1][];
    private E[][][] _elems2;
    private E[][][][] _elems3;
    private int _capacity = 32;
    private int _size;
    private static final Object[] NULL_BLOCK = new Object[32];

    public FastTable() {
        this._elems1[0] = new Object[32];
    }

    public FastTable(String id) {
        this();
        PersistentReference<FastTable<E>> ref = new PersistentReference<FastTable<E>>(id);
        FastTable persistentTable = (FastTable)ref.get();
        if (persistentTable != null) {
            this.addAll(persistentTable);
        }
        ref.set(this);
    }

    public FastTable(int capacity) {
        this();
        while (capacity > this._capacity) {
        }
    }

    public FastTable(Collection<? extends E> values) {
        this(values.size());
        this.addAll(values);
    }

    public static <E> FastTable<E> newInstance() {
        return (FastTable)FACTORY.object();
    }

    @Override
    public final E get(int index) {
        if (index >> 12 == 0 && index < this._size) {
            return this._elems1[index >> 5][index & 0x1F];
        }
        return this.get2(index);
    }

    private final E get2(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return index < 0x200000 ? this._elems2[index >> 12][index >> 5 & 0x7F][index & 0x1F] : this._elems3[index >> 21][index >> 12 & 0x1FF][index >> 5 & 0x7F][index & 0x1F];
    }

    @Override
    public final E set(int index, E value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        E[] elems = index < 4096 ? this._elems1[index >> 5] : (index < 0x200000 ? this._elems2[index >> 12][index >> 5 & 0x7F] : this._elems3[index >> 21][index >> 12 & 0x1FF][index >> 5 & 0x7F]);
        E oldValue = elems[index & 0x1F];
        elems[index & 0x1F] = value;
        return oldValue;
    }

    @Override
    public final boolean add(E value) {
        int i = this._size;
        if (i >= this._capacity) {
            this.increaseCapacity();
        }
        E[] elems = i < 4096 ? this._elems1[i >> 5] : (i < 0x200000 ? this._elems2[i >> 12][i >> 5 & 0x7F] : this._elems3[i >> 21][i >> 12 & 0x1FF][i >> 5 & 0x7F]);
        elems[i & 0x1F] = value;
        ++this._size;
        return true;
    }

    @Override
    public final E getFirst() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this._elems1[0][0];
    }

    @Override
    public final E getLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        int i = this._size - 1;
        E[] elems = i < 4096 ? this._elems1[i >> 5] : (i < 0x200000 ? this._elems2[i >> 12][i >> 5 & 0x7F] : this._elems3[i >> 21][i >> 12 & 0x1FF][i >> 5 & 0x7F]);
        return elems[i & 0x1F];
    }

    @Override
    public final void addLast(E value) {
        this.add(value);
    }

    @Override
    public final E removeLast() {
        int i;
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        E[] elems = (i = --this._size) < 4096 ? this._elems1[i >> 5] : (i < 0x200000 ? this._elems2[i >> 12][i >> 5 & 0x7F] : this._elems3[i >> 21][i >> 12 & 0x1FF][i >> 5 & 0x7F]);
        E oldValue = elems[i & 0x1F];
        elems[i & 0x1F] = null;
        return oldValue;
    }

    @Override
    public final void clear() {
        int size = this._size;
        this._size = 0;
        int blockSize = Math.min(size, 32);
        for (int i = 0; i < size; i += 32) {
            E[] elems = i < 4096 ? this._elems1[i >> 5] : (i < 0x200000 ? this._elems2[i >> 12][i >> 5 & 0x7F] : this._elems3[i >> 21][i >> 12 & 0x1FF][i >> 5 & 0x7F]);
            System.arraycopy(NULL_BLOCK, 0, elems, 0, blockSize);
        }
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int shift = values.size();
        int prevSize = this._size;
        int newSize = prevSize + shift;
        while (newSize >= this._capacity) {
            this.increaseCapacity();
        }
        this._size = newSize;
        int i = prevSize;
        while (--i >= index) {
            this.set(i + shift, this.get(i));
        }
        Iterator<E> valuesIterator = values.iterator();
        int n = index + shift;
        for (int i2 = index; i2 < n; ++i2) {
            this.set(i2, valuesIterator.next());
        }
        return shift != 0;
    }

    @Override
    public final void add(int index, E value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int prevSize = this._size;
        int newSize = prevSize + 1;
        if (newSize >= this._capacity) {
            this.increaseCapacity();
        }
        this._size = newSize;
        int i = index;
        int n = newSize;
        while (i < n) {
            value = this.set(i++, value);
        }
    }

    @Override
    public final E remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int lastIndex = this._size - 1;
        E obj = this.get(lastIndex);
        int i = lastIndex;
        while (--i >= index) {
            obj = this.set(i, obj);
        }
        this.set(lastIndex, null);
        this._size = lastIndex;
        return obj;
    }

    public final void removeRange(int fromIndex, int toIndex) {
        int newSize;
        int prevSize = this._size;
        if (fromIndex < 0 || toIndex < 0 || fromIndex > toIndex || toIndex > prevSize) {
            throw new IndexOutOfBoundsException();
        }
        int i = toIndex;
        int j = fromIndex;
        while (i < prevSize) {
            this.set(j++, this.get(i++));
        }
        int i2 = newSize = prevSize - toIndex + fromIndex;
        while (i2 < prevSize) {
            this.set(i2++, null);
        }
        this._size = newSize;
    }

    @Override
    public final int indexOf(Object value) {
        FastComparator comp = this.getValueComparator();
        int i = -1;
        while (++i < this._size) {
            if (!comp.areEqual(value, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object value) {
        FastComparator comp = this.getValueComparator();
        int i = this._size;
        while (--i >= 0) {
            if (!comp.areEqual(value, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final Iterator<E> iterator() {
        FastTableIterator i = (FastTableIterator)FastTableIterator.FACTORY.object();
        i._table = this;
        i._start = 0;
        i._end = this._size;
        i._nextIndex = 0;
        i._currentIndex = -1;
        return i;
    }

    @Override
    public final ListIterator<E> listIterator() {
        FastTableIterator i = (FastTableIterator)FastTableIterator.FACTORY.object();
        i._table = this;
        i._start = 0;
        i._end = this._size;
        i._nextIndex = 0;
        i._currentIndex = -1;
        return i;
    }

    @Override
    public final ListIterator<E> listIterator(int index) {
        if (index >= 0 && index <= this._size) {
            FastTableIterator i = (FastTableIterator)FastTableIterator.FACTORY.object();
            i._table = this;
            i._start = 0;
            i._end = this._size;
            i._nextIndex = index;
            i._currentIndex = -1;
            return i;
        }
        throw new IndexOutOfBoundsException("index: " + index + " for table of size: " + this._size);
    }

    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        SubTable st = (SubTable)SubTable.FACTORY.object();
        st._table = this;
        st._offset = fromIndex;
        st._size = toIndex - fromIndex;
        return st;
    }

    public final void trimToSize() {
        while (this._capacity > this._size + 32) {
            this.decreaseCapacity();
        }
    }

    public final void sort() {
        if (this._size > 1) {
            this.quicksort(0, this._size - 1, this.getValueComparator());
        }
    }

    private void quicksort(int first, int last, FastComparator cmp) {
        int pivIndex = 0;
        if (first < last) {
            pivIndex = this.partition(first, last, cmp);
            this.quicksort(first, pivIndex - 1, cmp);
            this.quicksort(pivIndex + 1, last, cmp);
        }
    }

    private int partition(int f, int l, FastComparator cmp) {
        E piv = this.get(f);
        int up = f;
        int down = l;
        while (true) {
            if (cmp.compare(this.get(up), piv) <= 0 && up < l) {
                ++up;
                continue;
            }
            while (cmp.compare(this.get(down), piv) > 0 && down > f) {
                --down;
            }
            if (up < down) {
                E temp = this.get(up);
                this.set(up, this.get(down));
                this.set(down, temp);
            }
            if (down <= up) break;
        }
        this.set(f, this.get(down));
        this.set(down, piv);
        return down;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final FastCollection.Record head() {
        return Index.MINUS_ONE;
    }

    @Override
    public final FastCollection.Record tail() {
        return (Index)Index.COLLECTION.get(this._size);
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return this.get(((Index)record)._position);
    }

    @Override
    public final void delete(FastCollection.Record record) {
        this.remove(((Index)record)._position);
    }

    @Override
    public void reset() {
        super.setValueComparator(FastComparator.DIRECT);
        this.clear();
    }

    @Override
    public List<E> unmodifiable() {
        return (List)super.unmodifiable();
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            @Override
            public void run() {
                int c = FastTable.this._capacity;
                FastTable.this._capacity = FastTable.this._capacity + 32;
                if (c < 4096) {
                    if (FastTable.this._elems1.length == 1) {
                        Object[][] tmp = new Object[128][];
                        tmp[0] = FastTable.this._elems1[0];
                        FastTable.access$1402(FastTable.this, tmp);
                    }
                    ((FastTable)FastTable.this)._elems1[c >> 5] = new Object[32];
                } else if (c < 0x200000) {
                    if (FastTable.this._elems2 == null) {
                        FastTable.access$1502(FastTable.this, new Object[512][][]);
                    }
                    if (FastTable.this._elems2[c >> 12] == null) {
                        ((FastTable)FastTable.this)._elems2[c >> 12] = new Object[128][];
                    }
                    ((FastTable)FastTable.this)._elems2[c >> 12][c >> 5 & 0x7F] = new Object[32];
                } else {
                    if (FastTable.this._elems3 == null) {
                        FastTable.access$1602(FastTable.this, new Object[11][][][]);
                    }
                    if (FastTable.this._elems3[c >> 21] == null) {
                        ((FastTable)FastTable.this)._elems3[c >> 21] = new Object[9][][];
                    }
                    if (FastTable.this._elems3[c >> 21][c >> 12 & 0x1FF] == null) {
                        ((FastTable)FastTable.this)._elems3[c >> 21][c >> 12 & 0x1FF] = new Object[7][];
                    }
                    ((FastTable)FastTable.this)._elems3[c >> 21][c >> 12 & 0x1FF][c >> 5 & 0x7F] = new Object[5];
                }
                if (FastTable.this._capacity >= Index.COLLECTION._size && FastTable.this != Index.COLLECTION) {
                    while (FastTable.this._capacity >= Index.COLLECTION._size) {
                        Index.augment();
                    }
                }
            }
        });
    }

    private void decreaseCapacity() {
        if (this._size >= this._capacity - 32) {
            throw new IllegalStateException();
        }
        int c = this._capacity;
        this._capacity -= 32;
        if (c < 4096) {
            this._elems1[c >> 5] = null;
            this._elems2 = null;
            this._elems3 = null;
        } else if (c < 0x200000) {
            this._elems2[c >> 12][c >> 5 & 0x7F] = null;
            this._elems3 = null;
        } else {
            this._elems3[c >> 21][c >> 12 & 0x1FF][c >> 5 & 0x7F] = null;
        }
    }

    static /* synthetic */ Object[][] access$1402(FastTable x0, Object[][] x1) {
        x0._elems1 = x1;
        return x1;
    }

    static /* synthetic */ Object[][][] access$1502(FastTable x0, Object[][][] x1) {
        x0._elems2 = x1;
        return x1;
    }

    static /* synthetic */ Object[][][][] access$1602(FastTable x0, Object[][][][] x1) {
        x0._elems3 = x1;
        return x1;
    }

    private static final class SubTable
    extends FastCollection
    implements List,
    RandomAccess {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            @Override
            protected Object create() {
                return new SubTable();
            }

            @Override
            protected void cleanup(Object obj) {
                SubTable st = (SubTable)obj;
                st._table = null;
            }
        };
        private FastTable _table;
        private int _offset;
        private int _size;

        private SubTable() {
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public FastCollection.Record head() {
            return Index.MINUS_ONE;
        }

        @Override
        public FastCollection.Record tail() {
            return (Index)Index.COLLECTION.get(this._size);
        }

        public Object valueOf(FastCollection.Record record) {
            return this._table.get(((Index)record)._position + this._offset);
        }

        @Override
        public void delete(FastCollection.Record record) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        public boolean addAll(int index, Collection values) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        public Object get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this._table.get(index + this._offset);
        }

        public Object set(int index, Object value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this._table.set(index + this._offset, value);
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        @Override
        public int indexOf(Object value) {
            FastComparator comp = this._table.getValueComparator();
            int i = -1;
            while (++i < this._size) {
                if (!comp.areEqual(value, this._table.get(i + this._offset))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            FastComparator comp = this._table.getValueComparator();
            int i = this._size;
            while (--i >= 0) {
                if (!comp.areEqual(value, this._table.get(i + this._offset))) continue;
                return i;
            }
            return -1;
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                FastTableIterator i = (FastTableIterator)FastTableIterator.FACTORY.object();
                i._table = this._table;
                i._start = this._offset;
                i._end = this._offset + this._size;
                i._nextIndex = index + this._offset;
                return i;
            }
            throw new IndexOutOfBoundsException("index: " + index + " for table of size: " + this._size);
        }

        public List subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubTable st = (SubTable)FACTORY.object();
            st._table = this._table;
            st._offset = this._offset + fromIndex;
            st._size = toIndex - fromIndex;
            return st;
        }
    }

    private static final class FastTableIterator
    extends RealtimeObject
    implements ListIterator {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            @Override
            protected Object create() {
                return new FastTableIterator();
            }

            @Override
            protected void cleanup(Object obj) {
                FastTableIterator i = (FastTableIterator)obj;
                i._table = null;
            }
        };
        private FastTable _table;
        private int _currentIndex;
        private int _start;
        private int _end;
        private int _nextIndex;

        private FastTableIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._end;
        }

        @Override
        public Object next() {
            if (this._nextIndex == this._end) {
                throw new NoSuchElementException();
            }
            this._currentIndex = this._nextIndex++;
            return this._table.get(this._currentIndex);
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != this._start;
        }

        public Object previous() {
            if (this._nextIndex == this._start) {
                throw new NoSuchElementException();
            }
            this._currentIndex = --this._nextIndex;
            return this._table.get(this._nextIndex);
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        public void add(Object o) {
            this._table.add(this._nextIndex++, o);
            ++this._end;
            this._currentIndex = -1;
        }

        public void set(Object o) {
            if (this._currentIndex < 0) {
                throw new IllegalStateException();
            }
            this._table.set(this._currentIndex, o);
        }

        @Override
        public void remove() {
            if (this._currentIndex >= 0) {
                this._table.remove(this._currentIndex);
                --this._end;
                if (this._currentIndex < this._nextIndex) {
                    --this._nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            this._currentIndex = -1;
        }
    }

    public static final class Index
    implements FastCollection.Record {
        private static final FastTable COLLECTION = new FastTable();
        private static final Index MINUS_ONE;
        private static Index CollectionLast;
        private int _position;
        private Index _next;
        private Index _previous;

        private Index() {
        }

        public static Index getInstance(int position) {
            if (position == -1) {
                return MINUS_ONE;
            }
            if (position < -1) {
                throw new IllegalArgumentException("position: Should be greater or equal to -1");
            }
            while (position >= COLLECTION.size()) {
                Index.augment();
            }
            return (Index)COLLECTION.get(position);
        }

        private static void augment() {
            MemoryArea.getMemoryArea(COLLECTION).executeInArea(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Index index = new Index();
                    FastTable fastTable = COLLECTION;
                    synchronized (fastTable) {
                        index._position = COLLECTION._size;
                        CollectionLast._next = index;
                        index._previous = CollectionLast;
                        COLLECTION.addLast(index);
                        CollectionLast = index;
                    }
                }
            });
        }

        @Override
        public final FastCollection.Record getNext() {
            return this._next;
        }

        @Override
        public final FastCollection.Record getPrevious() {
            return this._previous;
        }

        static {
            CollectionLast = MINUS_ONE = new Index();
            Index.MINUS_ONE._position = -1;
            while (COLLECTION._size <= 32) {
                Index.augment();
            }
        }
    }
}

