/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.realtime;

import javax.realtime.MemoryArea;
import javolution37.javolution.lang.Text;
import javolution37.javolution.realtime.Context;
import javolution37.javolution.realtime.ObjectFactory;
import javolution37.javolution.realtime.ObjectPool;
import javolution37.javolution.realtime.PoolContext;
import javolution37.javolution.realtime.Realtime;

public abstract class RealtimeObject
implements Realtime {
    private transient Pool _pool;
    private transient RealtimeObject _next;
    private transient RealtimeObject _previous;
    private transient int _preserved;

    protected RealtimeObject() {
    }

    public final String toString() {
        return this.toText().stringValue();
    }

    @Override
    public Text toText() {
        return Text.valueOf(this.getClass().getName()).concat(Text.valueOf('@')).concat(Text.valueOf(System.identityHashCode(this), 16));
    }

    public final <T> T export() {
        this.move(Realtime.ObjectSpace.OUTER);
        return (T)this;
    }

    public final <T> T moveHeap() {
        this.move(Realtime.ObjectSpace.HEAP);
        return (T)this;
    }

    public final <T> T preserve() {
        this.move(Realtime.ObjectSpace.HOLD);
        return (T)this;
    }

    public final <T> T unpreserve() {
        this.move(Realtime.ObjectSpace.STACK);
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean move(Realtime.ObjectSpace os) {
        if (os == Realtime.ObjectSpace.OUTER) {
            if (this._pool == null || !this._pool.isLocal()) {
                return false;
            }
            Pool outer = (Pool)this._pool.outer;
            if (outer == null) {
                return this.move(Realtime.ObjectSpace.HEAP);
            }
            this.detach();
            Pool pool = outer;
            synchronized (pool) {
                RealtimeObject outerObj = (RealtimeObject)outer.next();
                outerObj.detach();
                outerObj.insertBefore(this._pool._activeTail);
                outerObj._pool = this._pool;
                this.insertBefore(outer._next);
                this._pool = outer;
            }
            return true;
        }
        if (os == Realtime.ObjectSpace.HEAP) {
            RealtimeObject realtimeObject = this;
            synchronized (realtimeObject) {
                if (this._pool == null) {
                    return false;
                }
                Pool pool = this._pool;
                synchronized (pool) {
                    this.detach();
                    this._pool._size--;
                    this._next = null;
                    this._previous = null;
                    this._pool = null;
                    return true;
                }
            }
        }
        if (os == Realtime.ObjectSpace.HOLD) {
            RealtimeObject realtimeObject = this;
            synchronized (realtimeObject) {
                if (this._pool == null) {
                    return false;
                }
                if (this._preserved++ == 0) {
                    Pool pool = this._pool;
                    synchronized (pool) {
                        this.detach();
                        this.insertBefore(this._pool._holdTail);
                    }
                    return true;
                }
                return false;
            }
        }
        if (os == Realtime.ObjectSpace.STACK) {
            RealtimeObject realtimeObject = this;
            synchronized (realtimeObject) {
                if (this._preserved != 0 && --this._preserved == 0) {
                    if (this._pool != null) {
                        Pool pool = this._pool;
                        synchronized (pool) {
                            this.detach();
                            this.insertBefore(this._pool._next);
                        }
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected void recycle() {
        if (this._pool != null && this._pool.isLocal()) {
            this._pool.recycle(this);
        }
    }

    final void insertBefore(RealtimeObject next) {
        this._previous = next._previous;
        this._next = next;
        this._next._previous = this;
        this._previous._next = this;
    }

    final void detach() {
        this._next._previous = this._previous;
        this._previous._next = this._next;
    }

    private static final class Bound
    extends RealtimeObject {
        private Bound() {
        }
    }

    private static final class Pool
    extends ObjectPool {
        private final Factory _factory;
        private final MemoryArea _memoryArea;
        private int _size;
        private boolean _doCleanup = true;
        private final RealtimeObject _activeHead;
        private final RealtimeObject _activeTail;
        private final RealtimeObject _holdHead;
        private final RealtimeObject _holdTail;
        private RealtimeObject _next;

        private Pool(Factory factory) {
            this._factory = factory;
            this._memoryArea = MemoryArea.getMemoryArea(this);
            this._activeHead = new Bound();
            this._activeTail = new Bound();
            this._activeHead._next = this._activeTail;
            this._activeTail._previous = this._activeHead;
            this._holdHead = new Bound();
            this._holdTail = new Bound();
            this._holdHead._next = this._holdTail;
            this._holdTail._previous = this._holdHead;
            this._next = this._activeTail;
        }

        @Override
        public int size() {
            return this._size;
        }

        public Object next() {
            RealtimeObject next = this._next;
            this._next = next._next;
            return this._next != null ? next : this.allocate();
        }

        private RealtimeObject allocate() {
            this._next = this._activeTail;
            this._memoryArea.executeInArea(new Runnable(){

                @Override
                public void run() {
                    RealtimeObject obj = (RealtimeObject)Pool.this._factory.create();
                    Pool.this._size++;
                    obj.insertBefore(Pool.this._activeTail);
                    obj._pool = Pool.this;
                }
            });
            return this._activeTail._previous;
        }

        public void recycle(Object obj) {
            RealtimeObject rtObj;
            if (this._doCleanup) {
                try {
                    this._factory.cleanup(obj);
                }
                catch (UnsupportedOperationException ex) {
                    this._doCleanup = false;
                }
            }
            if ((rtObj = (RealtimeObject)obj)._pool != this) {
                throw new IllegalArgumentException("Object not in the pool");
            }
            rtObj.detach();
            rtObj.insertBefore(this._next);
            this._next = this._next._previous;
        }

        @Override
        protected void recycleAll() {
            if (this._doCleanup) {
                try {
                    RealtimeObject rt = this._activeHead._next;
                    while (rt != this._next) {
                        this._factory.cleanup(rt);
                        rt = rt._next;
                    }
                }
                catch (UnsupportedOperationException ex) {
                    this._doCleanup = false;
                }
            }
            this._next = this._activeHead._next;
        }

        @Override
        protected void clearAll() {
            this._activeHead._next = this._activeTail;
            this._activeTail._previous = this._activeHead;
        }
    }

    public static abstract class Factory<T extends RealtimeObject>
    extends ObjectFactory<T> {
        private Pool _cachedPool = new Pool(null);

        protected Factory() {
        }

        @Override
        public final T object() {
            Thread currentThread = Thread.currentThread();
            Pool pool = this._cachedPool;
            if (pool.user == currentThread) {
                RealtimeObject next = pool._next;
                return (T)((pool._next = next._next) != null ? next : pool.allocate());
            }
            PoolContext poolContext = Context.poolContext(currentThread);
            if (poolContext == null) {
                return (T)((RealtimeObject)this.create());
            }
            pool = (Pool)poolContext.getLocalPool(this._index);
            RealtimeObject obj = (RealtimeObject)pool.next();
            this._cachedPool = pool;
            return (T)obj;
        }

        @Override
        protected ObjectPool<T> newPool() {
            Pool pool = new Pool(this);
            return pool;
        }
    }
}

