/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.realtime;

import javax.realtime.MemoryArea;
import javolution37.javolution.lang.Reflection;
import javolution37.javolution.realtime.Context;
import javolution37.javolution.realtime.ObjectFactory;
import javolution37.javolution.realtime.ObjectPool;
import javolution37.javolution.util.FastCollection;
import javolution37.javolution.util.FastMap;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlException;
import javolution37.javolution.xml.XmlFormat;

public class PoolContext
extends Context {
    protected static final XmlFormat XML = new XmlFormat("javolution37.javolution.realtime.PoolContext"){

        public void format(Object obj, XmlElement xml) {
            PoolContext ctx = (PoolContext)obj;
            FastMap<Class<?>, Integer> pools = FastMap.newInstance();
            int i = ObjectFactory.Count;
            while (--i >= 0) {
                int size = ctx._pools[i].size();
                if (size <= 0) continue;
                pools.put(ObjectFactory.INSTANCES[i].getClass(), new Integer(size));
            }
            xml.add(pools);
        }

        public Object parse(XmlElement xml) {
            PoolContext ctx = (PoolContext)xml.object();
            FastMap pools = (FastMap)xml.getNext();
            FastCollection.Record e = pools.head();
            FastMap.Entry end = pools.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                Class factoryClass = (Class)((FastMap.Entry)e).getKey();
                int size = (Integer)((FastMap.Entry)e).getValue();
                ObjectFactory factory = ObjectFactory.getInstance(factoryClass);
                if (factory == null) {
                    throw new XmlException("Factory for class " + factoryClass + " not found");
                }
                ObjectPool pool = factory.newPool();
                while (pool.size() < size) {
                    pool.next();
                }
                pool.recycleAll();
                ctx._pools[factory._index] = pool;
            }
            return ctx;
        }
    };
    private static final Class CLASS = Reflection.getClass("javolution37.javolution.realtime.PoolContext");
    final ObjectPool[] _pools = new ObjectPool[ObjectFactory.MAX];
    private final ObjectPool[] _inUsePools = new ObjectPool[ObjectFactory.MAX];
    private int _inUsePoolsLength;

    public PoolContext() {
        int i = this._pools.length;
        while (i > 0) {
            this._pools[--i] = ObjectPool.NULL;
        }
    }

    public static PoolContext current() {
        return Context.poolContext(Thread.currentThread());
    }

    public static void enter() {
        Context.enter(CLASS);
    }

    public static void exit() {
        Context.exit(CLASS);
    }

    @Override
    public void clear() {
        super.clear();
        int i = ObjectFactory.Count;
        while (i > 0) {
            ObjectPool pool;
            if ((pool = this._pools[--i]) == ObjectPool.NULL) continue;
            pool.clearAll();
        }
        this._inUsePoolsLength = 0;
    }

    @Override
    protected void enterAction() {
        this.inheritedPoolContext = this;
        PoolContext outer = this.getOuter().inheritedPoolContext;
        if (outer != null) {
            outer.setInUsePoolsLocal(false);
        }
    }

    @Override
    protected void exitAction() {
        this.recyclePools();
        PoolContext outer = this.getOuter().inheritedPoolContext;
        if (outer != null) {
            outer.setInUsePoolsLocal(true);
        }
    }

    void setInUsePoolsLocal(boolean areLocal) {
        Thread user = areLocal ? this.getOwner() : null;
        int i = this._inUsePoolsLength;
        while (i > 0) {
            this._inUsePools[--i].user = user;
        }
    }

    ObjectPool getLocalPool(int index) {
        ObjectPool pool = this._pools[index];
        return pool.user != null ? pool : this.getLocalPool2(index);
    }

    private ObjectPool getLocalPool2(int index) {
        ObjectPool pool = this.getPool(index);
        pool.user = this.getOwner();
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectPool getPool(final int index) {
        ObjectPool pool = this._pools[index];
        if (pool == ObjectPool.NULL) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                @Override
                public void run() {
                    PoolContext.this._pools[index] = ObjectFactory.INSTANCES[index].newPool();
                }
            });
        }
        pool = this._pools[index];
        if (!pool.inUse) {
            pool.inUse = true;
            this._inUsePools[this._inUsePoolsLength++] = pool;
            PoolContext outerPoolContext = this.getOuter().inheritedPoolContext;
            if (outerPoolContext != null) {
                PoolContext poolContext = outerPoolContext;
                synchronized (poolContext) {
                    pool.outer = outerPoolContext.getPool(index);
                }
            } else {
                pool.outer = null;
            }
        }
        return pool;
    }

    void recyclePools() {
        int i = this._inUsePoolsLength;
        while (i > 0) {
            ObjectPool pool = this._inUsePools[--i];
            pool.recycleAll();
            pool.user = null;
            pool.inUse = false;
        }
        this._inUsePoolsLength = 0;
    }
}

