/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.lang;

import java.io.IOException;
import java.text.ParsePosition;
import javolution37.javolution.lang.CharSet;
import javolution37.javolution.lang.Text;
import javolution37.javolution.lang.TextBuilder;
import javolution37.javolution.realtime.ObjectFactory;

public abstract class TextFormat<T> {
    protected TextFormat() {
    }

    public abstract Appendable format(T var1, Appendable var2) throws IOException;

    public abstract T parse(CharSequence var1, Cursor var2);

    public final Text format(T obj) {
        try {
            TextBuilder tb = TextBuilder.newInstance();
            this.format(obj, tb);
            return tb.toText();
        }
        catch (IOException e) {
            throw new Error();
        }
    }

    public final T parse(CharSequence csq) {
        Cursor cursor = Cursor.newInstance();
        try {
            T obj = this.parse(csq, cursor);
            if (cursor.getIndex() != csq.length()) {
                throw new IllegalArgumentException("Parsing of " + csq + " incomplete (terminated at index: " + cursor.getIndex() + ")");
            }
            T t = obj;
            return t;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Cannot parse \"" + csq + "\" (" + e.toString() + ")");
        }
        finally {
            cursor.recycle();
        }
    }

    public static class Cursor
    extends ParsePosition {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            public Object create() {
                return new Cursor();
            }
        };
        private int _index;

        private Cursor() {
            super(0);
        }

        public static Cursor newInstance() {
            Cursor cursor = (Cursor)FACTORY.object();
            cursor._index = 0;
            return cursor;
        }

        @Override
        public final int getIndex() {
            return this._index;
        }

        @Override
        public final void setIndex(int i) {
            this._index = i;
        }

        public final boolean hasNext(CharSequence csq) {
            return this._index < csq.length();
        }

        public final char next(CharSequence csq) {
            return csq.charAt(this._index++);
        }

        public final boolean skip(char c, CharSequence csq) {
            int length = csq.length();
            while (this._index < length && csq.charAt(this._index) == c) {
                ++this._index;
            }
            return this._index < length;
        }

        public final boolean skip(CharSet charSet, CharSequence csq) {
            int length = csq.length();
            while (this._index < length && charSet.contains(csq.charAt(this._index))) {
                ++this._index;
            }
            return this._index < length;
        }

        public final void increment() {
            ++this._index;
        }

        public final void increment(int i) {
            this._index += i;
        }

        public final void recycle() {
            FACTORY.currentPool().recycle(this);
        }
    }
}

