/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.lang;

import java.io.IOException;
import java.io.Serializable;
import javax.realtime.MemoryArea;
import javolution37.javolution.JavolutionError;
import javolution37.javolution.lang.CharSet;
import javolution37.javolution.lang.Immutable;
import javolution37.javolution.lang.TypeFormat;
import javolution37.javolution.realtime.HeapContext;
import javolution37.javolution.realtime.Realtime;
import javolution37.javolution.realtime.RealtimeObject;
import javolution37.javolution.util.FastComparator;
import javolution37.javolution.util.FastMap;

public abstract class Text
extends RealtimeObject
implements CharSequence,
Comparable,
Serializable,
Immutable {
    private static final FastMap INTERN_TEXT = new FastMap().setKeyComparator(FastComparator.LEXICAL);
    public static final Text EMPTY = Text.intern("");
    public static final Text NULL = Text.intern("null");
    int _count;
    int _hashCode;
    private static final Text TRUE = Text.intern("true");
    private static final Text FALSE = Text.intern("false");
    private static final Text[] ASCII = new Text[128];

    private Text() {
    }

    public static Text valueOf(Object obj) {
        if (obj instanceof String) {
            return StringWrapper.newInstance((String)obj);
        }
        if (obj instanceof Realtime) {
            return ((Realtime)obj).toText();
        }
        if (obj instanceof CharSequence) {
            CharSequence csq = (CharSequence)obj;
            return Text.valueOf(csq, 0, csq.length());
        }
        if (obj != null) {
            return StringWrapper.newInstance(obj.toString());
        }
        return NULL;
    }

    public static Text valueOf(CharSequence csq, int start, int end) {
        if (start < 0 || end < 0 || start > end || end > csq.length()) {
            throw new IndexOutOfBoundsException();
        }
        int length = end - start;
        if (length <= 32) {
            Primitive text = Primitive.newInstance(length);
            int i = 0;
            while (i < length) {
                ((Primitive)text)._data[i] = csq.charAt(start + i++);
            }
            return text;
        }
        int middle = start + (length >> 1);
        Composite text = Composite.newInstance(Text.valueOf(csq, start, middle), Text.valueOf(csq, middle, end));
        return text;
    }

    public static Text valueOf(char[] chars) {
        return Text.valueOf(chars, 0, chars.length);
    }

    public static Text valueOf(char[] chars, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > chars.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length <= 32) {
            Primitive text = Primitive.newInstance(length);
            int i = 0;
            while (i < length) {
                ((Primitive)text)._data[i] = chars[offset + i++];
            }
            return text;
        }
        int middle = offset + (length >> 1);
        Composite text = Composite.newInstance(Text.valueOf(chars, offset, middle - offset), Text.valueOf(chars, middle, offset + length - middle));
        return text;
    }

    public static Text valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static Text valueOf(char c) {
        if (c < '\u0080' && ASCII[c] != null) {
            return ASCII[c];
        }
        Primitive text = Primitive.newInstance(1);
        ((Primitive)text)._data[0] = c;
        Text textIntern = Text.intern(text);
        if (c < '\u0080') {
            Text.ASCII[c] = textIntern;
        }
        return textIntern;
    }

    public static Text valueOf(int i) {
        try {
            Primitive text = Primitive.newInstance(0);
            TypeFormat.format(i, (Appendable)text);
            return text;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public static Text valueOf(int i, int radix) {
        try {
            Primitive text = Primitive.newInstance(0);
            TypeFormat.format(i, radix, (Appendable)text);
            return text;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public static Text valueOf(long l) {
        try {
            Primitive text = Primitive.newInstance(0);
            TypeFormat.format(l, (Appendable)text);
            return text;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public static Text valueOf(long l, int radix) {
        try {
            Primitive text = Primitive.newInstance(0);
            TypeFormat.format(l, radix, (Appendable)text);
            return text;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public static Text valueOf(float f) {
        try {
            Primitive text = Primitive.newInstance(0);
            TypeFormat.format(f, (Appendable)text);
            return text;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public static Text valueOf(double d) {
        try {
            Primitive text = Primitive.newInstance(0);
            TypeFormat.format(d, (Appendable)text);
            return text;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public static Text valueOf(double value, int digits, boolean scientific, boolean showZero) {
        try {
            Primitive text = Primitive.newInstance(0);
            TypeFormat.format(value, digits, scientific, showZero, text);
            return text;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    @Override
    public final int length() {
        return this._count;
    }

    public final Text plus(Object obj) {
        return this.concat(Text.valueOf(obj));
    }

    public final Text concat(Text that) {
        if (this._count == 0) {
            return that;
        }
        if (that._count == 0) {
            return this;
        }
        if (that._count << 1 < this._count && this instanceof Composite) {
            Composite thisComposite = (Composite)this;
            if (((Composite)thisComposite)._head._count > ((Composite)thisComposite)._tail._count) {
                return Composite.newInstance(thisComposite._head, thisComposite._tail.concat(that));
            }
            return Composite.newInstance(this, that);
        }
        if (this._count << 1 < that._count && that instanceof Composite) {
            Composite thatComposite = (Composite)that;
            if (((Composite)thatComposite)._head._count < ((Composite)thatComposite)._tail._count) {
                return Composite.newInstance(this.concat(thatComposite._head), thatComposite._tail);
            }
            return Composite.newInstance(this, that);
        }
        return Composite.newInstance(this, that);
    }

    public final Text subtext(int start) {
        return this.subtext(start, this.length());
    }

    public final Text insert(int index, Text txt) {
        return index << 1 < this._count ? this.subtext(0, index).concat(txt).concat(this.subtext(index)) : this.subtext(0, index).concat(txt.concat(this.subtext(index)));
    }

    public final Text delete(int start, int end) {
        return this.subtext(0, start).concat(this.subtext(end));
    }

    public final Text replace(Text target, Text replacement) {
        int i = this.indexOf(target);
        return i < 0 ? this : this.subtext(0, i).concat(replacement).concat(this.subtext(i + target.length()).replace(target, replacement));
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.subtext(start, end);
    }

    public final int indexOf(CharSequence csq) {
        return this.indexOf(csq, 0);
    }

    public final int indexOf(CharSequence csq, int fromIndex) {
        int csqLength = csq.length();
        int min = Math.max(0, fromIndex);
        int max = this._count - csqLength;
        if (csqLength == 0) {
            return min > max ? -1 : min;
        }
        char c = csq.charAt(0);
        int i = this.indexOf(c, min);
        while (i >= 0 && i <= max) {
            boolean match = true;
            for (int j = 1; j < csqLength; ++j) {
                if (this.charAt(i + j) == csq.charAt(j)) continue;
                match = false;
                break;
            }
            if (match) {
                return i;
            }
            ++i;
            i = this.indexOf(c, i);
        }
        return -1;
    }

    public final int lastIndexOf(CharSequence csq) {
        return this.lastIndexOf(csq, this._count);
    }

    public final int lastIndexOf(CharSequence csq, int fromIndex) {
        int csqLength = csq.length();
        boolean min = false;
        int max = Math.min(fromIndex, this._count - csqLength);
        if (csqLength == 0) {
            return 0 > max ? -1 : max;
        }
        char c = csq.charAt(0);
        int i = this.lastIndexOf(c, max);
        while (i >= 0) {
            boolean match = true;
            for (int j = 1; j < csqLength; ++j) {
                if (this.charAt(i + j) == csq.charAt(j)) continue;
                match = false;
                break;
            }
            if (match) {
                return i;
            }
            --i;
            i = this.lastIndexOf(c, i);
        }
        return -1;
    }

    public final boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public final boolean endsWith(CharSequence suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    public final boolean startsWith(CharSequence prefix, int index) {
        int prefixLength = prefix.length();
        if (index >= 0 && index <= this.length() - prefixLength) {
            int i = 0;
            int j = index;
            while (i < prefixLength) {
                if (prefix.charAt(i++) == this.charAt(j++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final Text trim() {
        int first;
        int last = this.length() - 1;
        for (first = 0; first <= last && this.charAt(first) <= ' '; ++first) {
        }
        while (last >= first && this.charAt(last) <= ' ') {
            --last;
        }
        return this.subtext(first, last + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Text intern(final CharSequence csq) {
        Text text = (Text)INTERN_TEXT.get(csq);
        if (text != null) {
            return text;
        }
        FastMap fastMap = INTERN_TEXT;
        synchronized (fastMap) {
            text = (Text)INTERN_TEXT.get(csq);
            if (text != null) {
                return text;
            }
            MemoryArea.getMemoryArea(INTERN_TEXT).executeInArea(new Runnable(){

                @Override
                public void run() {
                    HeapContext.enter();
                    try {
                        Text tmp = Text.valueOf(csq, 0, csq.length());
                        INTERN_TEXT.put(tmp, tmp);
                    }
                    finally {
                        HeapContext.exit();
                    }
                }
            });
        }
        return (Text)INTERN_TEXT.get(csq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Text intern(final String str) {
        Text text = (Text)INTERN_TEXT.get(str);
        if (text != null) {
            return text;
        }
        FastMap fastMap = INTERN_TEXT;
        synchronized (fastMap) {
            text = (Text)INTERN_TEXT.get(str);
            if (text != null) {
                return text;
            }
            MemoryArea.getMemoryArea(INTERN_TEXT).executeInArea(new Runnable(){

                @Override
                public void run() {
                    HeapContext.enter();
                    try {
                        Text tmp = Text.valueOf(new String(str));
                        INTERN_TEXT.put(tmp, tmp);
                    }
                    finally {
                        HeapContext.exit();
                    }
                }
            });
        }
        return (Text)INTERN_TEXT.get(str);
    }

    public final boolean contentEquals(CharSequence csq) {
        if (csq.length() != this._count) {
            return false;
        }
        int i = 0;
        while (i < this._count) {
            if (this.charAt(i) == csq.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    public final boolean contentEqualsIgnoreCase(CharSequence csq) {
        if (this._count != csq.length()) {
            return false;
        }
        int i = 0;
        while (i < this._count) {
            char u2;
            char u1 = this.charAt(i);
            if (u1 == (u2 = csq.charAt(i++)) || (u1 = Character.toUpperCase(u1)) == (u2 = Character.toUpperCase(u2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Text)) {
            return false;
        }
        Text that = (Text)obj;
        if (this._count != that._count) {
            return false;
        }
        int i = 0;
        while (i < this._count) {
            if (this.charAt(i) == that.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        int h = this._hashCode;
        int length = this.length();
        int i = 0;
        while (i < length) {
            h = 31 * h + this.charAt(i++);
        }
        this._hashCode = h;
        return this._hashCode;
    }

    public final int compareTo(Object csq) {
        return FastComparator.LEXICAL.compare(this, csq);
    }

    @Override
    public final Text toText() {
        return this;
    }

    public final Text copy() {
        return Text.valueOf(this, 0, this._count);
    }

    public abstract int depth();

    @Override
    public abstract char charAt(int var1);

    public abstract int indexOf(char var1, int var2);

    public abstract int lastIndexOf(char var1, int var2);

    public abstract Text subtext(int var1, int var2);

    public abstract void getChars(int var1, int var2, char[] var3, int var4);

    public abstract Text toLowerCase();

    public abstract Text toUpperCase();

    public abstract String stringValue();

    public static Text valueOf(char c, int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length <= 32) {
            Primitive text = Primitive.newInstance(length);
            int i = 0;
            while (i < length) {
                ((Primitive)text)._data[i++] = c;
            }
            return text;
        }
        int middle = length >> 1;
        return Composite.newInstance(Text.valueOf(c, middle), Text.valueOf(c, length - middle));
    }

    public final boolean isBlank() {
        return this.isBlank(0, this.length());
    }

    public final boolean isBlank(int start, int length) {
        while (start < length) {
            if (this.charAt(start) > ' ') {
                return false;
            }
            ++start;
        }
        return true;
    }

    public final Text trimStart() {
        int first;
        int last = this.length() - 1;
        for (first = 0; first <= last && this.charAt(first) <= ' '; ++first) {
        }
        return this.subtext(first, last + 1);
    }

    public final Text trimEnd() {
        int last;
        int first = 0;
        for (last = this.length() - 1; last >= first && this.charAt(last) <= ' '; --last) {
        }
        return this.subtext(first, last + 1);
    }

    public final Text padLeft(int len) {
        return this.padLeft(len, ' ');
    }

    public final Text padLeft(int len, char c) {
        int padSize = len <= this.length() ? 0 : len - this.length();
        return this.insert(0, Text.valueOf(c, padSize));
    }

    public final Text padRight(int len) {
        return this.padRight(len, ' ');
    }

    public final Text padRight(int len, char c) {
        int padSize = len <= this.length() ? 0 : len - this.length();
        return this.concat(Text.valueOf(c, padSize));
    }

    public final int indexOfAny(CharSet charSet) {
        return this.indexOfAny(charSet, 0, this.length());
    }

    public final int indexOfAny(CharSet charSet, int start) {
        return this.indexOfAny(charSet, start, this.length());
    }

    public final int indexOfAny(CharSet charSet, int start, int length) {
        int stop = start + length;
        for (int i = start; i < stop; ++i) {
            if (!charSet.contains(this.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOfAny(CharSet charSet) {
        return this.lastIndexOfAny(charSet, 0, this.length());
    }

    public final int lastIndexOfAny(CharSet charSet, int start) {
        return this.lastIndexOfAny(charSet, start, this.length() - start);
    }

    public final int lastIndexOfAny(CharSet charSet, int start, int length) {
        int i = start + length;
        while (--i >= start) {
            if (!charSet.contains(this.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static final class StringWrapper
    extends Text {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            @Override
            public Object create() {
                return new StringWrapper();
            }
        };
        private String _string;
        private int _offset;

        private StringWrapper() {
        }

        private static StringWrapper newInstance(String str) {
            StringWrapper text = (StringWrapper)FACTORY.object();
            text._count = str.length();
            text._hashCode = 0;
            text._string = str;
            text._offset = 0;
            return text;
        }

        @Override
        public int depth() {
            return 0;
        }

        @Override
        public char charAt(int index) {
            if (index >= this._count || index < 0) {
                throw new IndexOutOfBoundsException();
            }
            return this._string.charAt(this._offset + index);
        }

        @Override
        public int indexOf(char c, int fromIndex) {
            for (int i = Math.max(fromIndex, 0); i < this._count; ++i) {
                if (this._string.charAt(this._offset + i) != c) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(char c, int fromIndex) {
            for (int i = Math.min(fromIndex, this._count - 1); i >= 0; --i) {
                if (this._string.charAt(this._offset + i) != c) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Text subtext(int start, int end) {
            if (start == 0 && end == this._count) {
                return this;
            }
            if (start < 0 || start > end || end > this._count) {
                throw new IndexOutOfBoundsException();
            }
            if (start == end) {
                return EMPTY;
            }
            StringWrapper text = (StringWrapper)FACTORY.object();
            text._count = end - start;
            text._hashCode = 0;
            text._string = this._string;
            text._offset = this._offset + start;
            return text;
        }

        @Override
        public void getChars(int start, int end, char[] dest, int destPos) {
            if (end > this._count || end < start || start < 0) {
                throw new IndexOutOfBoundsException();
            }
            this._string.getChars(start + this._offset, end + this._offset, dest, destPos);
        }

        @Override
        public Text toLowerCase() {
            return this.copy().toLowerCase();
        }

        @Override
        public Text toUpperCase() {
            return this.copy().toUpperCase();
        }

        @Override
        public String stringValue() {
            if (this._offset == 0 && this._count == this._string.length()) {
                return this._string;
            }
            return this._string.substring(this._offset, this._offset + this._count);
        }
    }

    private static final class Composite
    extends Text {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            @Override
            public Object create() {
                return new Composite();
            }
        };
        private Text _head;
        private Text _tail;

        private Composite() {
        }

        private static Composite newInstance(Text head, Text tail) {
            Composite text = (Composite)FACTORY.object();
            text._hashCode = 0;
            text._count = head._count + tail._count;
            text._head = head;
            text._tail = tail;
            return text;
        }

        @Override
        public int depth() {
            return Math.max(this._head.depth(), this._tail.depth()) + 1;
        }

        @Override
        public char charAt(int index) {
            return index < this._head._count ? this._head.charAt(index) : this._tail.charAt(index - this._head._count);
        }

        @Override
        public int indexOf(char c, int fromIndex) {
            int headIndex;
            int cesure = this._head._count;
            if (fromIndex < cesure && (headIndex = this._head.indexOf(c, fromIndex)) >= 0) {
                return headIndex;
            }
            int tailIndex = this._tail.indexOf(c, fromIndex - cesure);
            return tailIndex >= 0 ? tailIndex + cesure : -1;
        }

        @Override
        public int lastIndexOf(char c, int fromIndex) {
            int tailIndex;
            int cesure = this._head._count;
            if (fromIndex >= cesure && (tailIndex = this._tail.lastIndexOf(c, fromIndex - cesure)) >= 0) {
                return tailIndex + cesure;
            }
            return this._head.lastIndexOf(c, fromIndex);
        }

        @Override
        public Text subtext(int start, int end) {
            int cesure = this._head._count;
            if (end <= cesure) {
                return this._head.subtext(start, end);
            }
            if (start >= cesure) {
                return this._tail.subtext(start - cesure, end - cesure);
            }
            if (start == 0 && end == this._count) {
                return this;
            }
            return this._head.subtext(start, cesure).concat(this._tail.subtext(0, end - cesure));
        }

        @Override
        public void getChars(int start, int end, char[] dest, int destPos) {
            int cesure = this._head._count;
            if (end <= cesure) {
                this._head.getChars(start, end, dest, destPos);
            } else if (start >= cesure) {
                this._tail.getChars(start - cesure, end - cesure, dest, destPos);
            } else {
                this._head.getChars(start, cesure, dest, destPos);
                this._tail.getChars(0, end - cesure, dest, destPos + cesure - start);
            }
        }

        @Override
        public Text toLowerCase() {
            return Composite.newInstance(this._head.toLowerCase(), this._tail.toLowerCase());
        }

        @Override
        public Text toUpperCase() {
            return Composite.newInstance(this._head.toUpperCase(), this._tail.toUpperCase());
        }

        @Override
        public String stringValue() {
            char[] data = new char[this._count];
            this.getChars(0, this._count, data, 0);
            return new String(data, 0, this._count);
        }

        @Override
        public boolean move(Realtime.ObjectSpace os) {
            if (super.move(os)) {
                this._head.move(os);
                this._tail.move(os);
                return true;
            }
            return false;
        }
    }

    private static final class Primitive
    extends Text
    implements Appendable {
        private static final int BLOCK_SIZE = 32;
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            @Override
            public Object create() {
                return new Primitive();
            }
        };
        private final char[] _data = new char[32];

        private Primitive() {
        }

        private static Primitive newInstance(int length) {
            Primitive text = (Primitive)FACTORY.object();
            text._count = length;
            text._hashCode = 0;
            return text;
        }

        @Override
        public int depth() {
            return 0;
        }

        @Override
        public char charAt(int index) {
            if (index >= this._count) {
                throw new IndexOutOfBoundsException();
            }
            return this._data[index];
        }

        @Override
        public int indexOf(char c, int fromIndex) {
            for (int i = Math.max(fromIndex, 0); i < this._count; ++i) {
                if (this._data[i] != c) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(char c, int fromIndex) {
            for (int i = Math.min(fromIndex, this._count - 1); i >= 0; --i) {
                if (this._data[i] != c) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Text subtext(int start, int end) {
            if (start == 0 && end == this._count) {
                return this;
            }
            if (start < 0 || start > end || end > this._count) {
                throw new IndexOutOfBoundsException();
            }
            if (start == end) {
                return EMPTY;
            }
            Primitive text = Primitive.newInstance(end - start);
            int i = start;
            int j = 0;
            while (i < end) {
                text._data[j++] = this._data[i++];
            }
            return text;
        }

        @Override
        public void getChars(int start, int end, char[] dest, int destPos) {
            if (end > this._count || end < start) {
                throw new IndexOutOfBoundsException();
            }
            int i = start;
            int j = destPos;
            while (i < end) {
                dest[j++] = this._data[i++];
            }
        }

        @Override
        public Text toLowerCase() {
            Primitive text = Primitive.newInstance(this._count);
            int i = 0;
            while (i < this._count) {
                text._data[i] = Character.toLowerCase(this._data[i++]);
            }
            return text;
        }

        @Override
        public Text toUpperCase() {
            Primitive text = Primitive.newInstance(this._count);
            int i = 0;
            while (i < this._count) {
                text._data[i] = Character.toUpperCase(this._data[i++]);
            }
            return text;
        }

        @Override
        public String stringValue() {
            return new String(this._data, 0, this._count);
        }

        @Override
        public Appendable append(char c) throws IOException {
            this._data[this._count++] = c;
            return this;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            return this.append(csq, 0, csq.length());
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            int i = start;
            while (i < end) {
                this._data[this._count++] = csq.charAt(i++);
            }
            return this;
        }
    }
}

