/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import javolution37.javolution.JavolutionError;
import javolution37.javolution.io.Utf8ByteBufferReader;
import javolution37.javolution.io.Utf8ByteBufferWriter;
import javolution37.javolution.lang.Reflection;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Struct {
    protected Struct _outer;
    private ByteBuffer _byteBuffer;
    protected int _outerOffset;
    private int _bitsUsed;
    protected int _alignment = 1;
    private int _bitIndex;
    private boolean _resetIndex = this.isUnion();
    private byte[] _bytes;
    private static final Reflection.Method ADDRESS_METHOD = Reflection.getMethod("sun.nio.ch.DirectBuffer.address()");
    private static final char[] HEXA = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Class BOOL = new Bool[0].getClass();
    private static final Class SIGNED_8 = new Signed8[0].getClass();
    private static final Class UNSIGNED_8 = new Unsigned8[0].getClass();
    private static final Class SIGNED_16 = new Signed16[0].getClass();
    private static final Class UNSIGNED_16 = new Unsigned16[0].getClass();
    private static final Class SIGNED_32 = new Signed32[0].getClass();
    private static final Class UNSIGNED_32 = new Unsigned32[0].getClass();
    private static final Class SIGNED_64 = new Signed64[0].getClass();
    private static final Class FLOAT_32 = new Float32[0].getClass();
    private static final Class FLOAT_64 = new Float64[0].getClass();

    public final int size() {
        int nbrOfBytes = this._bitsUsed + 7 >> 3;
        return nbrOfBytes % this._alignment == 0 ? nbrOfBytes : nbrOfBytes + this._alignment - nbrOfBytes % this._alignment;
    }

    public final ByteBuffer getByteBuffer() {
        if (this._outer != null) {
            return this._outer.getByteBuffer();
        }
        return this._byteBuffer != null ? this._byteBuffer : this.newBuffer();
    }

    private synchronized ByteBuffer newBuffer() {
        if (this._byteBuffer != null) {
            return this._byteBuffer;
        }
        int size = this.size();
        int capacity = this.isPacked() ? ((size & 7) == 0 ? size : size + 8 - (size & 7)) : size;
        ByteBuffer bf = ByteBuffer.allocateDirect(capacity);
        bf.order(this.byteOrder());
        this.setByteBuffer(bf, 0);
        return this._byteBuffer;
    }

    public final Struct setByteBuffer(ByteBuffer byteBuffer, int position) {
        if (byteBuffer.order() != this.byteOrder()) {
            throw new IllegalArgumentException("The byte order of the specified byte buffer is different from this struct byte order");
        }
        if (this._outer != null) {
            throw new UnsupportedOperationException("Inner struct byte buffer is inherited from outer");
        }
        this._byteBuffer = byteBuffer;
        this._outerOffset = position;
        return this;
    }

    public final Struct setByteBufferPosition(int position) {
        return this.setByteBuffer(this.getByteBuffer(), position);
    }

    public final int getByteBufferPosition() {
        return this._outer != null ? this._outer.getByteBufferPosition() + this._outerOffset : this._outerOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(InputStream in) throws IOException {
        ByteBuffer buffer = this.getByteBuffer();
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + this.getByteBufferPosition();
            return in.read(buffer.array(), offset, this.size());
        }
        ByteBuffer byteBuffer = buffer;
        synchronized (byteBuffer) {
            if (this._bytes == null) {
                this._bytes = new byte[this.size()];
            }
            int bytesRead = in.read(this._bytes);
            buffer.position(this.getByteBufferPosition());
            buffer.put(this._bytes);
            return bytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException {
        ByteBuffer buffer = this.getByteBuffer();
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + this.getByteBufferPosition();
            out.write(buffer.array(), offset, this.size());
        } else {
            ByteBuffer byteBuffer = buffer;
            synchronized (byteBuffer) {
                if (this._bytes == null) {
                    this._bytes = new byte[this.size()];
                }
                buffer.position(this.getByteBufferPosition());
                buffer.get(this._bytes);
                out.write(this._bytes);
            }
        }
    }

    public final long address() {
        ByteBuffer thisBuffer = this.getByteBuffer();
        if (ADDRESS_METHOD != null) {
            Long start = (Long)ADDRESS_METHOD.invoke(thisBuffer);
            return start + (long)this.getByteBufferPosition();
        }
        throw new UnsupportedOperationException("Operation not supported for " + thisBuffer.getClass());
    }

    public String toString() {
        int size = this.size();
        StringBuffer sb = new StringBuffer(size * 3);
        ByteBuffer buffer = this.getByteBuffer();
        int start = this.getByteBufferPosition();
        for (int i = 0; i < size; ++i) {
            int b = buffer.get(start + i) & 0xFF;
            sb.append(HEXA[b >> 4]);
            sb.append(HEXA[b & 0xF]);
            sb.append((i & 0xF) == 15 ? (char)'\n' : ' ');
        }
        return sb.toString();
    }

    public boolean isUnion() {
        return false;
    }

    public ByteOrder byteOrder() {
        return this._outer != null ? this._outer.byteOrder() : ByteOrder.BIG_ENDIAN;
    }

    public boolean isPacked() {
        return this._outer != null ? this._outer.isPacked() : false;
    }

    protected <S extends Struct> S inner(S struct) {
        if (struct._outer != null) {
            throw new IllegalArgumentException("struct: Already an inner struct");
        }
        struct._outer = this;
        int bitSize = struct.size() << 3;
        this.updateIndexes(struct._alignment, bitSize, bitSize);
        struct._outerOffset = this._bitIndex - bitSize >> 3;
        return struct;
    }

    protected <S extends Struct> S[] array(S[] structs) {
        Class structClass = null;
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        int i = 0;
        while (i < structs.length) {
            Object struct = structs[i];
            if (struct == null) {
                try {
                    String arrayName;
                    String structName;
                    if (structClass == null && (structClass = Reflection.getClass(structName = (arrayName = structs.getClass().getName()).substring(2, arrayName.length() - 1))) == null) {
                        throw new JavolutionError("Struct class: " + structName + " not found");
                    }
                    struct = (Struct)structClass.newInstance();
                }
                catch (Exception e) {
                    throw new JavolutionError(e);
                }
            }
            structs[i++] = this.inner(struct);
        }
        this._resetIndex = resetIndexSaved;
        return (Struct[])structs;
    }

    protected <S extends Struct> S[][] array(S[][] structs) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < structs.length; ++i) {
            this.array((Struct[])structs[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Struct[][])structs;
    }

    protected <S extends Struct> S[][][] array(S[][][] structs) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < structs.length; ++i) {
            this.array((Struct[][])structs[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Struct[][][])structs;
    }

    protected <M extends Member> M[] array(M[] arrayMember) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        if (BOOL.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Bool();
            }
        } else if (SIGNED_8.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed8();
            }
        } else if (UNSIGNED_8.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Unsigned8();
            }
        } else if (SIGNED_16.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed16();
            }
        } else if (UNSIGNED_16.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Unsigned16();
            }
        } else if (SIGNED_32.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed32();
            }
        } else if (UNSIGNED_32.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Unsigned32();
            }
        } else if (SIGNED_64.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed64();
            }
        } else if (FLOAT_32.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Float32();
            }
        } else if (FLOAT_64.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Float64();
            }
        } else {
            throw new UnsupportedOperationException("Cannot create member elements, the arrayMember should contain the member instances instead of null");
        }
        this._resetIndex = resetIndexSaved;
        return (Member[])arrayMember;
    }

    protected <M extends Member> M[][] array(M[][] arrayMember) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < arrayMember.length; ++i) {
            this.array((Member[])arrayMember[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Member[][])arrayMember;
    }

    protected <M extends Member> M[][][] array(M[][][] arrayMember) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < arrayMember.length; ++i) {
            this.array((Member[][])arrayMember[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Member[][][])arrayMember;
    }

    protected Utf8String[] array(Utf8String[] array, int stringLength) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Utf8String(stringLength);
        }
        return array;
    }

    private int updateIndexes(int alignment, int nbrOfBits, int capacity) {
        int offset;
        int usedBits;
        if (nbrOfBits > capacity) {
            throw new IllegalArgumentException("nbrOfBits: " + nbrOfBits + " exceeds capacity: " + capacity);
        }
        if (this._resetIndex) {
            this._bitIndex = 0;
        }
        this._bitIndex = capacity < (usedBits = this._bitIndex - ((offset = this._bitIndex / ((alignment = this.isPacked() ? 1 : alignment) << 3) * alignment) << 3)) + nbrOfBits || nbrOfBits == 0 && usedBits != 0 ? ((offset += alignment) << 3) + nbrOfBits : (this._bitIndex += nbrOfBits);
        if (this._bitsUsed < this._bitIndex) {
            this._bitsUsed = this._bitIndex;
        }
        if (this._alignment < alignment) {
            this._alignment = alignment;
        }
        return offset;
    }

    public class Enum64
    extends Member {
        private final long _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum64(List enumValues) {
            this(enumValues, 64);
        }

        public Enum64(List enumValues, int nbrOfBits) {
            super(8, nbrOfBits, 64);
            this._enumValues = enumValues;
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 64 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = nbrOfBits == 64 ? -1L : (1L << nbrOfBits) - 1L << this._shift;
            this._signShift = 64 - this._shift - nbrOfBits;
        }

        public Enum get() {
            if (this._mask == -1L) {
                return (Enum)this._enumValues.get((int)Struct.this.getByteBuffer().getLong(this.position()));
            }
            long value = Struct.this.getByteBuffer().getLong(this.position());
            value &= this._mask;
            value <<= this._signShift;
            return (Enum)this._enumValues.get((int)(value >>= this._signShift + this._shift));
        }

        public void set(Enum e) {
            int index = e.ordinal();
            if (this._enumValues.get(index) != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            long value = index;
            if (this._mask == -1L) {
                Struct.this.getByteBuffer().putLong(this.position(), value);
            } else {
                value <<= this._shift;
                long orMask = Struct.this.getByteBuffer().getLong(this.position()) & (this._mask ^ 0xFFFFFFFFFFFFFFFFL);
                Struct.this.getByteBuffer().putLong(this.position(), orMask | (value &= this._mask));
            }
        }
    }

    public class Enum32
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum32(List enumValues) {
            this(enumValues, 32);
        }

        public Enum32(List enumValues, int nbrOfBits) {
            super(4, nbrOfBits, 32);
            this._enumValues = enumValues;
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = nbrOfBits == 32 ? -1 : (1 << nbrOfBits) - 1 << this._shift;
            this._signShift = 32 - this._shift - nbrOfBits;
        }

        public Enum get() {
            if (this._mask == -1) {
                return (Enum)this._enumValues.get(Struct.this.getByteBuffer().getInt(this.position()));
            }
            int value = Struct.this.getByteBuffer().getInt(this.position());
            value &= this._mask;
            value <<= this._signShift;
            return (Enum)this._enumValues.get(value >>= this._signShift + this._shift);
        }

        public void set(Enum e) {
            int index = e.ordinal();
            if (this._enumValues.get(index) != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            int value = index;
            if (this._mask == -1) {
                Struct.this.getByteBuffer().putInt(this.position(), value);
            } else {
                value <<= this._shift;
                int orMask = Struct.this.getByteBuffer().getInt(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putInt(this.position(), orMask | (value &= this._mask));
            }
        }
    }

    public class Enum16
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum16(List enumValues) {
            this(enumValues, 16);
        }

        public Enum16(List enumValues, int nbrOfBits) {
            super(2, nbrOfBits, 16);
            this._enumValues = enumValues;
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = (1 << nbrOfBits) - 1 << this._shift;
            this._signShift = 32 - this._shift - nbrOfBits;
        }

        public Enum get() {
            if (this._mask == 65535) {
                return (Enum)this._enumValues.get(Struct.this.getByteBuffer().getShort(this.position()));
            }
            int value = Struct.this.getByteBuffer().getShort(this.position());
            value &= this._mask;
            value <<= this._signShift;
            return (Enum)this._enumValues.get(value >>= this._signShift + this._shift);
        }

        public void set(Enum e) {
            int index = e.ordinal();
            if (this._enumValues.get(index) != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            short value = (short)index;
            if (this._mask == 65535) {
                Struct.this.getByteBuffer().putShort(this.position(), value);
            } else {
                value = (short)(value << this._shift);
                value = (short)(value & this._mask);
                int orMask = Struct.this.getByteBuffer().getShort(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putShort(this.position(), (short)(orMask | value));
            }
        }
    }

    public class Enum8
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum8(List enumValues) {
            this(enumValues, 8);
        }

        public Enum8(List enumValues, int nbrOfBits) {
            super(1, nbrOfBits, 8);
            this._enumValues = enumValues;
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = (1 << nbrOfBits) - 1 << this._shift;
            this._signShift = 32 - this._shift - nbrOfBits;
        }

        public Enum get() {
            if (this._mask == 255) {
                return (Enum)this._enumValues.get(Struct.this.getByteBuffer().get(this.position()));
            }
            int value = Struct.this.getByteBuffer().get(this.position());
            value &= this._mask;
            value <<= this._signShift;
            return (Enum)this._enumValues.get(value >>= this._signShift + this._shift);
        }

        public void set(Enum e) {
            int index = e.ordinal();
            if (this._enumValues.get(index) != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            byte value = (byte)index;
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), value);
            } else {
                value = (byte)(value << this._shift);
                value = (byte)(value & this._mask);
                int orMask = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().put(this.position(), (byte)(orMask | value));
            }
        }
    }

    public class Reference64<S extends Struct>
    extends Member {
        private S _struct;

        public Reference64() {
            super(8, 8);
        }

        public void set(S struct) {
            if (struct != null) {
                Struct.this.getByteBuffer().putLong(this.position(), ((Struct)struct).address());
            } else if (struct == null) {
                Struct.this.getByteBuffer().putLong(this.position(), 0L);
            }
            this._struct = struct;
        }

        public S get() {
            return this._struct;
        }

        public long value() {
            return Struct.this.getByteBuffer().getLong(this.position());
        }

        public boolean isUpToDate() {
            if (this._struct != null) {
                return Struct.this.getByteBuffer().getLong(this.position()) == ((Struct)this._struct).address();
            }
            return Struct.this.getByteBuffer().getLong(this.position()) == 0L;
        }
    }

    public class Reference32<S extends Struct>
    extends Member {
        private S _struct;

        public Reference32() {
            super(4, 4);
        }

        public void set(S struct) {
            if (struct != null) {
                Struct.this.getByteBuffer().putInt(this.position(), (int)((Struct)struct).address());
            } else {
                Struct.this.getByteBuffer().putInt(this.position(), 0);
            }
            this._struct = struct;
        }

        public S get() {
            return this._struct;
        }

        public int value() {
            return Struct.this.getByteBuffer().getInt(this.position());
        }

        public boolean isUpToDate() {
            if (this._struct != null) {
                return Struct.this.getByteBuffer().getInt(this.position()) == (int)((Struct)this._struct).address();
            }
            return Struct.this.getByteBuffer().getInt(this.position()) == 0;
        }
    }

    public class Float64
    extends Member {
        public Float64() {
            super(8, 8);
        }

        public void set(double value) {
            Struct.this.getByteBuffer().putDouble(this.position(), value);
        }

        public double get() {
            return Struct.this.getByteBuffer().getDouble(this.position());
        }
    }

    public class Float32
    extends Member {
        public Float32() {
            super(4, 4);
        }

        public void set(float value) {
            Struct.this.getByteBuffer().putFloat(this.position(), value);
        }

        public float get() {
            return Struct.this.getByteBuffer().getFloat(this.position());
        }
    }

    public class Signed64
    extends Member {
        private final long _mask;
        private final int _shift;
        private final int _signShift;

        public Signed64() {
            this(64);
        }

        public Signed64(int nbrOfBits) {
            super(8, nbrOfBits, 64);
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 64 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = nbrOfBits == 64 ? -1L : (1L << nbrOfBits) - 1L << this._shift;
            this._signShift = 64 - this._shift - nbrOfBits;
        }

        public long get() {
            if (this._mask == -1L) {
                return Struct.this.getByteBuffer().getLong(this.position());
            }
            long value = Struct.this.getByteBuffer().getLong(this.position());
            value &= this._mask;
            value <<= this._signShift;
            return value >>= this._signShift + this._shift;
        }

        public void set(long value) {
            if (this._mask == -1L) {
                Struct.this.getByteBuffer().putLong(this.position(), value);
            } else {
                value <<= this._shift;
                long orMask = Struct.this.getByteBuffer().getLong(this.position()) & (this._mask ^ 0xFFFFFFFFFFFFFFFFL);
                Struct.this.getByteBuffer().putLong(this.position(), orMask | (value &= this._mask));
            }
        }
    }

    public class Unsigned32
    extends Member {
        private final int _shift;
        private final long _mask;

        public Unsigned32() {
            this(32);
        }

        public Unsigned32(int nbrOfBits) {
            super(4, nbrOfBits, 32);
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = nbrOfBits == 32 ? 0xFFFFFFFFL : (1L << nbrOfBits) - 1L << this._shift;
        }

        public long get() {
            int value = Struct.this.getByteBuffer().getInt(this.position());
            return ((long)value & this._mask) >>> this._shift;
        }

        public void set(long value) {
            if (this._mask == -1L) {
                Struct.this.getByteBuffer().putInt(this.position(), (int)value);
            } else {
                value <<= this._shift;
                int orMask = Struct.this.getByteBuffer().getInt(this.position()) & ~((int)this._mask);
                Struct.this.getByteBuffer().putInt(this.position(), (int)((long)orMask | (value &= this._mask)));
            }
        }
    }

    public class Signed32
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed32() {
            this(32);
        }

        public Signed32(int nbrOfBits) {
            super(4, nbrOfBits, 32);
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = nbrOfBits == 32 ? -1 : (1 << nbrOfBits) - 1 << this._shift;
            this._signShift = 32 - this._shift - nbrOfBits;
        }

        public int get() {
            if (this._mask == -1) {
                return Struct.this.getByteBuffer().getInt(this.position());
            }
            int value = Struct.this.getByteBuffer().getInt(this.position());
            value &= this._mask;
            value <<= this._signShift;
            return value >>= this._signShift + this._shift;
        }

        public void set(int value) {
            if (this._mask == -1) {
                Struct.this.getByteBuffer().putInt(this.position(), value);
            } else {
                value <<= this._shift;
                int orMask = Struct.this.getByteBuffer().getInt(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putInt(this.position(), orMask | (value &= this._mask));
            }
        }
    }

    public class Unsigned16
    extends Member {
        private final int _shift;
        private final int _mask;

        public Unsigned16() {
            this(16);
        }

        public Unsigned16(int nbrOfBits) {
            super(2, nbrOfBits, 16);
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = (1 << nbrOfBits) - 1 << this._shift;
        }

        public int get() {
            short value = Struct.this.getByteBuffer().getShort(this.position());
            return (value & this._mask) >>> this._shift;
        }

        public void set(int value) {
            if (this._mask == 65535) {
                Struct.this.getByteBuffer().putShort(this.position(), (short)value);
            } else {
                value <<= this._shift;
                int orMask = Struct.this.getByteBuffer().getShort(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putShort(this.position(), (short)(orMask | (value &= this._mask)));
            }
        }
    }

    public class Signed16
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed16() {
            this(16);
        }

        public Signed16(int nbrOfBits) {
            super(2, nbrOfBits, 16);
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = (1 << nbrOfBits) - 1 << this._shift;
            this._signShift = 32 - this._shift - nbrOfBits;
        }

        public short get() {
            if (this._mask == 65535) {
                return Struct.this.getByteBuffer().getShort(this.position());
            }
            int value = Struct.this.getByteBuffer().getShort(this.position());
            value &= this._mask;
            value <<= this._signShift;
            return (short)(value >>= this._signShift + this._shift);
        }

        public void set(short value) {
            if (this._mask == 65535) {
                Struct.this.getByteBuffer().putShort(this.position(), value);
            } else {
                value = (short)(value << this._shift);
                value = (short)(value & this._mask);
                int orMask = Struct.this.getByteBuffer().getShort(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putShort(this.position(), (short)(orMask | value));
            }
        }
    }

    public class Unsigned8
    extends Member {
        private final int _shift;
        private final int _mask;

        public Unsigned8() {
            this(8);
        }

        public Unsigned8(int nbrOfBits) {
            super(1, nbrOfBits, 8);
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = (1 << nbrOfBits) - 1 << this._shift;
        }

        public short get() {
            byte value = Struct.this.getByteBuffer().get(this.position());
            return (short)((value & this._mask) >>> this._shift);
        }

        public void set(short value) {
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), (byte)value);
            } else {
                value = (short)(value << this._shift);
                value = (short)(value & this._mask);
                int orMask = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().put(this.position(), (byte)(orMask | value));
            }
        }
    }

    public class Signed8
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed8() {
            this(8);
        }

        public Signed8(int nbrOfBits) {
            super(1, nbrOfBits, 8);
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = (1 << nbrOfBits) - 1 << this._shift;
            this._signShift = 32 - this._shift - nbrOfBits;
        }

        public byte get() {
            if (this._mask == 255) {
                return Struct.this.getByteBuffer().get(this.position());
            }
            int value = Struct.this.getByteBuffer().get(this.position());
            value &= this._mask;
            value <<= this._signShift;
            return (byte)(value >>= this._signShift + this._shift);
        }

        public void set(byte value) {
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), value);
            } else {
                value = (byte)(value << this._shift);
                value = (byte)(value & this._mask);
                int orMask = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().put(this.position(), (byte)(orMask | value));
            }
        }
    }

    public class Bool
    extends Member {
        private final int _mask;
        private final int _shift;

        public Bool() {
            this(8);
        }

        public Bool(int nbrOfBits) {
            super(1, nbrOfBits, 8);
            int startBit = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + startBit : Struct.this._bitIndex - startBit - nbrOfBits;
            this._mask = (1 << nbrOfBits) - 1 << this._shift;
        }

        public boolean get() {
            return (Struct.this.getByteBuffer().get(this.position()) & this._mask) != 0;
        }

        public void set(boolean value) {
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), (byte)(value ? 1 : 0));
            } else {
                int prevCleared = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                if (value) {
                    Struct.this.getByteBuffer().put(this.position(), (byte)(prevCleared | 1 << this._shift));
                } else {
                    Struct.this.getByteBuffer().put(this.position(), (byte)prevCleared);
                }
            }
        }
    }

    public class Utf8String
    extends Member {
        private final Utf8ByteBufferWriter _writer;
        private final Utf8ByteBufferReader _reader;
        private final char[] _chars;
        private final int _length;

        public Utf8String(int length) {
            super(1, length);
            this._writer = new Utf8ByteBufferWriter();
            this._reader = new Utf8ByteBufferReader();
            this._length = length;
            this._chars = new char[length];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String string) {
            ByteBuffer buffer;
            ByteBuffer byteBuffer = buffer = Struct.this.getByteBuffer();
            synchronized (byteBuffer) {
                try {
                    buffer.position(this.position());
                    this._writer.setByteBuffer(buffer);
                    if (string.length() < this._length) {
                        this._writer.write(string);
                        this._writer.write(0);
                    } else if (string.length() > this._length) {
                        this._writer.write(string.substring(0, this._length));
                    } else {
                        this._writer.write(string);
                    }
                }
                catch (IOException e) {
                    throw new JavolutionError(e);
                }
                finally {
                    this._writer.reset();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String get() {
            ByteBuffer buffer;
            ByteBuffer byteBuffer = buffer = Struct.this.getByteBuffer();
            synchronized (byteBuffer) {
                try {
                    buffer.position(this.position());
                    this._reader.setByteBuffer(buffer);
                    int i22 = 0;
                    while (i22 < this._length) {
                        char c = (char)this._reader.read();
                        if (c == '\u0000') {
                            String string = new String(this._chars, 0, i22);
                            return string;
                        }
                        this._chars[i22++] = c;
                    }
                    String i22 = new String(this._chars, 0, this._length);
                    return i22;
                }
                catch (IOException e) {
                    throw new JavolutionError(e);
                }
                finally {
                    this._reader.reset();
                }
            }
        }
    }

    protected class Member {
        private final int _offset;

        protected Member(int alignment, int size) {
            int nbrOfBits = size << 3;
            this._offset = Struct.this.updateIndexes(alignment, nbrOfBits, nbrOfBits);
        }

        Member(int alignment, int nbrOfBits, int capacity) {
            this._offset = Struct.this.updateIndexes(alignment, nbrOfBits, capacity);
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final int offset() {
            return this._offset;
        }

        public final int position() {
            return Struct.this.getByteBufferPosition() + this._offset;
        }
    }
}

