/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import javolution37.javolution.Javolution;
import javolution37.javolution.JavolutionError;
import javolution37.javolution.lang.MathLib;
import javolution37.javolution.lang.Text;
import javolution37.javolution.lang.TextBuilder;
import javolution37.javolution.realtime.RealtimeObject;
import javolution37.javolution.util.FastComparator;
import javolution37.javolution.util.FastList;
import javolution37.javolution.util.FastMap;
import javolution37.javolution.util.FastSet;
import javolution37.javolution.util.FastTable;
import javolution37.javolution.xml.CharacterData;
import javolution37.javolution.xml.ObjectReader;
import javolution37.javolution.xml.ObjectWriter;

final class Perf_Xml
extends Javolution
implements Runnable {
    private static final int OBJECT_SIZE = 1000;
    private static final int BYTE_BUFFER_SIZE = 1200000;

    Perf_Xml() {
    }

    @Override
    public void run() {
        int i;
        Perf_Xml.println("/////////////////////////////");
        Perf_Xml.println("// Package: javolution.xml //");
        Perf_Xml.println("/////////////////////////////");
        Perf_Xml.println("");
        Perf_Xml.println("-- Java(TM) Serialization --");
        Perf_Xml.setOutputStream(null);
        for (i = 0; i < 10; ++i) {
            this.benchmarkJavaSerialization();
        }
        Perf_Xml.setOutputStream(System.out);
        this.benchmarkJavaSerialization();
        Perf_Xml.println("");
        Perf_Xml.println("-- XML Serialization (I/O Stream) --");
        Perf_Xml.setOutputStream(null);
        for (i = 0; i < 10; ++i) {
            this.benchmarkXmlIoSerialization();
        }
        Perf_Xml.setOutputStream(System.out);
        this.benchmarkXmlIoSerialization();
        Perf_Xml.println("");
        Perf_Xml.println("-- XML Serialization (NIO ByteBuffer) --");
        Perf_Xml.setOutputStream(null);
        for (i = 0; i < 10; ++i) {
            this.benchmarkXmlNioSerialization();
        }
        Perf_Xml.setOutputStream(System.out);
        this.benchmarkXmlNioSerialization();
        Perf_Xml.println("");
    }

    private void benchmarkJavaSerialization() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1200000);
            ObjectOutputStream oo = new ObjectOutputStream(out);
            Object data = Perf_Xml.newData();
            Perf_Xml.print("Write Time: ");
            Perf_Xml.startTime();
            oo.writeObject(data);
            oo.close();
            Perf_Xml.println(Perf_Xml.endTime(1));
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            ObjectInputStream oi = new ObjectInputStream(in);
            Perf_Xml.print("Read Time: ");
            Perf_Xml.startTime();
            Object readObject = oi.readObject();
            oi.close();
            Perf_Xml.println(Perf_Xml.endTime(1));
            if (!data.equals(readObject)) {
                throw new Error("SERIALIZATION ERROR");
            }
        }
        catch (UnsupportedOperationException e) {
            Perf_Xml.println("NOT SUPPORTED (J2SE 1.4+ build required)");
        }
        catch (Throwable e) {
            throw new JavolutionError(e);
        }
    }

    private void benchmarkXmlIoSerialization() {
        try {
            ObjectWriter<Object> ow = new ObjectWriter<Object>();
            ow.setPackagePrefix("", "java.lang");
            ByteArrayOutputStream out = new ByteArrayOutputStream(1200000);
            Object data = Perf_Xml.newData();
            Perf_Xml.print("Write Time: ");
            Perf_Xml.startTime();
            ow.write(data, out);
            Perf_Xml.println(Perf_Xml.endTime(1));
            ObjectReader or = new ObjectReader();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            Perf_Xml.print("Read Time: ");
            Perf_Xml.startTime();
            Object readObject = or.read(in);
            Perf_Xml.println(Perf_Xml.endTime(1));
            if (!data.equals(readObject)) {
                throw new Error("SERIALIZATION ERROR");
            }
        }
        catch (UnsupportedOperationException e) {
            Perf_Xml.println("NOT SUPPORTED (J2SE 1.4+ build required)");
        }
        catch (Throwable e) {
            throw new JavolutionError(e);
        }
    }

    private void benchmarkXmlNioSerialization() {
        try {
            ObjectWriter<Object> ow = new ObjectWriter<Object>();
            ByteBuffer bb = ByteBuffer.allocateDirect(1200000);
            ow.setPackagePrefix("", "java.lang");
            Object data = Perf_Xml.newData();
            Perf_Xml.print("Write Time: ");
            Perf_Xml.startTime();
            ow.write(data, bb);
            Perf_Xml.println(Perf_Xml.endTime(1));
            ObjectReader or = new ObjectReader();
            bb.flip();
            Perf_Xml.print("Read Time: ");
            Perf_Xml.startTime();
            Object readObject = or.read(bb);
            Perf_Xml.println(Perf_Xml.endTime(1));
            if (!data.equals(readObject)) {
                throw new Error("SERIALIZATION ERROR");
            }
        }
        catch (UnsupportedOperationException e) {
            Perf_Xml.println("NOT SUPPORTED (J2SE 1.4+ build required)");
        }
        catch (Throwable e) {
            throw new JavolutionError(e);
        }
    }

    private static Object newData() {
        FastTable<RealtimeObject> v = new FastTable<RealtimeObject>(1000);
        for (int i = 0; i < 1000; ++i) {
            FastTable<String> ft = new FastTable<String>();
            ft.add("This is the first String (" + i + ")");
            ft.add("This is the second String (" + i + ")");
            ft.add("This is the third String (" + i + ")");
            v.add(ft);
            v.add(null);
            v.add(TextBuilder.newInstance().append(Long.MAX_VALUE));
            v.add(Text.valueOf(Long.MAX_VALUE, 16));
            String str = "<<< Some character data " + MathLib.randomInt(0, 9) + " >>>";
            CharacterData charData = CharacterData.valueOf(Text.valueOf(str));
            v.add(charData);
            FastMap<String, Text> fm = new FastMap<String, Text>();
            fm.setKeyComparator(FastComparator.REHASH);
            fm.setValueComparator(FastComparator.IDENTITY);
            fm.put(new String("ONE"), Text.valueOf(1));
            fm.put(new String("TWO"), Text.valueOf(2));
            fm.put(new String("THREE"), Text.valueOf(3));
            v.add(fm);
            FastList<String> fl = new FastList<String>();
            fl.add("FIRST");
            fl.add("SECOND");
            fl.add("THIRD");
            fl.add("...");
            v.add(fl);
            FastSet<String> fs = new FastSet<String>();
            fs.add("ALPHA");
            fs.add("BETA");
            fs.add("GAMMA");
            v.add(fs);
        }
        return v;
    }
}

