/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.util;

import com.jstatcom.model.JSCConstants;
import java.text.NumberFormat;

public final class UString {
    public static final String NAN_STRING = "NaN";
    public static final String NAN_STRING_ALT = "NA";
    public static final String POSINF_STRING = "Infinity";
    public static final String SIGPOSINF_STRING = "+Infinity";
    public static final String NEGINF_STRING = "-Infinity";

    public static String formatNumber(double number, NumberFormat format, int precision) {
        if (format != null) {
            format.setMaximumFractionDigits(precision);
            format.setMinimumFractionDigits(precision);
            return format.format(number);
        }
        return number + "";
    }

    public static Double parseToNumber(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if ((text = text.trim()).length() == 0) {
            return null;
        }
        if (text.equalsIgnoreCase(NAN_STRING) || text.equalsIgnoreCase(NAN_STRING_ALT)) {
            return JSCConstants.NaN;
        }
        if (text.equalsIgnoreCase(POSINF_STRING) || text.equalsIgnoreCase(SIGPOSINF_STRING)) {
            return JSCConstants.POS_INF;
        }
        if (text.equalsIgnoreCase(NEGINF_STRING)) {
            return JSCConstants.NEG_INF;
        }
        try {
            double val = Double.parseDouble(text);
            return new Double(val);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static String replaceAllSubStrings(String origString, String substring, String replacementString) {
        if (origString == null || substring == null || replacementString == null) {
            return origString;
        }
        if (origString.length() == 0 || substring.length() == 0) {
            return origString;
        }
        int checkIndex = 0;
        int lastIndexFound = 0;
        while ((lastIndexFound = origString.indexOf(substring, checkIndex)) >= 0) {
            origString = UString.replaceSubString(origString, substring, replacementString, checkIndex);
            checkIndex = lastIndexFound + replacementString.length();
        }
        return origString;
    }

    public static String replaceSubString(String origString, String substring, String replacementString) {
        return UString.replaceSubString(origString, substring, replacementString, 0);
    }

    public static String replaceSubString(String origString, String substring, String replacementString, int pos) {
        if (origString == null || substring == null || replacementString == null) {
            return origString;
        }
        if (pos >= origString.length()) {
            return origString;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (origString.length() == 0 || substring.length() == 0) {
            return origString;
        }
        StringBuffer buffer = new StringBuffer(origString);
        int index = origString.indexOf(substring, pos);
        if (index < 0) {
            return origString;
        }
        buffer.delete(index, index + substring.length());
        buffer.insert(index, replacementString);
        return buffer.toString();
    }

    public static String capitalizeFirst(String s) {
        if (s == null) {
            return s;
        }
        if ((s = s.trim()).length() < 2) {
            return s.toUpperCase();
        }
        s = s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
        return s;
    }
}

