/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.CompSettings;
import com.jstatcom.component.StdMessages;
import com.jstatcom.model.JSCDRange;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.ModelPanel;
import com.jstatcom.model.Scope;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.ts.Selection;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import com.jstatcom.ts.TSDateRangeSelector;
import com.jstatcom.ts.TSHolder;
import com.jstatcom.ts.TSList;
import com.jstatcom.ts.TSTypes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public final class TSSel
extends ModelPanel {
    private static final Logger log = Logger.getLogger(TSSel.class);
    private Scope symbolScope = Scope.GLOBAL;
    private static final MyNonSelectableListCellRenderer myCellRenderer = new MyNonSelectableListCellRenderer();
    private int[] lastConfirmedSelection = new int[0];
    private MyEventHandler myEventHandler = new MyEventHandler();
    private int referencePeriodicity = -1;
    private JScrollPane ivjJScrollPane2 = null;
    private JPanel ivjJPanel2 = null;
    private JScrollPane ivjJScrollPane1 = null;
    private boolean checkNaN = true;
    private final DefaultListModel endListModel = new DefaultListModel();
    private final DefaultListModel exListModel = new DefaultListModel();
    private final DefaultListModel detListModel = new DefaultListModel();
    private boolean fieldDatesEditable = true;
    private JLabel rangeLabel = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JSCTypeDef endogenousDataDef = null;
    private JSCTypeDef exogenousDataDef = null;
    private JSCTypeDef deterministicDataDef = null;
    private JSCTypeDef allDataDef = null;
    private JSCTypeDef endogenousStringsDef = null;
    private JSCTypeDef exogenousStringsDef = null;
    private JSCTypeDef deterministicStringsDef = null;
    private JSCTypeDef allStringsDef = null;
    private JSCTypeDef dateRangeDef = null;
    private final List<Integer> actualSelection = new ArrayList<Integer>();
    private TSHolder timeSeriesData = TSHolder.getInstance();
    private boolean oneEndogenousOnly = false;
    private JList ivjDetSelList = null;
    private JList ivjEndSelList = null;
    private JList ivjExSelList = null;
    private JScrollPane ivjJScrollPane3 = null;
    private JScrollPane ivjJScrollPane4 = null;
    private JPanel ivjJPanel1 = null;
    private JSplitPane ivjJSplitPane = null;
    private JPanel ivjJPanel3 = null;
    private JButton ivjConfirmButton = null;
    private JPanel ivjJPanel4 = null;
    private JButton ivjMaxRangeButton = null;
    private TSDateRangeSelector ivjTSDateRangeSelector = null;
    private TSList ivjTSList = null;

    public TSSel() {
        this.initialize();
    }

    private void checkOneEndogenousOnly() {
        TSList list = this.getTSList();
        if (!this.isOneEndogenousOnly()) {
            return;
        }
        TS toCheck = null;
        int index = -1;
        boolean firstEndogenousAlreadyEncountered = false;
        for (int i = 0; i < this.actualSelection.size(); ++i) {
            index = this.actualSelection.get(i);
            toCheck = this.timeSeriesData.getTS(list.getModel().getElementAt(index).toString());
            if (toCheck.type() != TSTypes.ENDOGENOUS) continue;
            if (firstEndogenousAlreadyEncountered) {
                this.actualSelection.remove(i);
                --i;
            }
            firstEndogenousAlreadyEncountered = true;
        }
    }

    private void clearDataObjects() {
        SymbolTable sTable = this.symbolScope.getSymbolTable(this);
        if (this.dateRangeDef != null) {
            sTable.get(this.dateRangeDef).clear();
        }
        if (this.endogenousStringsDef != null) {
            sTable.get(this.endogenousStringsDef).clear();
        }
        if (this.exogenousStringsDef != null) {
            sTable.get(this.exogenousStringsDef).clear();
        }
        if (this.deterministicStringsDef != null) {
            sTable.get(this.deterministicStringsDef).clear();
        }
        if (this.allStringsDef != null) {
            sTable.get(this.allStringsDef).clear();
        }
        if (this.endogenousDataDef != null) {
            sTable.get(this.endogenousDataDef).clear();
        }
        if (this.exogenousDataDef != null) {
            sTable.get(this.exogenousDataDef).clear();
        }
        if (this.deterministicDataDef != null) {
            sTable.get(this.deterministicDataDef).clear();
        }
        if (this.allDataDef != null) {
            sTable.get(this.allDataDef).clear();
        }
    }

    private void confirmButton_ActionEvents() {
        int sel;
        TSList list = this.getTSList();
        String[] allVarNames = new String[this.actualSelection.size()];
        this.lastConfirmedSelection = new int[this.actualSelection.size()];
        int index = 0;
        for (sel = 0; sel < this.actualSelection.size(); ++sel) {
            this.lastConfirmedSelection[sel] = index = this.actualSelection.get(sel).intValue();
            TS toCheck = this.timeSeriesData.getTS(((String)list.getModel().getElementAt(index)).toString());
            allVarNames[sel] = toCheck.name();
        }
        if (this.checkNaN) {
            double[][] allData = this.getDataArray(allVarNames);
            for (int i = 0; i < allData.length; ++i) {
                for (int j = 0; j < allData[0].length; ++j) {
                    if (!Double.isNaN(allData[i][j])) continue;
                    TSDate startDate = this.getTSDateRangeSelector().getTSDateRange().lowerBound();
                    String msg = "There is a missing value in [\"" + allVarNames[j] + "\"" + ", " + startDate.addPeriods(i) + "].\n";
                    msg = msg + "Please adjust the selection to avoid NaN's.\nThe previous selection is kept.";
                    StdMessages.error(msg, "Missing Value Encountered");
                    return;
                }
            }
        }
        if (this.getTSDateRangeSelector().getTSDateRange().numOfObs() < 3) {
            StdMessages.errorSpecification("There are less than 3 observations in the selection.");
            return;
        }
        this.endListModel.clear();
        this.exListModel.clear();
        this.detListModel.clear();
        if (list.getModel().getSize() == 0) {
            return;
        }
        for (sel = 0; sel < this.actualSelection.size(); ++sel) {
            index = this.actualSelection.get(sel);
            TS toCheck = this.timeSeriesData.getTS(((String)list.getModel().getElementAt(index)).toString());
            if (toCheck.type() == TSTypes.ENDOGENOUS) {
                this.endListModel.addElement(toCheck.name());
            }
            if (toCheck.type() == TSTypes.EXOGENOUS) {
                this.exListModel.addElement(toCheck.name());
            }
            if (toCheck.type() != TSTypes.DETERMINISTIC) continue;
            this.detListModel.addElement(toCheck.name());
        }
        if (this.endListModel.size() == 0 && this.exListModel.size() == 0 && this.detListModel.size() == 0) {
            this.getRangeLabel().setText("");
            this.getRangeLabel().setToolTipText("");
        } else {
            String range = this.getTSDateRangeSelector().getTSDateRange().format("", 0);
            this.getRangeLabel().setText(range);
            this.getRangeLabel().setToolTipText(range);
        }
        this.createJSCData();
    }

    private void connEtoC1() {
        try {
            this.confirmButton_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.maxRangeButton_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.selectPanel_ComponentResized();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void createDataObject(String dataName, String[] variableNames, SymbolTable sTable) {
        if (dataName == null || variableNames == null) {
            throw new IllegalArgumentException("Arg was null");
        }
        sTable.set(new JSCNArray(dataName, this.getDataArray(variableNames)));
    }

    private double[][] getDataArray(String[] variableNames) {
        TSDateRange selRange = this.getTSDateRangeSelector().getTSDateRange();
        int obs = selRange.numOfObs();
        double[][] dataArray = new double[0][0];
        if (variableNames.length > 0) {
            dataArray = new double[obs][variableNames.length];
            for (int a = 0; a < variableNames.length; ++a) {
                TS toCheck = this.timeSeriesData.getTS(variableNames[a]);
                TSDate begin = toCheck.start();
                TSDate date = selRange.lowerBound();
                int start = begin.compareTo(date);
                for (int b = 0; b < obs; ++b) {
                    dataArray[b][a] = toCheck.valueAt(start + b);
                }
            }
        }
        return dataArray;
    }

    private void createJSCData() {
        if (this.actualSelection.size() == 0) {
            this.clearDataObjects();
            this.setSelectionChanged();
            return;
        }
        SymbolTable sTable = this.symbolScope.getSymbolTable(this);
        int numberOfEndVars = this.getEndSelList().getModel().getSize();
        int numberOfExVars = this.getExSelList().getModel().getSize();
        int numberOfDetVars = this.getDetSelList().getModel().getSize();
        String[] allStrings = new String[numberOfEndVars + numberOfExVars + numberOfDetVars];
        String[] endStrings = new String[numberOfEndVars];
        for (int i = 0; i < endStrings.length; ++i) {
            endStrings[i] = this.getEndSelList().getModel().getElementAt(i).toString();
            allStrings[i] = endStrings[i];
        }
        String[] exStrings = new String[numberOfExVars];
        for (int i = 0; i < exStrings.length; ++i) {
            exStrings[i] = this.getExSelList().getModel().getElementAt(i).toString();
            allStrings[i + numberOfEndVars] = exStrings[i];
        }
        String[] detStrings = new String[numberOfDetVars];
        for (int i = 0; i < detStrings.length; ++i) {
            detStrings[i] = this.getDetSelList().getModel().getElementAt(i).toString();
            allStrings[i + numberOfEndVars + numberOfExVars] = detStrings[i];
        }
        if (this.dateRangeDef != null) {
            sTable.set(new JSCDRange(this.dateRangeDef.name, this.getTSDateRangeSelector().getTSDateRange()));
        }
        if (this.endogenousStringsDef != null) {
            sTable.set(new JSCSArray(this.endogenousStringsDef.name, endStrings));
        }
        if (this.exogenousStringsDef != null) {
            sTable.set(new JSCSArray(this.exogenousStringsDef.name, exStrings));
        }
        if (this.deterministicStringsDef != null) {
            sTable.set(new JSCSArray(this.deterministicStringsDef.name, detStrings));
        }
        if (this.allStringsDef != null) {
            sTable.set(new JSCSArray(this.allStringsDef.name, allStrings));
        }
        if (this.endogenousDataDef != null) {
            this.createDataObject(this.endogenousDataDef.name, endStrings, sTable);
        }
        if (this.exogenousDataDef != null) {
            this.createDataObject(this.exogenousDataDef.name, exStrings, sTable);
        }
        if (this.deterministicDataDef != null) {
            this.createDataObject(this.deterministicDataDef.name, detStrings, sTable);
        }
        if (this.allDataDef != null) {
            this.createDataObject(this.allDataDef.name, allStrings, sTable);
        }
        this.setSelectionChanged();
    }

    public String getAllDataName() {
        if (this.allDataDef == null) {
            return null;
        }
        return this.allDataDef.name;
    }

    public String getAllStringsName() {
        if (this.allStringsDef == null) {
            return null;
        }
        return this.allStringsDef.name;
    }

    private JButton getConfirmButton() {
        if (this.ivjConfirmButton == null) {
            try {
                this.ivjConfirmButton = new JButton();
                this.ivjConfirmButton.setName("ConfirmButton");
                this.ivjConfirmButton.setToolTipText("Sets selection for series, order and dates.");
                this.ivjConfirmButton.setPreferredSize(new Dimension(135, 23));
                this.ivjConfirmButton.setText("Confirm Selection");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConfirmButton;
    }

    public boolean getDatesEditable() {
        return this.fieldDatesEditable;
    }

    public String getDeterministicDataName() {
        if (this.deterministicDataDef == null) {
            return null;
        }
        return this.deterministicDataDef.name;
    }

    public boolean getDeterministicEnabled() {
        return this.getDetSelList().isEnabled();
    }

    public String getDeterministicStringsName() {
        if (this.deterministicStringsDef == null) {
            return null;
        }
        return this.deterministicStringsDef.name;
    }

    private JList getDetSelList() {
        if (this.ivjDetSelList == null) {
            try {
                this.ivjDetSelList = new JList();
                this.ivjDetSelList.setName("DetSelList");
                this.ivjDetSelList.setFixedCellHeight(10);
                this.ivjDetSelList.setBounds(0, 0, 160, 120);
                this.ivjDetSelList.setFont(CompSettings.smallFontDefault);
                this.ivjDetSelList.setModel(this.detListModel);
                this.ivjDetSelList.setForeground(Color.blue);
                this.ivjDetSelList.setCellRenderer(myCellRenderer);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDetSelList;
    }

    private JLabel getRangeLabel() {
        if (this.rangeLabel == null) {
            this.rangeLabel = new JLabel();
            this.rangeLabel.setFont(CompSettings.smallFontDefault);
            this.rangeLabel.setPreferredSize(new Dimension(100, 20));
            this.rangeLabel.setMinimumSize(new Dimension(100, 20));
        }
        return this.rangeLabel;
    }

    public String getEndogenousDataName() {
        if (this.endogenousDataDef == null) {
            return null;
        }
        return this.endogenousDataDef.name;
    }

    public String getEndogenousStringsName() {
        if (this.endogenousStringsDef == null) {
            return null;
        }
        return this.endogenousStringsDef.name;
    }

    private JList getEndSelList() {
        if (this.ivjEndSelList == null) {
            try {
                this.ivjEndSelList = new JList();
                this.ivjEndSelList.setName("EndSelList");
                this.ivjEndSelList.setFixedCellHeight(10);
                this.ivjEndSelList.setBounds(0, 0, 160, 120);
                this.ivjEndSelList.setFont(CompSettings.smallFontDefault);
                this.ivjEndSelList.setModel(this.endListModel);
                this.ivjEndSelList.setForeground(Color.red);
                this.ivjEndSelList.setCellRenderer(myCellRenderer);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjEndSelList;
    }

    public String getExogenousDataName() {
        if (this.exogenousDataDef == null) {
            return null;
        }
        return this.exogenousDataDef.name;
    }

    public String getDateRangeName() {
        if (this.dateRangeDef == null) {
            return null;
        }
        return this.dateRangeDef.name;
    }

    public boolean getExogenousEnabled() {
        return this.getExSelList().isEnabled();
    }

    public String getExogenousStringsName() {
        if (this.exogenousStringsDef == null) {
            return null;
        }
        return this.exogenousStringsDef.name;
    }

    private JList getExSelList() {
        if (this.ivjExSelList == null) {
            try {
                this.ivjExSelList = new JList();
                this.ivjExSelList.setName("ExSelList");
                this.ivjExSelList.setFixedCellHeight(10);
                this.ivjExSelList.setBounds(0, 0, 160, 120);
                this.ivjExSelList.setFont(CompSettings.smallFontDefault);
                this.ivjExSelList.setModel(this.exListModel);
                this.ivjExSelList.setForeground(Color.green);
                this.ivjExSelList.setCellRenderer(myCellRenderer);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExSelList;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setPreferredSize(new Dimension(204, 150));
                this.ivjJPanel1.setLayout(new GridLayout());
                this.getJPanel1().add((Component)this.getJScrollPane2(), this.getJScrollPane2().getName());
                this.getJPanel1().add((Component)this.getJScrollPane3(), this.getJScrollPane3().getName());
                this.getJPanel1().add((Component)this.getJScrollPane4(), this.getJScrollPane4().getName());
                TitledBorder title = new TitledBorder(new EtchedBorder(), "Selection Order sets Variable Order", 3, 2);
                title.setTitleFont(CompSettings.smallFontDefault);
                this.getJPanel1().setBorder(title);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setPreferredSize(new Dimension(205, 170));
                this.ivjJPanel2.setLayout(new GridBagLayout());
                this.ivjJPanel2.setMinimumSize(new Dimension(205, 170));
                GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
                constraintsJPanel1.gridx = 0;
                constraintsJPanel1.gridy = 1;
                constraintsJPanel1.fill = 1;
                constraintsJPanel1.weightx = 1.0;
                constraintsJPanel1.weighty = 1.0;
                this.getJPanel2().add((Component)this.getJPanel1(), constraintsJPanel1);
                GridBagConstraints constraintsJPanel3 = new GridBagConstraints();
                constraintsJPanel3.gridx = 0;
                constraintsJPanel3.gridy = 0;
                constraintsJPanel3.fill = 1;
                this.getJPanel2().add((Component)this.getJPanel3(), constraintsJPanel3);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private JPanel getJPanel3() {
        if (this.ivjJPanel3 == null) {
            try {
                this.ivjJPanel3 = new JPanel();
                this.ivjJPanel3.setName("JPanel3");
                this.ivjJPanel3.setPreferredSize(new Dimension(10, 80));
                this.ivjJPanel3.setLayout(new GridBagLayout());
                this.ivjJPanel3.setMinimumSize(new Dimension(10, 80));
                GridBagConstraints constraintsObsLabel = new GridBagConstraints();
                GridBagConstraints constraintsRangeLabel = new GridBagConstraints();
                constraintsRangeLabel.gridx = 0;
                constraintsRangeLabel.gridy = 1;
                constraintsRangeLabel.weighty = 1.0;
                constraintsRangeLabel.gridwidth = 2;
                constraintsRangeLabel.fill = 1;
                constraintsRangeLabel.insets = new Insets(0, 3, 2, 2);
                GridBagConstraints constraintsJPanel4 = new GridBagConstraints();
                constraintsObsLabel.anchor = 17;
                constraintsJPanel4.gridx = 0;
                constraintsJPanel4.gridy = 0;
                constraintsJPanel4.gridwidth = 2;
                constraintsJPanel4.fill = 2;
                constraintsJPanel4.weightx = 1.0;
                constraintsJPanel4.insets = new Insets(3, 0, 0, 0);
                this.ivjJPanel3.add((Component)this.getRangeLabel(), constraintsRangeLabel);
                this.getJPanel3().add((Component)this.getJPanel4(), constraintsJPanel4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel3;
    }

    private JPanel getJPanel4() {
        if (this.ivjJPanel4 == null) {
            try {
                this.ivjJPanel4 = new JPanel();
                this.ivjJPanel4.setName("JPanel4");
                this.ivjJPanel4.setPreferredSize(new Dimension(205, 50));
                this.ivjJPanel4.setLayout(new GridBagLayout());
                this.ivjJPanel4.setMinimumSize(new Dimension(205, 50));
                GridBagConstraints constraintsConfirmButton = new GridBagConstraints();
                constraintsConfirmButton.gridx = 1;
                constraintsConfirmButton.gridy = 1;
                constraintsConfirmButton.fill = 2;
                constraintsConfirmButton.insets = new Insets(4, 2, 2, 2);
                GridBagConstraints constraintsTSDateRangeSelector = new GridBagConstraints();
                constraintsTSDateRangeSelector.gridx = 0;
                constraintsTSDateRangeSelector.gridy = 0;
                constraintsTSDateRangeSelector.gridwidth = 2;
                constraintsTSDateRangeSelector.fill = 2;
                constraintsTSDateRangeSelector.anchor = 11;
                constraintsTSDateRangeSelector.weightx = 1.0;
                this.getJPanel4().add((Component)this.getTSDateRangeSelector(), constraintsTSDateRangeSelector);
                GridBagConstraints constraintsMaxRangeButton = new GridBagConstraints();
                constraintsMaxRangeButton.gridx = 0;
                constraintsMaxRangeButton.gridy = 1;
                constraintsMaxRangeButton.fill = 2;
                constraintsMaxRangeButton.insets = new Insets(4, 2, 2, 2);
                this.ivjJPanel4.add((Component)this.getConfirmButton(), constraintsConfirmButton);
                this.getJPanel4().add((Component)this.getMaxRangeButton(), constraintsMaxRangeButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel4;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.ivjJScrollPane1.setPreferredSize(new Dimension(205, 260));
                this.ivjJScrollPane1.setMinimumSize(new Dimension(205, 200));
                this.getJScrollPane1().setViewportView(this.getTSList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JScrollPane getJScrollPane2() {
        if (this.ivjJScrollPane2 == null) {
            try {
                this.ivjJScrollPane2 = new JScrollPane();
                this.ivjJScrollPane2.setName("JScrollPane2");
                this.ivjJScrollPane2.setPreferredSize(new Dimension(68, 68));
                this.getJScrollPane2().setViewportView(this.getEndSelList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane2;
    }

    private JScrollPane getJScrollPane3() {
        if (this.ivjJScrollPane3 == null) {
            try {
                this.ivjJScrollPane3 = new JScrollPane();
                this.ivjJScrollPane3.setName("JScrollPane3");
                this.ivjJScrollPane3.setPreferredSize(new Dimension(68, 68));
                this.getJScrollPane3().setViewportView(this.getExSelList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane3;
    }

    private JScrollPane getJScrollPane4() {
        if (this.ivjJScrollPane4 == null) {
            try {
                this.ivjJScrollPane4 = new JScrollPane();
                this.ivjJScrollPane4.setName("JScrollPane4");
                this.ivjJScrollPane4.setPreferredSize(new Dimension(68, 68));
                this.getJScrollPane4().setViewportView(this.getDetSelList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane4;
    }

    private JSplitPane getJSplitPane() {
        if (this.ivjJSplitPane == null) {
            try {
                this.ivjJSplitPane = new JSplitPane(0);
                this.ivjJSplitPane.setName("JSplitPane");
                this.ivjJSplitPane.setDividerSize(2);
                this.ivjJSplitPane.setDividerLocation(260);
                this.ivjJSplitPane.setBorder(null);
                this.getJSplitPane().add((Component)this.getJPanel2(), "bottom");
                this.getJSplitPane().add((Component)this.getJScrollPane1(), "top");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSplitPane;
    }

    private JButton getMaxRangeButton() {
        if (this.ivjMaxRangeButton == null) {
            try {
                this.ivjMaxRangeButton = new JButton();
                this.ivjMaxRangeButton.setName("MaxRangeButton");
                this.ivjMaxRangeButton.setToolTipText("Sets maximum possible time range.");
                this.ivjMaxRangeButton.setText("Max");
                this.ivjMaxRangeButton.setPreferredSize(new Dimension(60, 23));
                this.ivjMaxRangeButton.setMinimumSize(new Dimension(60, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMaxRangeButton;
    }

    public int getSelectionMode() {
        return this.getTSList().getSelectionMode();
    }

    private TSDateRangeSelector getTSDateRangeSelector() {
        if (this.ivjTSDateRangeSelector == null) {
            try {
                this.ivjTSDateRangeSelector = new TSDateRangeSelector();
                this.ivjTSDateRangeSelector.setName("TSDateRangeSelector");
                this.ivjTSDateRangeSelector.setPreferredSize(new Dimension(80, 20));
                this.ivjTSDateRangeSelector.setEnabled(false);
                this.ivjTSDateRangeSelector.setMinimumSize(new Dimension(80, 20));
                this.ivjTSDateRangeSelector.setEditable(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTSDateRangeSelector;
    }

    private TSList getTSList() {
        if (this.ivjTSList == null) {
            try {
                this.ivjTSList = new TSList();
                this.ivjTSList.setName("TSList");
                this.ivjTSList.setBounds(0, 0, 210, 255);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTSList;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.getTSList().addListSelectionListener(this.myEventHandler);
        this.getConfirmButton().addActionListener(this.ivjEventHandler);
        this.getMaxRangeButton().addActionListener(this.ivjEventHandler);
        this.addComponentListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("SelectPanel");
            this.setLayout(new BoxLayout(this, 0));
            this.setPreferredSize(new Dimension(216, 400));
            this.setSize(215, 477);
            this.setMinimumSize(new Dimension(216, 400));
            this.add((Component)this.getJSplitPane(), this.getJSplitPane().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        TitledBorder title = BorderFactory.createTitledBorder(null, "Ctrl/Shift for Multiple Selection", 3, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51));
        title.setTitleFont(CompSettings.smallFontDefault);
        this.setBorder(title);
        int vmCheck = System.getProperty("java.vm.version").toString().indexOf("1.4");
        if (vmCheck > -1) {
            this.getTSList().setLayoutOrientation(1);
        }
        this.getTSList().setVisibleRowCount(0);
        this.getJSplitPane().setDividerLocation(new Double((double)this.getHeight() - this.getJPanel2().getMinimumSize().getHeight() - 80.0).intValue());
        this.getTSDateRangeSelector().setMinNumberOfObs(2);
    }

    public boolean isOneEndogenousOnly() {
        return this.oneEndogenousOnly;
    }

    private void maxRangeButton_ActionEvents() {
        TSList list = this.getTSList();
        if (list.getSelectedIndex() == -1) {
            return;
        }
        list.removeListSelectionListener(this.myEventHandler);
        try {
            this.tsDateRangeCheck(true);
        }
        catch (Throwable ex) {
            log.error((Object)"Failed to set maximum range", ex);
        }
        list.addListSelectionListener(this.myEventHandler);
    }

    private void saveSelectionOrderToVector() {
        Integer intI;
        int i;
        int end;
        TSList list = this.getTSList();
        if (list.getSelectedIndex() == -1) {
            this.actualSelection.clear();
            return;
        }
        int start = 0;
        if (this.actualSelection.size() == 0) {
            this.actualSelection.add(new Integer(list.getLeadSelectionIndex()));
        }
        if (this.actualSelection.size() > 0) {
            start = this.actualSelection.get(this.actualSelection.size() - 1);
        }
        if ((end = list.getLeadSelectionIndex()) - start > 0) {
            for (i = start + 1; i <= end; ++i) {
                intI = new Integer(i);
                if (!list.isSelectedIndex(i) || this.actualSelection.contains(intI)) continue;
                this.actualSelection.add(intI);
            }
        }
        if (end - start < 0) {
            for (i = start - 1; i >= end; --i) {
                intI = new Integer(i);
                if (!list.isSelectedIndex(i) || this.actualSelection.contains(intI)) continue;
                this.actualSelection.add(intI);
            }
        }
        for (i = 0; i < this.actualSelection.size(); ++i) {
            if (list.isSelectedIndex(this.actualSelection.get(i))) continue;
            this.actualSelection.remove(i);
            --i;
        }
    }

    private void selectPanel_ComponentResized() {
        this.getJSplitPane().setDividerLocation(new Double((double)this.getHeight() - this.getJPanel2().getMinimumSize().getHeight() - 40.0).intValue());
    }

    public void setAllDataName(String allDataName) {
        this.allDataDef = allDataName == null ? null : new JSCTypeDef(allDataName, JSCTypes.NARRAY);
    }

    public void setAllStringsName(String allStringsName) {
        this.allStringsDef = allStringsName == null ? null : new JSCTypeDef(allStringsName, JSCTypes.SARRAY);
    }

    public void setDatesEditable(boolean newDatesEditable) {
        this.fieldDatesEditable = newDatesEditable;
        this.getTSDateRangeSelector().setEditable(this.fieldDatesEditable);
    }

    public void setDeterministicDataName(String deterministicDataName) {
        this.deterministicDataDef = deterministicDataName == null ? null : new JSCTypeDef(deterministicDataName, JSCTypes.NARRAY);
    }

    public void setDeterministicEnabled(boolean arg1) {
        this.getDetSelList().setEnabled(arg1);
    }

    public void setDeterministicStringsName(String deterministicStringsName) {
        this.deterministicStringsDef = deterministicStringsName == null ? null : new JSCTypeDef(deterministicStringsName, JSCTypes.SARRAY);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTSList().setEnabled(enabled);
        if (this.getDatesEditable() && this.getTSList().getSelectedIndex() > -1) {
            this.getTSDateRangeSelector().setEnabled(enabled);
        }
    }

    public void setEndogenousDataName(String endogenousDataName) {
        this.endogenousDataDef = endogenousDataName == null ? null : new JSCTypeDef(endogenousDataName, JSCTypes.NARRAY);
    }

    public void setEndogenousStringsName(String endogenousStringsName) {
        this.endogenousStringsDef = endogenousStringsName == null ? null : new JSCTypeDef(endogenousStringsName, JSCTypes.SARRAY);
    }

    public void setExogenousDataName(String exogenousDataName) {
        this.exogenousDataDef = exogenousDataName == null ? null : new JSCTypeDef(exogenousDataName, JSCTypes.NARRAY);
    }

    public void setExogenousEnabled(boolean arg1) {
        this.getExSelList().setEnabled(arg1);
    }

    public void setExogenousStringsName(String exogenousStringsName) {
        this.exogenousStringsDef = exogenousStringsName == null ? null : new JSCTypeDef(exogenousStringsName, JSCTypes.SARRAY);
    }

    public void setDateRangeName(String dateRangeName) {
        this.dateRangeDef = dateRangeName == null ? null : new JSCTypeDef(dateRangeName, JSCTypes.DRANGE);
    }

    public void setOneEndogenousOnly(boolean newOneEndogenousOnly) {
        this.oneEndogenousOnly = newOneEndogenousOnly;
    }

    public void setSelectionChanged() {
        this.firePropertyChange("selectionChanged", Boolean.valueOf("TRUE"), Boolean.valueOf("FALSE"));
    }

    public void setSelectionMode(int selectionMode) {
        this.getTSList().setSelectionMode(selectionMode);
    }

    private void tsDateRangeCheck(boolean setMaxRange) {
        TSList list = this.getTSList();
        if (this.actualSelection.size() == 0) {
            this.referencePeriodicity = -1;
            return;
        }
        int index = this.actualSelection.get(0);
        TS toCheck = this.timeSeriesData.getTS(list.getModel().getElementAt(index).toString());
        TSDateRange refDateRange = toCheck.range();
        int period = toCheck.start().subPeriodicity();
        if (period != this.referencePeriodicity) {
            this.getTSDateRangeSelector().setEnclosingRange(toCheck.range());
            this.referencePeriodicity = period;
        }
        for (int sel = 1; sel < this.actualSelection.size(); ++sel) {
            index = this.actualSelection.get(sel);
            TSDateRange dateRange = this.timeSeriesData.getTS(list.getModel().getElementAt(index).toString()).range();
            TSDateRange tmpDateRange = refDateRange.commonRange(dateRange);
            if (tmpDateRange == null || tmpDateRange.numOfObs() < 2) {
                this.actualSelection.remove(sel);
                --sel;
                continue;
            }
            refDateRange = tmpDateRange;
        }
        this.getTSDateRangeSelector().setEnclosingRange(refDateRange);
        if (setMaxRange) {
            this.getTSDateRangeSelector().maxRange();
        }
    }

    private void tSList_ListSelectionEvents() {
        boolean setMaxRange;
        TSList list = this.getTSList();
        boolean bl = setMaxRange = !this.getTSDateRangeSelector().isEnabled();
        if (!this.getTSDateRangeSelector().isEditable()) {
            setMaxRange = true;
        }
        if (list.getSelectedIndex() == -1) {
            this.getTSDateRangeSelector().setEnabled(false);
            this.getTSDateRangeSelector().setEditable(false);
        } else {
            this.getTSDateRangeSelector().setEnabled(true);
            this.getTSDateRangeSelector().setEditable(this.fieldDatesEditable);
        }
        list.removeListSelectionListener(this.myEventHandler);
        try {
            this.saveSelectionOrderToVector();
            this.checkOneEndogenousOnly();
            this.tsDateRangeCheck(setMaxRange);
            int[] indizes = new int[this.actualSelection.size()];
            for (int i = 0; i < indizes.length; ++i) {
                indizes[i] = this.actualSelection.get(i);
            }
            list.setSelectedIndices(indizes);
        }
        catch (Throwable ex) {
            log.error((Object)"Failed to set selection", ex);
        }
        list.addListSelectionListener(this.myEventHandler);
    }

    public void setUpperScope(boolean isUpper) {
        this.symbolScope = isUpper ? Scope.UPPER : Scope.GLOBAL;
    }

    public boolean isUpperScope() {
        return this.symbolScope == Scope.UPPER;
    }

    public boolean isCheckNaN() {
        return this.checkNaN;
    }

    public void setCheckNaN(boolean checkNaN) {
        this.checkNaN = checkNaN;
    }

    public void setSelection(Selection sel) {
        if (sel == null) {
            return;
        }
        JSCNArray i = sel.getSelectedIndices();
        JSCDRange e = sel.getEnclosingRange();
        JSCDRange r = sel.getSelectedRange();
        this.getTSList().clearSelection();
        int[][] index = i.intArray();
        int[] toSet = new int[index.length];
        for (int j = 0; j < toSet.length; ++j) {
            toSet[j] = index[j][0];
        }
        this.getTSList().setSelectedIndices(toSet);
        if (!r.isEmpty() && !e.isEmpty()) {
            this.getTSDateRangeSelector().setEnclosingRange(e.getTSDateRange());
            this.getTSDateRangeSelector().setTSDateRange(r.getTSDateRange());
        }
        this.tSList_ListSelectionEvents();
        this.confirmButton_ActionEvents();
    }

    public Selection getSelection() {
        Selection sel = new Selection();
        if (this.getEndSelList().getModel().getSize() == 0) {
            return sel;
        }
        sel.setSelectedIndices(new JSCNArray("selIndices", this.lastConfirmedSelection));
        sel.setEnclosingRange(new JSCDRange("enclosing", this.getTSDateRangeSelector().getEnclosingRange()));
        sel.setSelectedRange(new JSCDRange("range", this.getTSDateRangeSelector().getTSDateRange()));
        return sel;
    }

    class IvjEventHandler
    implements ActionListener,
    ComponentListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TSSel.this.getConfirmButton()) {
                TSSel.this.connEtoC1();
            }
            if (e.getSource() == TSSel.this.getMaxRangeButton()) {
                TSSel.this.connEtoC2();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (e.getSource() == TSSel.this) {
                TSSel.this.connEtoC3();
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    private static class MyNonSelectableListCellRenderer
    extends DefaultListCellRenderer {
        private MyNonSelectableListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, value, index, false, false);
        }
    }

    class MyEventHandler
    implements ListSelectionListener {
        MyEventHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (e.getSource() == TSSel.this.getTSList()) {
                TSSel.this.tSList_ListSelectionEvents();
            }
        }
    }
}

