/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.TopFrameReference;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDate;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.project.ProjectData;
import com.jstatcom.project.ProjectDataHandler;
import com.jstatcom.project.ProjectDataTypes;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSProject;
import com.jstatcom.ts.TSProjectData;
import com.jstatcom.ts.TSTypes;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.ListModel;

public class TSHolder
implements ProjectDataHandler {
    private static final TSHolder tsHolder = new TSHolder();
    public static final String TS_ADDED = "TS_ADDED";
    public static final String TS_REMOVED = "TS_REMOVED";
    public static final String ALL_TS_REMOVED = "ALL_TS_REMOVED";
    private final Vector<PropertyChangeListener> propertyChangeListeners = new Vector();
    private final Map<String, TS> tsHashTable = new HashMap<String, TS>();
    private final TSListModel tsListModel = new TSListModel();

    private TSHolder() {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTS(TS[] newTimeSeries) {
        if (newTimeSeries == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        TSHolder tSHolder = this;
        synchronized (tSHolder) {
            this.removeAllTS();
            for (int i = 0; i < newTimeSeries.length; ++i) {
                this.addTS(newTimeSeries[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTS(TS newTimeSeries) {
        int accept = 0;
        if (newTimeSeries == null) {
            return accept;
        }
        String newNameOrig = newTimeSeries.name();
        String newName = newNameOrig.toLowerCase();
        if (newTimeSeries.numOfObs() < 2) {
            JOptionPane.showConfirmDialog(TopFrameReference.getTopFrameRef(), "Variable \"" + newName + "\" contains less than 2 observations.\nIt will not be added.", "Error", -1, 0);
            return 1;
        }
        TSHolder tSHolder = this;
        synchronized (tSHolder) {
            if (this.tsHashTable.containsKey(newName)) {
                accept = JOptionPane.showConfirmDialog(TopFrameReference.getTopFrameRef(), "Variable name \"" + newNameOrig + "\" already exists, overwrite?", "Question", 1);
            }
            if (accept == 0) {
                this.tsListModel.removeElement(newNameOrig);
                this.tsHashTable.put(newName, newTimeSeries);
                this.tsListModel.addElement(newNameOrig);
            }
        }
        if (accept == 0) {
            this.firePropertyChange(TS_ADDED, newName, newName);
        }
        return accept;
    }

    public boolean contains(String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        return this.tsHashTable.containsKey(name);
    }

    private void firePropertyChange(String propName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propName, oldValue, newValue);
        for (int i = 0; i < this.propertyChangeListeners.size(); ++i) {
            this.propertyChangeListeners.get(i).propertyChange(evt);
        }
    }

    public synchronized ListModel getAsListModel() {
        return this.tsListModel;
    }

    public static TSHolder getInstance() {
        return tsHolder;
    }

    public synchronized TS getTS(String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        if (this.tsHashTable.containsKey(name)) {
            return this.tsHashTable.get(name);
        }
        return null;
    }

    public synchronized TS[] getAllTS() {
        TS[] ts = new TS[this.tsHashTable.size()];
        int i = 0;
        for (TS tsEl : this.tsHashTable.values()) {
            ts[i++] = tsEl;
        }
        return ts;
    }

    public Iterator<String> getTSNames() {
        return this.tsHashTable.keySet().iterator();
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTS(String name) {
        boolean fireChanged = false;
        TSHolder tSHolder = this;
        synchronized (tSHolder) {
            if (this.tsHashTable.containsKey(name.toLowerCase())) {
                this.tsListModel.removeElement(name);
                this.tsHashTable.remove(name.toLowerCase());
                fireChanged = true;
            }
        }
        if (fireChanged) {
            this.firePropertyChange(TS_REMOVED, name, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTS() {
        TSHolder tSHolder = this;
        synchronized (tSHolder) {
            if (this.tsHashTable.size() == 0) {
                return;
            }
            this.tsListModel.clear();
            this.tsHashTable.clear();
        }
        this.firePropertyChange(ALL_TS_REMOVED, null, null);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(super.toString() + " [");
        for (String name : this.tsHashTable.keySet()) {
            ret.append("\"" + name + "\",");
        }
        if (this.tsHashTable.size() > 0) {
            ret.deleteCharAt(ret.length() - 1);
        }
        ret.append("]");
        return ret.toString();
    }

    @Override
    public void setProjectData(ProjectData pData) {
        if (pData == null) {
            return;
        }
        TSHolder.getInstance().removeAllTS();
        JSCData[] data = pData.getJSCData();
        int tsCount = data.length / 4;
        if (tsCount == 0) {
            return;
        }
        String description = pData.getDescription();
        TSProject project = new TSProject("TS_DATA", description);
        TS[] ts = new TS[tsCount];
        int k = 0;
        for (int i = 0; i < tsCount; ++i) {
            JSCData data_k = data[k++];
            String name = ((JSCString)data_k).string();
            data_k = data[k++];
            TSTypes tsType = TSTypes.valueOf(((JSCString)data_k).string());
            data_k = data[k++];
            TSDate start = ((JSCDate)data_k).getTSDate();
            data_k = data[k++];
            double[] values = ((JSCNArray)data_k).getCol(0);
            ts[i] = new TS(values, name, start, tsType, project);
        }
        this.setTS(ts);
    }

    @Override
    public ProjectData getProjectData() {
        TS[] ts = this.getAllTS();
        JSCData[] rtn = new JSCData[ts.length * 4];
        ArrayList<TSProject> projectList = new ArrayList<TSProject>();
        StringBuffer des = new StringBuffer();
        int k = 0;
        for (int i = 0; i < ts.length; ++i) {
            if (!projectList.contains(ts[i].project())) {
                TSProject tmp = ts[i].project();
                projectList.add(tmp);
                if (tmp != null) {
                    des.append(tmp.getDescription());
                }
            }
            rtn[k++] = new JSCString("ts_name_" + i, ts[i].name());
            rtn[k++] = new JSCString("ts_type_" + i, ts[i].type().getName());
            rtn[k++] = new JSCDate("ts_start_" + i, ts[i].start());
            rtn[k++] = new JSCNArray("ts_data_" + i, ts[i].values());
        }
        TSProjectData data = new TSProjectData();
        if (ts.length > 0) {
            data.setDescription(des.toString());
        }
        data.setJSCData(rtn);
        return data;
    }

    @Override
    public ProjectDataTypes getProjectDataType() {
        return ProjectDataTypes.TS_DATA;
    }

    private static class TSListModel
    extends DefaultListModel {
        private TSListModel() {
        }

        public void addElement(Object obj) {
            if (this.getSize() == 0) {
                super.addElement(obj);
                return;
            }
            String toAdd = obj.toString();
            String toCompare = toAdd.toUpperCase();
            for (int i = 0; i < this.getSize(); ++i) {
                if (this.getElementAt(i).toString().toUpperCase().compareTo(toCompare) < 0) continue;
                super.add(i, toAdd);
                return;
            }
            super.addElement(obj);
        }

        @Override
        public boolean removeElement(Object obj) {
            if (super.removeElement(obj)) {
                return true;
            }
            String toAdd = obj.toString();
            for (int i = 0; i < this.getSize(); ++i) {
                String obj_i = this.getElementAt(i).toString();
                if (!obj_i.equalsIgnoreCase(toAdd)) continue;
                return super.removeElement(obj_i);
            }
            return false;
        }
    }
}

