/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.CompSettings;
import com.jstatcom.component.MultiLineLabel;
import com.jstatcom.component.ResultField;
import com.jstatcom.model.JSCDRange;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.ModelPanel;
import com.jstatcom.parser.CalcEngine;
import com.jstatcom.parser.ParseException;
import com.jstatcom.parser.TokenMgrError;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSHolder;
import com.jstatcom.ts.TSProject;
import com.jstatcom.util.ComparatorTypes;
import com.jstatcom.util.UData;
import com.jstatcom.util.UMatrix;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

final class TSCalculatorPanel
extends ModelPanel {
    private static final Logger log = Logger.getLogger(TSCalculatorPanel.class);
    private final StringBuffer commands = new StringBuffer();
    public static final JSCTypeDef ALL_STRINGS_DEF = new JSCTypeDef("TSCalc_AllStringName", JSCTypes.SARRAY, "Selected variable names for the TS Calculator.");
    private TSDate startDate = null;
    private final CalcEngine parser = new CalcEngine();
    private final DefaultListModel variableListModel = new DefaultListModel();
    private ResultField ivjResultField = null;
    private ResultField ivjInputField = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private MyEventHandler myEventHandler = new MyEventHandler();
    private JButton ivjExecute = null;
    private JButton ivjAdd = null;
    private JButton ivjB00 = null;
    private JButton ivjB01 = null;
    private JButton ivjB02 = null;
    private JButton ivjB03 = null;
    private JButton ivjB04 = null;
    private JButton ivjB05 = null;
    private JButton ivjB06 = null;
    private JButton ivjB07 = null;
    private JButton ivjB08 = null;
    private JButton ivjB09 = null;
    private JButton ivjB0divide = null;
    private JButton ivjB0equals = null;
    private JButton ivjB0leftb = null;
    private JButton ivjB0minus = null;
    private JButton ivjB0mult = null;
    private JButton ivjB0plus = null;
    private JButton ivjB0pow = null;
    private JButton ivjB0rightb = null;
    private JList ivjNamesList = null;
    private JScrollPane ivjNamesListScrollPane = null;
    private JButton ivjB0Point = null;
    private JButton ivjB0RowAppend = null;
    private JButton ivjB0Ones = null;
    private JButton ivjB0log = null;
    private JButton ivjB0Rand = null;
    private JButton ivjB0Reverse = null;
    private JButton ivjB0Stand = null;
    private JButton ivjB0Stand1 = null;
    private JButton ivjB0Trend = null;
    private JButton ivjClearButton = null;
    private JPanel ivjCalcKeysPanel = null;
    private JPanel ivjJPanel2 = null;
    private MultiLineLabel multiLineLabel = null;

    public TSCalculatorPanel() {
        this.initialize();
    }

    private void add_ActionEvents() {
        int[] selIndex = this.getNamesList().getSelectedIndices();
        if (this.startDate == null) {
            this.startDate = new TSDate();
        }
        TSProject project = new TSProject("Calculator");
        project.setDescription("\n" + this.commands.toString() + "\n");
        for (int i = 0; i < selIndex.length; ++i) {
            String name = this.variableListModel.getElementAt(selIndex[i]).toString();
            double[] tsData = this.parser.getVariable(name);
            TS toAdd = new TS(tsData, name, this.startDate);
            toAdd.setTSProject(project);
            int res = TSHolder.getInstance().addTS(toAdd);
            if (res != 2) continue;
            return;
        }
    }

    private void calc_ActionPerformed(ActionEvent actionEvent) {
        String toPut = ((JButton)actionEvent.getSource()).getText();
        this.getInputField().getTextArea().insert(toPut, this.getInputField().getTextArea().getCaretPosition());
    }

    private void clearButton_ActionEvents() {
        this.getInputField().clear();
    }

    private void connEtoC1() {
        try {
            this.execute_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.clearButton_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.add_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(MouseEvent arg1) {
        try {
            this.namesList_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void execute_ActionEvents() {
        try {
            String code = this.getInputField().getTextArea().getText() + ";";
            this.parser.parseString(code);
            StringTokenizer st = new StringTokenizer(code, ";");
            while (st.hasMoreTokens()) {
                this.commands.append(st.nextToken().trim() + ";\n");
            }
            this.getResultField().append(this.parser.getOutput());
            String[] res = this.parser.getVariableNames();
            Arrays.sort(res, ComparatorTypes.STRING_DEFAULT);
            this.variableListModel.clear();
            for (int i = 0; i < res.length; ++i) {
                this.variableListModel.addElement(res[i]);
            }
        }
        catch (ParseException ex) {
            this.getResultField().append(ex.getMessage() + "\n");
        }
        catch (TokenMgrError ex) {
            this.getResultField().append(ex.getMessage() + "\n");
        }
    }

    private JButton getAdd() {
        if (this.ivjAdd == null) {
            try {
                this.ivjAdd = new JButton();
                this.ivjAdd.setName("Add");
                this.ivjAdd.setPreferredSize(new Dimension(85, 25));
                this.ivjAdd.setText("Add Selected");
                this.ivjAdd.setMargin(new Insets(2, 2, 2, 2));
                this.ivjAdd.setMinimumSize(new Dimension(100, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAdd;
    }

    private JButton getB00() {
        if (this.ivjB00 == null) {
            try {
                this.ivjB00 = new JButton();
                this.ivjB00.setName("B00");
                this.ivjB00.setText("0");
                this.ivjB00.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB00.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB00;
    }

    private JButton getB01() {
        if (this.ivjB01 == null) {
            try {
                this.ivjB01 = new JButton();
                this.ivjB01.setName("B01");
                this.ivjB01.setText("1");
                this.ivjB01.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB01.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB01;
    }

    private JButton getB02() {
        if (this.ivjB02 == null) {
            try {
                this.ivjB02 = new JButton();
                this.ivjB02.setName("B02");
                this.ivjB02.setText("2");
                this.ivjB02.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB02.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB02;
    }

    private JButton getB03() {
        if (this.ivjB03 == null) {
            try {
                this.ivjB03 = new JButton();
                this.ivjB03.setName("B03");
                this.ivjB03.setText("3");
                this.ivjB03.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB03.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB03;
    }

    private JButton getB04() {
        if (this.ivjB04 == null) {
            try {
                this.ivjB04 = new JButton();
                this.ivjB04.setName("B04");
                this.ivjB04.setText("4");
                this.ivjB04.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB04.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB04;
    }

    private JButton getB05() {
        if (this.ivjB05 == null) {
            try {
                this.ivjB05 = new JButton();
                this.ivjB05.setName("B05");
                this.ivjB05.setText("5");
                this.ivjB05.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB05.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB05;
    }

    private JButton getB06() {
        if (this.ivjB06 == null) {
            try {
                this.ivjB06 = new JButton();
                this.ivjB06.setName("B06");
                this.ivjB06.setText("6");
                this.ivjB06.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB06.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB06;
    }

    private JButton getB07() {
        if (this.ivjB07 == null) {
            try {
                this.ivjB07 = new JButton();
                this.ivjB07.setName("B07");
                this.ivjB07.setText("7");
                this.ivjB07.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB07.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB07;
    }

    private JButton getB08() {
        if (this.ivjB08 == null) {
            try {
                this.ivjB08 = new JButton();
                this.ivjB08.setName("B08");
                this.ivjB08.setText("8");
                this.ivjB08.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB08.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB08;
    }

    private JButton getB09() {
        if (this.ivjB09 == null) {
            try {
                this.ivjB09 = new JButton();
                this.ivjB09.setName("B09");
                this.ivjB09.setText("9");
                this.ivjB09.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB09.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB09;
    }

    private JButton getB0Cos() {
        if (this.ivjB0Ones == null) {
            try {
                this.ivjB0Ones = new JButton();
                this.ivjB0Ones.setName("B0Cos");
                this.ivjB0Ones.setToolTipText("e.g. ones(82)");
                this.ivjB0Ones.setText("ones");
                this.ivjB0Ones.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0Ones.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0Ones;
    }

    private JButton getB0divide() {
        if (this.ivjB0divide == null) {
            try {
                this.ivjB0divide = new JButton();
                this.ivjB0divide.setName("B0divide");
                this.ivjB0divide.setToolTipText("divide");
                this.ivjB0divide.setText("/");
                this.ivjB0divide.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0divide.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0divide;
    }

    private JButton getB0equals() {
        if (this.ivjB0equals == null) {
            try {
                this.ivjB0equals = new JButton();
                this.ivjB0equals.setName("B0equals");
                this.ivjB0equals.setText("=");
                this.ivjB0equals.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0equals.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0equals;
    }

    private JButton getB0leftb() {
        if (this.ivjB0leftb == null) {
            try {
                this.ivjB0leftb = new JButton();
                this.ivjB0leftb.setName("B0leftb");
                this.ivjB0leftb.setText("(");
                this.ivjB0leftb.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0leftb.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0leftb;
    }

    private JButton getB0log() {
        if (this.ivjB0log == null) {
            try {
                this.ivjB0log = new JButton();
                this.ivjB0log.setName("B0log");
                this.ivjB0log.setToolTipText("e.g. log(invest)");
                this.ivjB0log.setText("log");
                this.ivjB0log.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0log.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0log;
    }

    private JButton getB0minus() {
        if (this.ivjB0minus == null) {
            try {
                this.ivjB0minus = new JButton();
                this.ivjB0minus.setName("B0minus");
                this.ivjB0minus.setToolTipText("subtract");
                this.ivjB0minus.setText("-");
                this.ivjB0minus.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0minus.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0minus;
    }

    private JButton getB0mult() {
        if (this.ivjB0mult == null) {
            try {
                this.ivjB0mult = new JButton();
                this.ivjB0mult.setName("B0mult");
                this.ivjB0mult.setToolTipText("multiply");
                this.ivjB0mult.setText("*");
                this.ivjB0mult.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0mult.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0mult;
    }

    private JButton getB0plus() {
        if (this.ivjB0plus == null) {
            try {
                this.ivjB0plus = new JButton();
                this.ivjB0plus.setName("B0plus");
                this.ivjB0plus.setToolTipText("add");
                this.ivjB0plus.setText("+");
                this.ivjB0plus.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0plus.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0plus;
    }

    private JButton getB0Point() {
        if (this.ivjB0Point == null) {
            try {
                this.ivjB0Point = new JButton();
                this.ivjB0Point.setName("B0Point");
                this.ivjB0Point.setToolTipText("decimal point");
                this.ivjB0Point.setText(".");
                this.ivjB0Point.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0Point.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0Point;
    }

    private JButton getB0pow() {
        if (this.ivjB0pow == null) {
            try {
                this.ivjB0pow = new JButton();
                this.ivjB0pow.setName("B0pow");
                this.ivjB0pow.setToolTipText("e.g. 2^4=16");
                this.ivjB0pow.setText("^");
                this.ivjB0pow.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0pow.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0pow;
    }

    private JButton getB0Rand() {
        if (this.ivjB0Rand == null) {
            try {
                this.ivjB0Rand = new JButton();
                this.ivjB0Rand.setName("B0Rand");
                this.ivjB0Rand.setToolTipText("e.g. rndn(100)");
                this.ivjB0Rand.setText("rndn");
                this.ivjB0Rand.setMargin(new Insets(2, 2, 2, 2));
                this.ivjB0Rand.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0Rand;
    }

    private JButton getB0rightb() {
        if (this.ivjB0rightb == null) {
            try {
                this.ivjB0rightb = new JButton();
                this.ivjB0rightb.setName("B0rightb");
                this.ivjB0rightb.setText(")");
                this.ivjB0rightb.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0rightb.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0rightb;
    }

    private JButton getB0RowAppend() {
        if (this.ivjB0RowAppend == null) {
            try {
                this.ivjB0RowAppend = new JButton();
                this.ivjB0RowAppend.setName("B0RowAppend");
                this.ivjB0RowAppend.setToolTipText("e.g. a|b, appends one series to the other");
                this.ivjB0RowAppend.setText("|");
                this.ivjB0RowAppend.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0RowAppend.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0RowAppend;
    }

    private JButton getB0Sin() {
        if (this.ivjB0Reverse == null) {
            try {
                this.ivjB0Reverse = new JButton();
                this.ivjB0Reverse.setName("B0Sin");
                this.ivjB0Reverse.setToolTipText("e.g. reverse(invest)");
                this.ivjB0Reverse.setText("reverse");
                this.ivjB0Reverse.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0Reverse.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0Reverse;
    }

    private JButton getB0Stand() {
        if (this.ivjB0Stand == null) {
            try {
                this.ivjB0Stand = new JButton();
                this.ivjB0Stand.setName("B0Stand");
                this.ivjB0Stand.setToolTipText("e.g. stand(invest)");
                this.ivjB0Stand.setText("stand");
                this.ivjB0Stand.setMargin(new Insets(2, 1, 2, 1));
                this.ivjB0Stand.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0Stand;
    }

    private JButton getB0Stand1() {
        if (this.ivjB0Stand1 == null) {
            try {
                this.ivjB0Stand1 = new JButton();
                this.ivjB0Stand1.setName("B0Stand1");
                this.ivjB0Stand1.setToolTipText("e.g. lagn(invest,1)");
                this.ivjB0Stand1.setText("lagn");
                this.ivjB0Stand1.setMargin(new Insets(2, 1, 2, 1));
                this.ivjB0Stand1.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0Stand1;
    }

    private JButton getB0Tan() {
        if (this.ivjB0Trend == null) {
            try {
                this.ivjB0Trend = new JButton();
                this.ivjB0Trend.setName("B0Tan");
                this.ivjB0Trend.setToolTipText("e.g. trend(75)");
                this.ivjB0Trend.setText("trend");
                this.ivjB0Trend.setMargin(new Insets(2, 5, 2, 5));
                this.ivjB0Trend.setFocusPainted(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjB0Trend;
    }

    private JPanel getCalcKeysPanel() {
        if (this.ivjCalcKeysPanel == null) {
            try {
                this.ivjCalcKeysPanel = new JPanel();
                this.ivjCalcKeysPanel.setName("CalcKeysPanel");
                this.ivjCalcKeysPanel.setBorder(new BevelBorder(1));
                this.ivjCalcKeysPanel.setLayout(this.getCalcKeysPanelGridLayout());
                this.getCalcKeysPanel().add((Component)this.getB00(), this.getB00().getName());
                this.getCalcKeysPanel().add((Component)this.getB01(), this.getB01().getName());
                this.getCalcKeysPanel().add((Component)this.getB02(), this.getB02().getName());
                this.getCalcKeysPanel().add((Component)this.getB03(), this.getB03().getName());
                this.getCalcKeysPanel().add((Component)this.getB04(), this.getB04().getName());
                this.getCalcKeysPanel().add((Component)this.getB05(), this.getB05().getName());
                this.getCalcKeysPanel().add((Component)this.getB06(), this.getB06().getName());
                this.getCalcKeysPanel().add((Component)this.getB07(), this.getB07().getName());
                this.getCalcKeysPanel().add((Component)this.getB08(), this.getB08().getName());
                this.getCalcKeysPanel().add((Component)this.getB09(), this.getB09().getName());
                this.getCalcKeysPanel().add((Component)this.getB0log(), this.getB0log().getName());
                this.getCalcKeysPanel().add((Component)this.getB0Sin(), this.getB0Sin().getName());
                this.getCalcKeysPanel().add((Component)this.getB0Cos(), this.getB0Cos().getName());
                this.getCalcKeysPanel().add((Component)this.getB0Tan(), this.getB0Tan().getName());
                this.getCalcKeysPanel().add((Component)this.getB0Rand(), this.getB0Rand().getName());
                this.getCalcKeysPanel().add((Component)this.getB0Stand(), this.getB0Stand().getName());
                this.getCalcKeysPanel().add((Component)this.getB0Stand1(), this.getB0Stand1().getName());
                this.getCalcKeysPanel().add((Component)this.getB0Point(), this.getB0Point().getName());
                this.getCalcKeysPanel().add((Component)this.getB0plus(), this.getB0plus().getName());
                this.getCalcKeysPanel().add((Component)this.getB0minus(), this.getB0minus().getName());
                this.getCalcKeysPanel().add((Component)this.getB0divide(), this.getB0divide().getName());
                this.getCalcKeysPanel().add((Component)this.getB0mult(), this.getB0mult().getName());
                this.getCalcKeysPanel().add((Component)this.getB0pow(), this.getB0pow().getName());
                this.getCalcKeysPanel().add((Component)this.getB0leftb(), this.getB0leftb().getName());
                this.getCalcKeysPanel().add((Component)this.getB0rightb(), this.getB0rightb().getName());
                this.getCalcKeysPanel().add((Component)this.getB0RowAppend(), this.getB0RowAppend().getName());
                this.getCalcKeysPanel().add((Component)this.getB0equals(), this.getB0equals().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCalcKeysPanel;
    }

    private GridLayout getCalcKeysPanelGridLayout() {
        GridLayout ivjCalcKeysPanelGridLayout = null;
        try {
            ivjCalcKeysPanelGridLayout = new GridLayout();
            ivjCalcKeysPanelGridLayout.setRows(9);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjCalcKeysPanelGridLayout;
    }

    private JButton getClearButton() {
        if (this.ivjClearButton == null) {
            try {
                this.ivjClearButton = new JButton();
                this.ivjClearButton.setName("ClearButton");
                this.ivjClearButton.setPreferredSize(new Dimension(100, 25));
                this.ivjClearButton.setText("Clear");
                this.ivjClearButton.setMargin(new Insets(2, 2, 2, 2));
                this.ivjClearButton.setMinimumSize(new Dimension(100, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearButton;
    }

    private JButton getExecute() {
        if (this.ivjExecute == null) {
            try {
                this.ivjExecute = new JButton();
                this.ivjExecute.setName("Execute");
                this.ivjExecute.setPreferredSize(new Dimension(100, 25));
                this.ivjExecute.setText("Execute");
                this.ivjExecute.setMargin(new Insets(2, 2, 2, 2));
                this.ivjExecute.setMinimumSize(new Dimension(100, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExecute;
    }

    private ResultField getInputField() {
        if (this.ivjInputField == null) {
            try {
                this.ivjInputField = new ResultField();
                this.ivjInputField.setName("InputField");
                this.ivjInputField.setPreferredSize(new Dimension(13, 200));
                this.ivjInputField.setMinimumSize(new Dimension(22, 200));
                TitledBorder title = new TitledBorder(new BevelBorder(1), "Press Ctrl+E to run Code");
                title.setTitleFont(CompSettings.smallFontDefault);
                this.ivjInputField.setBorder(title);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInputField;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setPreferredSize(new Dimension(0, 35));
                this.ivjJPanel2.setLayout(this.getJPanel2FlowLayout());
                this.ivjJPanel2.setMinimumSize(new Dimension(0, 35));
                this.getJPanel2().add((Component)this.getExecute(), this.getExecute().getName());
                this.getJPanel2().add((Component)this.getClearButton(), this.getClearButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private FlowLayout getJPanel2FlowLayout() {
        FlowLayout ivjJPanel2FlowLayout = null;
        try {
            ivjJPanel2FlowLayout = new FlowLayout();
            ivjJPanel2FlowLayout.setHgap(20);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel2FlowLayout;
    }

    private JList getNamesList() {
        if (this.ivjNamesList == null) {
            try {
                this.ivjNamesList = new JList();
                this.ivjNamesList.setName("NamesList");
                this.ivjNamesList.setBounds(0, 0, 200, 200);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNamesList;
    }

    private JScrollPane getNamesListScrollPane() {
        if (this.ivjNamesListScrollPane == null) {
            try {
                this.ivjNamesListScrollPane = new JScrollPane();
                this.ivjNamesListScrollPane.setName("NamesListScrollPane");
                this.ivjNamesListScrollPane.setVerticalScrollBarPolicy(20);
                this.ivjNamesListScrollPane.setHorizontalScrollBarPolicy(30);
                this.ivjNamesListScrollPane.setPreferredSize(new Dimension(150, 100));
                this.ivjNamesListScrollPane.setMinimumSize(new Dimension(150, 22));
                this.getNamesListScrollPane().setViewportView(this.getNamesList());
                TitledBorder title = new TitledBorder(new BevelBorder(1), "Available Variables");
                title.setTitleFont(CompSettings.smallFontDefault);
                this.ivjNamesListScrollPane.setBorder(title);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNamesListScrollPane;
    }

    private ResultField getResultField() {
        if (this.ivjResultField == null) {
            try {
                this.ivjResultField = new ResultField();
                this.ivjResultField.setName("ResultField");
                this.ivjResultField.setPreferredSize(new Dimension(13, 100));
                TitledBorder title = new TitledBorder(new BevelBorder(1), "Output from Calculation");
                title.setTitleFont(CompSettings.smallFontDefault);
                this.ivjResultField.setBorder(title);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjResultField;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.getB00().addActionListener(this.myEventHandler);
        this.getB01().addActionListener(this.myEventHandler);
        this.getB02().addActionListener(this.myEventHandler);
        this.getB03().addActionListener(this.myEventHandler);
        this.getB04().addActionListener(this.myEventHandler);
        this.getB05().addActionListener(this.myEventHandler);
        this.getB06().addActionListener(this.myEventHandler);
        this.getB07().addActionListener(this.myEventHandler);
        this.getB08().addActionListener(this.myEventHandler);
        this.getB09().addActionListener(this.myEventHandler);
        this.getB0log().addActionListener(this.myEventHandler);
        this.getB0Sin().addActionListener(this.myEventHandler);
        this.getB0Cos().addActionListener(this.myEventHandler);
        this.getB0Tan().addActionListener(this.myEventHandler);
        this.getB0Rand().addActionListener(this.myEventHandler);
        this.getB0Stand().addActionListener(this.myEventHandler);
        this.getB0Stand1().addActionListener(this.myEventHandler);
        this.getB0Point().addActionListener(this.myEventHandler);
        this.getB0plus().addActionListener(this.myEventHandler);
        this.getB0minus().addActionListener(this.myEventHandler);
        this.getB0divide().addActionListener(this.myEventHandler);
        this.getB0mult().addActionListener(this.myEventHandler);
        this.getB0pow().addActionListener(this.myEventHandler);
        this.getB0leftb().addActionListener(this.myEventHandler);
        this.getB0rightb().addActionListener(this.myEventHandler);
        this.getB0RowAppend().addActionListener(this.myEventHandler);
        this.getB0equals().addActionListener(this.myEventHandler);
        this.getInputField().getTextArea().addKeyListener(this.myEventHandler);
        this.getExecute().addActionListener(this.ivjEventHandler);
        this.getAdd().addActionListener(this.ivjEventHandler);
        this.getNamesList().addMouseListener(this.ivjEventHandler);
        this.getClearButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(7, 2, 2, 2);
            gridBagConstraints.gridy = 0;
            this.multiLineLabel = new MultiLineLabel();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.setName("TSCalculator");
            this.setLayout(new GridBagLayout());
            this.setSize(734, 526);
            GridBagConstraints constraintsResultField = new GridBagConstraints();
            constraintsResultField.gridx = 0;
            constraintsResultField.gridy = 5;
            constraintsResultField.gridwidth = 3;
            constraintsResultField.gridheight = 3;
            constraintsResultField.fill = 1;
            constraintsResultField.weightx = 1.0;
            constraintsResultField.weighty = 1.0;
            GridBagConstraints constraintsInputField = new GridBagConstraints();
            constraintsInputField.gridx = 0;
            constraintsInputField.gridy = 0;
            constraintsInputField.gridwidth = 4;
            constraintsInputField.gridheight = 2;
            constraintsInputField.fill = 1;
            GridBagConstraints constraintsCalcKeysPanel = new GridBagConstraints();
            constraintsCalcKeysPanel.gridx = 3;
            constraintsCalcKeysPanel.gridy = 5;
            constraintsCalcKeysPanel.gridheight = 1;
            constraintsCalcKeysPanel.anchor = 11;
            constraintsCalcKeysPanel.insets = new Insets(7, 0, 0, 0);
            GridBagConstraints constraintsNamesListScrollPane = new GridBagConstraints();
            constraintsNamesListScrollPane.gridx = 4;
            constraintsNamesListScrollPane.gridy = 1;
            constraintsNamesListScrollPane.gridheight = 7;
            constraintsNamesListScrollPane.fill = 1;
            constraintsNamesListScrollPane.weighty = 1.0;
            GridBagConstraints constraintsJPanel2 = new GridBagConstraints();
            constraintsJPanel2.gridx = 2;
            constraintsJPanel2.gridy = 2;
            constraintsJPanel2.gridwidth = 2;
            constraintsJPanel2.fill = 1;
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.gridy = 7;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            this.multiLineLabel.setText("See help for more functions.");
            this.multiLineLabel.setVerticalAlignment(1);
            this.add((Component)this.getInputField(), constraintsInputField);
            this.add((Component)this.getResultField(), constraintsResultField);
            this.add((Component)this.getCalcKeysPanel(), constraintsCalcKeysPanel);
            this.add((Component)this.getNamesListScrollPane(), constraintsNamesListScrollPane);
            this.add((Component)this.getJPanel2(), constraintsJPanel2);
            this.add((Component)this.multiLineLabel, gridBagConstraints2);
            this.add((Component)this.getAdd(), gridBagConstraints);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getNamesList().setModel(this.variableListModel);
    }

    private void keyTyped_ActionEvents(KeyEvent e) {
        if (e.getKeyCode() == 69 && e.isControlDown()) {
            this.execute_ActionEvents();
        }
    }

    private void namesList_MouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            int index = this.getNamesList().locationToIndex(mouseEvent.getPoint());
            String toPut = this.variableListModel.elementAt(index).toString();
            this.getInputField().getTextArea().insert(toPut, this.getInputField().getTextArea().getCaretPosition());
        }
    }

    public void selectionChanged() {
        int i;
        JSCSArray selNames = this.global().get(ALL_STRINGS_DEF).getJSCSArray();
        if (selNames.isEmpty()) {
            this.parser.clearVariableMap();
            this.variableListModel.clear();
            return;
        }
        JSCData[] all = UData.mergeTS(selNames, "TSCalc_AllDat", "earliestStart");
        JSCNArray allData = (JSCNArray)all[0];
        this.startDate = ((JSCDRange)all[1]).getTSDateRange().lowerBound();
        double[][] selData = allData.doubleArray();
        if (selNames.rows() != selData[0].length) {
            throw new IllegalArgumentException("Dimensions of DataArray and NamesArray do not fit.");
        }
        this.parser.clearVariableMap();
        this.variableListModel.clear();
        this.commands.delete(0, this.commands.length());
        String[] varNames = new String[selNames.rows()];
        for (i = 0; i < selNames.rows(); ++i) {
            varNames[i] = selNames.stringAt(i, 0);
            double[] dat = UMatrix.getDoubleCol(selData, i);
            this.parser.putVariable(varNames[i], dat);
        }
        Arrays.sort(varNames, ComparatorTypes.STRING_DEFAULT);
        for (i = 0; i < varNames.length; ++i) {
            this.variableListModel.addElement(varNames[i]);
        }
    }

    class IvjEventHandler
    implements ActionListener,
    MouseListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TSCalculatorPanel.this.getExecute()) {
                TSCalculatorPanel.this.connEtoC1();
            }
            if (e.getSource() == TSCalculatorPanel.this.getAdd()) {
                TSCalculatorPanel.this.connEtoC3();
            }
            if (e.getSource() == TSCalculatorPanel.this.getClearButton()) {
                TSCalculatorPanel.this.connEtoC2();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == TSCalculatorPanel.this.getNamesList()) {
                TSCalculatorPanel.this.connEtoC4(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class MyEventHandler
    implements ActionListener,
    KeyListener {
        MyEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TSCalculatorPanel.this.calc_ActionPerformed(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TSCalculatorPanel.this.keyTyped_ActionEvents(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

