/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.component.CompSettings;
import com.jstatcom.component.StdMessages;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.NumberRange;
import com.jstatcom.model.NumberRangeTypes;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.table.JSCAbstractDataTable;
import com.jstatcom.table.JSCCellRendererTypes;
import com.jstatcom.table.JSCNArrayTableModel;
import com.jstatcom.table.JSCPopupTypes;
import com.jstatcom.table.NumberDisplayTable;
import com.jstatcom.util.UString;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JSCNArrayTable
extends JSCAbstractDataTable
implements NumberDisplayTable {
    private int precision = 2;
    private boolean isModalDialogShowing = false;
    private NumberRange numberRange = new NumberRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, NumberRangeTypes.OPEN);
    private final JTextField textField = new JTextField(){

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                if (JSCNArrayTable.this.isEditing()) {
                    JSCNArrayTable.this.getCellEditor().cancelCellEditing();
                }
                e.consume();
            }
            super.processKeyEvent(e);
        }
    };
    private TableCellEditor doubleEditor = new DefaultCellEditor(this.textField){
        private Double lastValue;
        {
            this.lastValue = null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.lastValue = (Double)value;
            JSCNArrayTable.this.textField.setHorizontalAlignment(4);
            String text = value + "";
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component comp = renderer.getTableCellRendererComponent(JSCNArrayTable.this, value, isSelected, true, row, column);
            if (comp instanceof JLabel) {
                text = ((JLabel)comp).getText();
            }
            if (UString.parseToNumber(text) != null) {
                JSCNArrayTable.this.textField.setText(text);
            } else {
                JSCNArrayTable.this.textField.setText(this.lastValue + "");
            }
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            String error;
            String text = ((String)super.getCellEditorValue()).trim();
            Double val = UString.parseToNumber(text);
            if (val == null) {
                String error2 = "Input \"" + text + "\" is not a valid number.";
                error2 = error2 + "\nThe previous value {" + this.lastValue + "} is restored.";
                JSCNArrayTable.this.editorComp.setBackground(CompSettings.errorBackground);
                JSCNArrayTable.this.isModalDialogShowing = true;
                StdMessages.errorInput(error2);
                JSCNArrayTable.this.isModalDialogShowing = false;
                JSCNArrayTable.this.editorComp.setBackground(Color.white);
                return this.lastValue;
            }
            if (JSCNArrayTable.this.numberRange != null && (error = JSCNArrayTable.this.numberRange.encloses(val)) != null) {
                JSCNArrayTable.this.editorComp.setBackground(CompSettings.errorBackground);
                JSCNArrayTable.this.isModalDialogShowing = true;
                StdMessages.errorInput(error + "\nThe previous value {" + this.lastValue + "} is restored.");
                JSCNArrayTable.this.isModalDialogShowing = false;
                JSCNArrayTable.this.editorComp.setBackground(Color.white);
                return this.lastValue;
            }
            return val;
        }
    };

    public JSCNArrayTable() {
        this.textField.setBorder(new LineBorder(Color.blue));
        this.setTablePopup(JSCPopupTypes.PRECISION);
        this.setDefaultEditor(Double.class, this.doubleEditor);
        this.setCellRenderer(JSCCellRendererTypes.DEFAULT);
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                if (JSCNArrayTable.this.isModalDialogShowing) {
                    return;
                }
                JSCNArrayTable.this.doubleEditor.stopCellEditing();
            }
        });
    }

    @Override
    public void setModelForJSCData(JSCData data) {
        if (data == null) {
            JSCNArrayTableModel model = new JSCNArrayTableModel(null);
            model.setEditable(this.isEditable());
            this.setModel(model);
        } else {
            JSCNArrayTableModel model = new JSCNArrayTableModel(new Symbol(data));
            model.setEditable(this.isEditable());
            this.setModel(model);
        }
    }

    @Override
    public void setModelForSymbolName(SymbolTable table, String name) {
        if (name == null || table == null) {
            JSCNArrayTableModel model = new JSCNArrayTableModel(null);
            model.setEditable(this.isEditable());
            this.setModel(model);
        } else {
            JSCNArrayTableModel model = new JSCNArrayTableModel(table.get(new JSCTypeDef(name, JSCTypes.NARRAY)));
            model.setEditable(this.isEditable());
            this.setModel(model);
        }
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new JSCNArrayTableModel(null);
    }

    public NumberRange getNumberRange() {
        return this.numberRange;
    }

    public void setNumberRange(NumberRange range) {
        this.numberRange = range;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(int precision) {
        this.precision = precision;
        this.updateUI();
    }

    public JSCNArray getJSCNArray() {
        return (JSCNArray)this.getJSCData();
    }
}

