/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.border.AbstractBorder;

public class BorderTableBorder
extends AbstractBorder {
    private int topInset = 1;
    private int leftInset = 1;
    private int bottomInset = 0;
    private int rightInset = 0;

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.topInset, this.leftInset, this.bottomInset, this.rightInset);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = this.leftInset;
        insets.top = this.topInset;
        insets.right = this.rightInset;
        insets.bottom = this.bottomInset;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        Color newColor = Color.gray;
        boolean hL = true;
        boolean vL = true;
        if (c instanceof JTable) {
            JTable table = (JTable)c;
            newColor = table.getGridColor();
            hL = table.getShowHorizontalLines();
            vL = table.getShowVerticalLines();
        }
        g.setColor(newColor);
        if (hL) {
            g.drawLine(x, y, x + width - 1, y);
        }
        if (vL) {
            g.drawLine(x, y, x, y + height - 1);
        }
        g.setColor(oldColor);
    }
}

