/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.project.OutputData;
import com.jstatcom.project.OutputList;
import com.jstatcom.project.OutputPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public final class OutputFrame
extends JFrame {
    private static final Logger log = Logger.getLogger(OutputFrame.class);
    private JSplitPane jSplitPane = null;
    private OutputList outputList = null;
    private OutputPanel outputPanel = null;
    private final List<Integer> actualSelection = new ArrayList<Integer>();
    private boolean doNotSetOutput = false;
    private JScrollPane jScrollPane = null;
    private JPanel jPanel = null;
    private JToolBar jToolBar = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private JToggleButton jToggleButton = null;
    private JToggleButton jToggleButton1 = null;

    public OutputFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJPanel());
        this.setTitle("Output Control [History On]");
        this.setSize(600, 485);
        URL url = this.getClass().getResource("/images/outcontrol.gif");
        if (url != null) {
            this.setIconImage(new ImageIcon(url).getImage());
        }
        ButtonGroup sortGroup = new ButtonGroup();
        sortGroup.add(this.getJToggleButton());
        sortGroup.add(this.getJToggleButton1());
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setRightComponent(this.getOutputPanel());
            this.jSplitPane.setBorder(BorderFactory.createBevelBorder(1));
            this.jSplitPane.setLeftComponent(this.getJScrollPane());
        }
        return this.jSplitPane;
    }

    private void saveSelectionOrderToVector() {
        Integer intI;
        int i;
        int end;
        OutputList list = this.getOutputList();
        if (list.getSelectedIndex() < 0) {
            this.actualSelection.clear();
            return;
        }
        int start = 0;
        if (this.actualSelection.size() == 0) {
            this.actualSelection.add(new Integer(list.getLeadSelectionIndex()));
        }
        if (this.actualSelection.size() > 0) {
            start = this.actualSelection.get(this.actualSelection.size() - 1);
        }
        if ((end = list.getLeadSelectionIndex()) - start > 0) {
            for (i = start + 1; i <= end; ++i) {
                intI = new Integer(i);
                if (!list.isSelectedIndex(i) || this.actualSelection.contains(intI)) continue;
                this.actualSelection.add(intI);
            }
        }
        if (end - start < 0) {
            for (i = start - 1; i >= end; --i) {
                intI = new Integer(i);
                if (!list.isSelectedIndex(i) || this.actualSelection.contains(intI)) continue;
                this.actualSelection.add(intI);
            }
        }
        for (i = 0; i < this.actualSelection.size(); ++i) {
            if (list.isSelectedIndex(this.actualSelection.get(i))) continue;
            this.actualSelection.remove(i);
            --i;
        }
    }

    private OutputList getOutputList() {
        if (this.outputList == null) {
            this.outputList = OutputList.getInstance();
            this.outputList.setParent(this);
            this.outputList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    if (OutputFrame.this.doNotSetOutput) {
                        return;
                    }
                    OutputFrame.this.saveSelectionOrderToVector();
                    OutputData[] dataArray = new OutputData[OutputFrame.this.actualSelection.size()];
                    for (int i = 0; i < OutputFrame.this.actualSelection.size(); ++i) {
                        Integer element = (Integer)OutputFrame.this.actualSelection.get(i);
                        Object o = OutputFrame.this.getOutputList().getModel().getElementAt(element);
                        if (!(o instanceof OutputData)) continue;
                        dataArray[i] = (OutputData)o;
                    }
                    OutputFrame.this.getOutputPanel().setOutput(dataArray);
                }
            });
        }
        return this.outputList;
    }

    private OutputPanel getOutputPanel() {
        if (this.outputPanel == null) {
            this.outputPanel = new OutputPanel();
        }
        return this.outputPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getOutputList());
        }
        return this.jScrollPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJToolBar(), "North");
            this.jPanel.add((Component)this.getJSplitPane(), "Center");
        }
        return this.jPanel;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setPreferredSize(new Dimension(18, 25));
            this.jToolBar.setFloatable(false);
            this.jToolBar.add(this.getJButton());
            this.jToolBar.add(this.getJButton1());
            this.jToolBar.add(this.getJToggleButton());
            this.jToolBar.add(this.getJToggleButton1());
        }
        return this.jToolBar;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Clear Selected");
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JOptionPane.showConfirmDialog(OutputFrame.this, "Remove selected output elements?", "Clear Selected", 0, 3) == 1) {
                        return;
                    }
                    OutputFrame.this.getOutputList().removeSelected();
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText("Clear All");
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JOptionPane.showConfirmDialog(OutputFrame.this, "Remove all output elements?", "Clear All", 0, 3) == 1) {
                        return;
                    }
                    OutputFrame.this.getOutputList().removeAll();
                }
            });
        }
        return this.jButton1;
    }

    private JToggleButton getJToggleButton() {
        if (this.jToggleButton == null) {
            this.jToggleButton = new JToggleButton();
            this.jToggleButton.setText("Sort By Time");
            this.jToggleButton.setSelected(true);
            this.jToggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputFrame.this.doNotSetOutput = true;
                    try {
                        OutputFrame.this.getOutputList().sortByTime();
                    }
                    catch (Throwable ex) {
                        log.error((Object)"Sort by time failed", ex);
                    }
                    finally {
                        OutputFrame.this.doNotSetOutput = false;
                    }
                }
            });
        }
        return this.jToggleButton;
    }

    private JToggleButton getJToggleButton1() {
        if (this.jToggleButton1 == null) {
            this.jToggleButton1 = new JToggleButton();
            this.jToggleButton1.setText("Sort By Name");
            this.jToggleButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputFrame.this.doNotSetOutput = true;
                    try {
                        OutputFrame.this.getOutputList().sortByName();
                    }
                    catch (Throwable ex) {
                        log.error((Object)"Sort by name failed", ex);
                    }
                    finally {
                        OutputFrame.this.doNotSetOutput = false;
                    }
                }
            });
        }
        return this.jToggleButton1;
    }
}

