/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.parser;

import com.jstatcom.util.UMatrix;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public abstract class CalcFunctions {
    private final String name;
    private static final Map<Object, CalcFunctions> functionMap = new HashMap<Object, CalcFunctions>();
    public static final CalcFunctions FRACDIFF = new CalcFunctions("FRACDIFF"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 2) {
                throw new IllegalArgumentException("Wrong number of arguments to fracdiff(a, d).");
            }
            double[] dd = argStack.pop();
            if (dd.length != 1) {
                throw new IllegalArgumentException("fracdiff(a, d) only takes scalar as 2nd argument.");
            }
            double[] aa = argStack.pop();
            double[] result = UMatrix.fracdiff(aa, dd[0]);
            argStack.push(result);
        }
    };
    public static final CalcFunctions SIN = new CalcFunctions("SIN"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to sin(a).");
            }
            double[] aa = argStack.pop();
            double[] result = new double[aa.length];
            for (int i = 0; i < aa.length; ++i) {
                result[i] = Math.sin(aa[i]);
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions COS = new CalcFunctions("COS"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to cos(a).");
            }
            double[] aa = argStack.pop();
            double[] result = new double[aa.length];
            for (int i = 0; i < aa.length; ++i) {
                result[i] = Math.cos(aa[i]);
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions TAN = new CalcFunctions("TAN"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to tan(a).");
            }
            double[] aa = argStack.pop();
            double[] result = new double[aa.length];
            for (int i = 0; i < aa.length; ++i) {
                result[i] = Math.tan(aa[i]);
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions SQRT = new CalcFunctions("SQRT"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to sqrt(a).");
            }
            double[] aa = argStack.pop();
            double[] result = new double[aa.length];
            for (int i = 0; i < aa.length; ++i) {
                result[i] = Math.sqrt(aa[i]);
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions LOG = new CalcFunctions("LOG"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to log(a).");
            }
            double[] aa = argStack.pop();
            double[] result = new double[aa.length];
            for (int i = 0; i < aa.length; ++i) {
                if (aa[i] <= 0.0) {
                    throw new IllegalArgumentException("Element at index " + (i + 1) + " <= 0 for log(a).");
                }
                result[i] = Math.log(aa[i]);
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions LAGN = new CalcFunctions("LAGN"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 2) {
                throw new IllegalArgumentException("Wrong number of arguments to lagn(a,b).");
            }
            double[] bb = argStack.pop();
            double[] aa = argStack.pop();
            if (bb.length != 1) {
                throw new IllegalArgumentException("lagn(a,b) only takes scalar as 2nd argument.");
            }
            int lag = new Double(bb[0]).intValue();
            double[] result = new double[aa.length];
            for (int i = 0; i < aa.length; ++i) {
                result[i] = i - lag < 0 || i - lag > aa.length - 1 ? Double.NaN : aa[i - lag];
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions ROWS = new CalcFunctions("ROWS"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to rows(a).");
            }
            double[] aa = argStack.pop();
            double[] result = new double[]{aa.length};
            argStack.push(result);
        }
    };
    public static final CalcFunctions ONES = new CalcFunctions("ONES"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to ones(a).");
            }
            double[] aa = argStack.pop();
            if (aa.length != 1 || aa[0] < 1.0) {
                throw new IllegalArgumentException("ones(a) takes only scalar >=1 as argument.");
            }
            int length = new Double(aa[0]).intValue();
            double[] result = new double[length];
            for (int i = 0; i < length; ++i) {
                result[i] = 1.0;
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions TREND = new CalcFunctions("TREND"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to trend(a).");
            }
            double[] aa = argStack.pop();
            if (aa.length != 1 || aa[0] < 1.0) {
                throw new IllegalArgumentException("trend(a) takes only scalar >=1 as argument.");
            }
            int length = new Double(aa[0]).intValue();
            double[] result = new double[length];
            for (int i = 0; i < length; ++i) {
                result[i] = i + 1;
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions RNDN = new CalcFunctions("RNDN"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to rndn(a).");
            }
            double[] aa = argStack.pop();
            if (aa.length != 1 || aa[0] < 1.0) {
                throw new IllegalArgumentException("rndn(a) takes only scalar >=1 as argument.");
            }
            int length = new Double(aa[0]).intValue();
            double[] result = new double[length];
            for (int i = 0; i < length; ++i) {
                result[i] = Math.random();
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions SUMC = new CalcFunctions("SUMC"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to sumc(a).");
            }
            double[] aa = argStack.pop();
            double[] result = new double[1];
            for (int i = 0; i < aa.length; ++i) {
                result[0] = result[0] + aa[i];
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions MEANC = new CalcFunctions("MEANC"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to meanc(a).");
            }
            double[] aa = argStack.pop();
            double[] result = new double[1];
            for (int i = 0; i < aa.length; ++i) {
                result[0] = result[0] + aa[i];
            }
            result[0] = result[0] / (double)aa.length;
            argStack.push(result);
        }
    };
    public static final CalcFunctions STDC = new CalcFunctions("STDC"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to stdc(a).");
            }
            double[] aa = argStack.pop();
            double mean = 0.0;
            for (int i = 0; i < aa.length; ++i) {
                mean += aa[i];
            }
            mean /= (double)aa.length;
            double[] result = new double[1];
            for (int i = 0; i < aa.length; ++i) {
                result[0] = result[0] + Math.pow(aa[i] - mean, 2.0);
            }
            result[0] = Math.sqrt(result[0] / (double)aa.length);
            argStack.push(result);
        }
    };
    public static final CalcFunctions STAND = new CalcFunctions("STAND"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to stand(a).");
            }
            double[] aa = argStack.pop();
            double mean = 0.0;
            for (int i = 0; i < aa.length; ++i) {
                mean += aa[i];
            }
            mean /= (double)aa.length;
            double std = 0.0;
            for (int i = 0; i < aa.length; ++i) {
                std += Math.pow(aa[i] - mean, 2.0);
            }
            std = Math.sqrt(std / (double)aa.length);
            double[] result = new double[aa.length];
            for (int i = 0; i < aa.length; ++i) {
                result[i] = (aa[i] - mean) / std;
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions REVERSE = new CalcFunctions("REVERSE"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 1) {
                throw new IllegalArgumentException("Wrong number of arguments to reverse(a).");
            }
            double[] aa = argStack.pop();
            double[] result = new double[aa.length];
            for (int i = 0; i < aa.length; ++i) {
                result[i] = aa[aa.length - 1 - i];
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions MIN = new CalcFunctions("MIN"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 2) {
                throw new IllegalArgumentException("Wrong number of arguments to min(a,b).");
            }
            double[] bb = argStack.pop();
            double[] aa = argStack.pop();
            double[] result = new double[17.getLength(aa, bb)];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Math.min(aa.length == 1 ? aa[0] : aa[i], bb.length == 1 ? bb[0] : bb[i]);
            }
            argStack.push(result);
        }
    };
    public static final CalcFunctions MAX = new CalcFunctions("MAX"){

        @Override
        public void execute(int argNum, Stack<double[]> argStack) {
            if (argNum != 2) {
                throw new IllegalArgumentException("Wrong number of arguments to max(a,b).");
            }
            double[] bb = argStack.pop();
            double[] aa = argStack.pop();
            double[] result = new double[18.getLength(aa, bb)];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Math.max(aa.length == 1 ? aa[0] : aa[i], bb.length == 1 ? bb[0] : bb[i]);
            }
            argStack.push(result);
        }
    };

    protected CalcFunctions(String newName) {
        this.name = newName.toLowerCase();
        functionMap.put(this.name, this);
    }

    public static void callFunctionForName(String functionName, int argNum, Stack<double[]> argStack) throws IllegalArgumentException {
        if (functionName == null) {
            throw new IllegalArgumentException("Function name is null.");
        }
        String key = functionName.toLowerCase();
        if (!functionMap.containsKey(key)) {
            throw new IllegalArgumentException("Function \"" + functionName + "\" is not defined.");
        }
        functionMap.get(key).execute(argNum, argStack);
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public abstract void execute(int var1, Stack<double[]> var2);

    public static int getLength(double[] aa, double[] bb) throws IllegalArgumentException {
        if (aa.length == bb.length) {
            return aa.length;
        }
        if (aa.length == 1 && bb.length > 1) {
            return bb.length;
        }
        if (bb.length == 1 && aa.length > 1) {
            return aa.length;
        }
        throw new IllegalArgumentException("Array dimensions do not fit.");
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final String toString() {
        return this.name;
    }
}

