/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model.control;

import com.jstatcom.component.StdMessages;
import com.jstatcom.io.DataHandlerTypes;
import com.jstatcom.io.FileSupport;
import com.jstatcom.io.TSASCIIHandler;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.control.SymbolPanel;
import com.jstatcom.table.JSCDataTableScrollPane;
import com.jstatcom.table.JSCSArrayTable;
import com.jstatcom.table.JSCSArrayTableModel;
import com.jstatcom.util.UMatrix;
import com.jstatcom.util.UStringArray;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public final class JSCSArrayPanel
extends SymbolPanel {
    private static final Logger log = Logger.getLogger(JSCSArrayPanel.class);
    private JFrame top = null;
    private Symbol currentSymbol = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JButton jButton = null;
    private JSCDataTableScrollPane JSCDataTableScrollPane = null;
    private JSCSArrayTable JSCSArrayTable = null;

    public JSCSArrayPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints consGridBagConstraints11 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints12 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints10 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints13 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints15 = new GridBagConstraints();
        consGridBagConstraints2.fill = 1;
        consGridBagConstraints2.weighty = 1.0;
        consGridBagConstraints2.weightx = 1.0;
        consGridBagConstraints2.gridy = 4;
        consGridBagConstraints2.gridx = 0;
        consGridBagConstraints2.gridwidth = 3;
        consGridBagConstraints13.gridy = 3;
        consGridBagConstraints13.gridx = 1;
        consGridBagConstraints13.fill = 2;
        consGridBagConstraints13.insets = new Insets(2, 0, 5, 0);
        consGridBagConstraints12.gridy = 1;
        consGridBagConstraints12.gridx = 1;
        consGridBagConstraints12.fill = 2;
        consGridBagConstraints15.gridy = 1;
        consGridBagConstraints15.gridx = 2;
        consGridBagConstraints15.gridheight = 3;
        consGridBagConstraints15.weightx = 0.0;
        consGridBagConstraints11.gridy = 3;
        consGridBagConstraints11.gridx = 0;
        consGridBagConstraints11.fill = 2;
        consGridBagConstraints10.gridy = 1;
        consGridBagConstraints10.gridx = 0;
        consGridBagConstraints10.fill = 2;
        consGridBagConstraints10.insets = new Insets(0, 5, 0, 0);
        consGridBagConstraints11.insets = new Insets(2, 5, 5, 0);
        consGridBagConstraints12.insets = new Insets(0, 0, 0, 0);
        consGridBagConstraints15.insets = new Insets(0, 20, 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJLabel(), consGridBagConstraints10);
        this.add((Component)this.getJLabel1(), consGridBagConstraints11);
        this.add((Component)this.getRowsLabel(), consGridBagConstraints12);
        this.add((Component)this.getColsLabel(), consGridBagConstraints13);
        this.add((Component)this.getJSCDataTableScrollPane(), consGridBagConstraints2);
        this.setSize(500, 302);
        this.setBorder(new TitledBorder(new BevelBorder(1), "Value of " + JSCTypes.SARRAY + "", 3, 2));
        consGridBagConstraints15.anchor = 17;
        this.add((Component)this.getSaveButton(), consGridBagConstraints15);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (symbol.type != JSCTypes.SARRAY) {
            throw new IllegalArgumentException("Invalid type " + symbol.type + " for " + JSCTypes.SARRAY + " panel.");
        }
        JSCSArray sArray = symbol.getJSCSArray();
        this.getRowsLabel().setText(sArray.rows() + "");
        this.getColsLabel().setText(sArray.cols() + "");
        this.getJSCSArrayTable().setModel(new JSCSArrayTableModel(symbol));
        String[] colHeader = UStringArray.createNamedIndex("", UMatrix.seqa(1.0, 1.0, sArray.cols()));
        String[] rowHeader = UStringArray.createNamedIndex("", UMatrix.seqa(1.0, 1.0, sArray.rows()));
        this.getJSCDataTableScrollPane().setColumnHeaderData(new JSCSArray("colHeader", colHeader));
        this.getJSCDataTableScrollPane().setRowHeaderData(new JSCSArray("rowHeader", rowHeader));
        this.currentSymbol = symbol;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Rows");
            this.jLabel.setPreferredSize(new Dimension(38, 20));
        }
        return this.jLabel;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Cols");
            this.jLabel1.setPreferredSize(new Dimension(40, 20));
            this.jLabel1.setMinimumSize(new Dimension(40, 16));
        }
        return this.jLabel1;
    }

    private JLabel getRowsLabel() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("");
            this.jLabel2.setPreferredSize(new Dimension(38, 20));
        }
        return this.jLabel2;
    }

    private JLabel getColsLabel() {
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("");
            this.jLabel3.setPreferredSize(new Dimension(50, 20));
            this.jLabel3.setMinimumSize(new Dimension(50, 20));
        }
        return this.jLabel3;
    }

    private Symbol getCurrentSymbol() {
        return this.currentSymbol;
    }

    private void saveSymbolToFile(Symbol symbol) {
        if (symbol == null || symbol.isEmpty()) {
            StdMessages.infoGeneral("Symbol is empty. There is nothing to save.", this.top);
        } else {
            File saveFile = FileSupport.getInstance().saveDataFile(this.top, symbol.name, DataHandlerTypes.DAT);
            if (saveFile == null) {
                return;
            }
            JSCSArray data = symbol.getJSCSArray();
            String header = "/* name = " + symbol.NAME + ", type = SARRAY" + ", rows = " + data.rows() + ", cols = " + data.cols() + " */\r\n";
            String des = symbol.getDescription();
            if (des != null && des.length() > 0) {
                header = header + "/* " + des + " */\r\n";
            }
            try {
                TSASCIIHandler.getInstance().exportData(saveFile, data, header);
            }
            catch (Throwable t) {
                String msg = "Error writing symbol \"" + symbol.NAME + "\" to file\n\"" + saveFile.getAbsolutePath() + "\".";
                String message = msg + "\n\n" + t.getMessage();
                StdMessages.error(message, "Data Export Error");
                log.error((Object)msg, t);
            }
        }
    }

    private JButton getSaveButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Save");
            this.jButton.setPreferredSize(new Dimension(100, 25));
            this.jButton.setMinimumSize(new Dimension(100, 25));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JSCSArrayPanel.this.saveSymbolToFile(JSCSArrayPanel.this.getCurrentSymbol());
                }
            });
        }
        return this.jButton;
    }

    private JSCDataTableScrollPane getJSCDataTableScrollPane() {
        if (this.JSCDataTableScrollPane == null) {
            this.JSCDataTableScrollPane = new JSCDataTableScrollPane();
            this.JSCDataTableScrollPane.setViewportView(this.getJSCSArrayTable());
            this.JSCDataTableScrollPane.setColumnHeaderShowing(true);
            this.JSCDataTableScrollPane.setRowHeaderShowing(true);
        }
        return this.JSCDataTableScrollPane;
    }

    private JSCSArrayTable getJSCSArrayTable() {
        if (this.JSCSArrayTable == null) {
            this.JSCSArrayTable = new JSCSArrayTable();
            this.JSCSArrayTable.setRowSelectionAllowed(true);
        }
        return this.JSCSArrayTable;
    }

    @Override
    public void setSymbolEditable(boolean editable) {
        this.getJSCSArrayTable().setEditable(editable);
    }
}

