/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.component.CompSettings;
import com.jstatcom.model.SymbolEvent;
import com.jstatcom.model.SymbolEventTypes;
import com.jstatcom.model.SymbolListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class SymbolEventSupport {
    private static final Logger log = Logger.getLogger(SymbolEventSupport.class);
    private Map<SymbolEventTypes, List<SymbolListener>> typeMap = null;

    public void addListener(SymbolListener evtListener, SymbolEventTypes evtType) {
        if (evtListener == null || evtType == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.typeMap == null) {
            this.typeMap = new HashMap<SymbolEventTypes, List<SymbolListener>>();
        }
        List<Object> toPut = null;
        if (!this.typeMap.containsKey(evtType)) {
            toPut = new ArrayList();
            this.typeMap.put(evtType, toPut);
        } else {
            toPut = this.typeMap.get(evtType);
        }
        if (!toPut.contains(evtListener)) {
            toPut.add(evtListener);
        }
    }

    public void dispatchEvent(final SymbolEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.typeMap == null || this.typeMap.size() == 0) {
            return;
        }
        if (!this.typeMap.containsKey(evt.getType())) {
            return;
        }
        final List<SymbolListener> currentList = this.typeMap.get(evt.getType());
        if (currentList.size() == 0) {
            return;
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < currentList.size(); ++i) {
                    try {
                        ((SymbolListener)currentList.get(i)).valueChanged(evt);
                        continue;
                    }
                    catch (Throwable ex) {
                        log.error((Object)("Error in value changed of " + currentList.get(i)), ex);
                    }
                }
            }
        };
        CompSettings.dispatchEvent(runner);
    }

    public List<SymbolListener> getListenersForType(SymbolEventTypes evtType) {
        if (!this.typeMap.containsKey(evtType)) {
            return new ArrayList<SymbolListener>();
        }
        List<SymbolListener> list = this.typeMap.get(evtType);
        return new ArrayList<SymbolListener>(list);
    }

    public void removeListener(SymbolListener evtListener) {
        if (evtListener == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.typeMap == null || this.typeMap.size() == 0) {
            return;
        }
        Collection<List<SymbolListener>> lists = this.typeMap.values();
        for (ArrayList arrayList : lists) {
            arrayList.remove(evtListener);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer(super.toString() + "\n");
        if (this.typeMap == null || this.typeMap.size() == 0) {
            str.append("no listeners registered\n");
        } else {
            Collection<List<SymbolListener>> lists = this.typeMap.values();
            Set<SymbolEventTypes> keys = this.typeMap.keySet();
            Iterator<List<SymbolListener>> it = lists.iterator();
            Iterator kit = keys.iterator();
            while (it.hasNext()) {
                str.append(kit.next() + " " + it.next() + "\n");
            }
        }
        return str.toString();
    }
}

