/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.component.Card;
import com.jstatcom.component.JHelpContextMgr;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolScope;
import com.jstatcom.model.SymbolTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.JPanel;

public class ModelPanel
extends JPanel
implements SymbolScope,
Card {
    private SymbolTable localSymbolTable = null;
    private SymbolTable preGlobalSymbolTable = null;
    private SymbolTable preUpperSymbolTable = null;
    private SymbolScope parentScope = null;
    private static final SymbolTable preParentTable = new SymbolTable("_TMP", null, true);

    public ModelPanel() {
        this(null);
    }

    public ModelPanel(LayoutManager layout) {
        super(layout);
        JHelpContextMgr.register(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.parentScope == null) {
            this.parentScope = ModelPanel.findParentScope(this);
        }
        if (this.parentScope == null) {
            this.parentScope = this;
        }
        if (this.preGlobalSymbolTable != null) {
            this.global();
            this.updateUpperAfterNotify();
        }
        if (this.preUpperSymbolTable != null) {
            this.upper();
            this.updateUpperAfterNotify();
        }
    }

    @Override
    public SymbolTable upper() {
        if (this.parentScope == this) {
            return this.local();
        }
        if (this.parentScope == null) {
            this.parentScope = ModelPanel.findParentScope(this);
        }
        if (this.parentScope != null) {
            SymbolTable sTable = this.parentScope.local();
            if (sTable == null) {
                throw new RuntimeException("Acquired symbol table was null.");
            }
            if (this.preUpperSymbolTable != null) {
                Iterator iter = this.preUpperSymbolTable.iterator();
                while (iter.hasNext()) {
                    Symbol element = (Symbol)iter.next();
                    sTable.setSymbol(element);
                }
                if (this.localSymbolTable != null) {
                    this.moveLocalSymbolTable(sTable);
                }
                this.preUpperSymbolTable.clear();
                this.preUpperSymbolTable = null;
            }
            return sTable;
        }
        if (this.preUpperSymbolTable == null) {
            this.preUpperSymbolTable = new SymbolTable(this.getClass().getName() + "_preUpper", preParentTable, true);
        }
        return this.preUpperSymbolTable;
    }

    private void moveLocalSymbolTable(SymbolTable sTable) {
        String name = this.getName();
        if (name == null || name.length() < 1) {
            name = this.getClass().getName();
        }
        SymbolTable newLocalSymbolTable = new SymbolTable(name, sTable);
        Iterator iter = this.localSymbolTable.iterator();
        while (iter.hasNext()) {
            Symbol element = (Symbol)iter.next();
            newLocalSymbolTable.setSymbol(element);
        }
        this.localSymbolTable.clear();
        this.localSymbolTable = newLocalSymbolTable;
    }

    @Override
    public SymbolTable global() {
        if (this.parentScope == this) {
            return this.local();
        }
        if (this.parentScope == null) {
            this.parentScope = ModelPanel.findParentScope(this);
        }
        if (this.parentScope != null) {
            SymbolTable sTable = this.parentScope.global();
            if (sTable == null) {
                throw new RuntimeException("Acquired symbol table was null.");
            }
            if (this.preGlobalSymbolTable != null) {
                Iterator iter = this.preGlobalSymbolTable.iterator();
                while (iter.hasNext()) {
                    Symbol element = (Symbol)iter.next();
                    sTable.setSymbol(element);
                }
                this.preGlobalSymbolTable.clear();
                this.preGlobalSymbolTable = null;
            }
            return sTable;
        }
        if (this.preGlobalSymbolTable == null) {
            this.preGlobalSymbolTable = new SymbolTable(this.getClass().getName() + "_preGlobal", preParentTable, true);
        }
        return this.preGlobalSymbolTable;
    }

    @Override
    public SymbolTable local() {
        if (this.localSymbolTable == null) {
            String name = this.getName();
            if (name == null || name.length() < 1) {
                name = this.getClass().getName();
            }
            this.localSymbolTable = this.parentScope == this ? new SymbolTable(name, null) : new SymbolTable(name, this.upper());
        }
        return this.localSymbolTable;
    }

    @Override
    public void shown(boolean isShown) {
    }

    public static SymbolScope findParentScope(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        SymbolScope symbolScope = null;
        for (comp = comp.getParent(); comp != null && symbolScope == null; comp = comp.getParent()) {
            if (!(comp instanceof SymbolScope)) continue;
            symbolScope = (SymbolScope)((Object)comp);
            break;
        }
        return symbolScope;
    }

    protected void updateUpperAfterNotify() {
        SymbolTable upper = this.upper();
        if (this.localSymbolTable != null && this.localSymbolTable.getParentTable() != upper) {
            this.moveLocalSymbolTable(upper);
        }
        this.walkContainer(this);
    }

    private void walkContainer(Container c) {
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component cc = c.getComponent(i);
            if (cc instanceof ModelPanel) {
                ((ModelPanel)cc).updateUpperAfterNotify();
                continue;
            }
            if (!(cc instanceof Container)) continue;
            this.walkContainer((Container)cc);
        }
    }
}

