/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.AbstractJSCData;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCTypes;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class JSCString
extends AbstractJSCData {
    private final String name;
    private String value = null;
    private JSCDataEvent clearEvent = null;
    private JSCDataEvent notEmptyEvent = null;
    public static final XmlFormat<JSCString> JSCString_XML = new XmlFormat<JSCString>(JSCString.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void format(JSCString data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            JSCString jSCString = data;
            synchronized (jSCString) {
                xml.setAttribute("value", data.value + "");
            }
        }

        @Override
        public JSCString parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            String valueString = xml.getAttribute("value") + "";
            String newString = null;
            if (!valueString.equalsIgnoreCase("null")) {
                newString = valueString;
            }
            return new JSCString(nam, newString);
        }
    };

    public JSCString(String name) {
        this(name, null);
    }

    public JSCString(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        String oldValue;
        JSCString jSCString = this;
        synchronized (jSCString) {
            if (this.value == null) {
                return;
            }
            oldValue = this.value;
            this.value = null;
        }
        if (this.clearEvent == null) {
            this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(this.clearEvent);
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, null));
    }

    @Override
    public synchronized JSCString copy() {
        return new JSCString(this.name, this.value);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.value == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isEqual(JSCData o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JSCString)) {
            return false;
        }
        JSCString otherString = (JSCString)o;
        boolean ret = true;
        JSCString jSCString = this;
        synchronized (jSCString) {
            JSCData jSCData = o;
            synchronized (jSCData) {
                ret = this.value != null ? this.value.equals(otherString.string()) : otherString.string() == null;
            }
        }
        return ret;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(String newValue) {
        if (newValue == null) {
            this.clear();
            return;
        }
        boolean wasEmpty = false;
        String oldValue = null;
        JSCString jSCString = this;
        synchronized (jSCString) {
            if (newValue.equals(this.value)) {
                return;
            }
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = newValue;
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newValue));
        if (wasEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
    }

    public synchronized String string() {
        return this.value;
    }

    @Override
    public JSCTypes type() {
        return JSCTypes.STRING;
    }

    @Override
    public synchronized Object value() {
        return this.value;
    }
}

