/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import Jama.Matrix;
import com.jstatcom.model.AbstractJSCData;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCDataEventTypes;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.util.FArg;
import com.jstatcom.util.UMatrix;
import com.jstatcom.util.UString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;
import org.apache.log4j.Logger;

public final class JSCNArray
extends AbstractJSCData {
    private static final Logger log = Logger.getLogger(JSCNArray.class);
    private String formatString = "%- 8.4f ";
    private final String name;
    private double[][] value = new double[0][0];
    private JSCDataEvent clearEvent = null;
    private JSCDataEvent notEmptyEvent = null;
    public static final XmlFormat<JSCNArray> JSCNArray_XML = new XmlFormat<JSCNArray>(JSCNArray.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void format(JSCNArray data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            JSCNArray jSCNArray = data;
            synchronized (jSCNArray) {
                try {
                    StringBuffer valBuffer = new StringBuffer();
                    valBuffer.append(data.rows() + " " + data.cols() + " ");
                    for (int i = 0; i < data.rows(); ++i) {
                        for (int j = 0; j < data.cols(); ++j) {
                            valBuffer.append(data.value[i][j] + " ");
                        }
                    }
                    xml.setAttribute("values", valBuffer.toString().trim());
                }
                catch (Throwable ex) {
                    log.error((Object)("Error in XML serialization of \"" + data.name + "\""), ex);
                }
            }
        }

        @Override
        public JSCNArray parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            String valString = xml.getAttribute("values") + "";
            String[] tokenizer = valString.split(" ");
            int rows = Integer.parseInt(tokenizer[0]);
            int cols = Integer.parseInt(tokenizer[1]);
            double[][] val = new double[rows][cols];
            int tokenCount = 2;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    val[i][j] = UString.parseToNumber(tokenizer[tokenCount++]);
                }
            }
            JSCNArray array = new JSCNArray(nam, val);
            return array;
        }
    };

    public JSCNArray(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        this.value = new double[0][0];
    }

    public JSCNArray(String name, double[][] value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        if (value != null && value.length > 0) {
            UMatrix.checkRowLengths(value);
        }
        this.value = UMatrix.cloneDoubleArray(value);
    }

    public JSCNArray(JSCNArray narray) {
        if (narray == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = narray.name();
        this.value = narray.doubleArray();
    }

    public JSCNArray(String name, double ... value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        this.value = UMatrix.toDoubleMatrix(value);
    }

    public JSCNArray(String name, int[] value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        this.value = UMatrix.toDoubleMatrix(value);
    }

    public JSCNArray(String name, int[][] value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        if (value != null && value.length > 0) {
            UMatrix.checkRowLengths(value);
        }
        this.value = UMatrix.toDoubleMatrix(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendCols(JSCNArray newCols) {
        if (newCols == null) {
            throw new IllegalArgumentException("Argument was null for " + this.toString() + ".");
        }
        if (newCols.isEmpty()) {
            return;
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        double[][] newVal = null;
        double[][] oldValue = null;
        double[][] toAppend = null;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            JSCNArray jSCNArray2 = newCols;
            synchronized (jSCNArray2) {
                if (newCols.isEmpty()) {
                    return;
                }
                int rows = this.rows();
                int otherRows = newCols.rows();
                if (rows > 0 && rows != otherRows) {
                    throw new IllegalArgumentException("Number of rows do not match between\n" + this.toString() + " and\n" + newCols.toString() + ".");
                }
                toAppend = newCols.doubleArray();
            }
            if (this.isEmpty()) {
                wasEmpty = true;
                oldValue = this.value;
                this.value = toAppend;
                isEmpty = this.isEmpty();
                if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                    newVal = UMatrix.cloneDoubleArray(toAppend);
                }
            } else {
                wasEmpty = false;
                oldValue = this.value;
                this.value = UMatrix.appendDoubleCols(this.value, toAppend);
                isEmpty = this.isEmpty();
                if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                    newVal = UMatrix.cloneDoubleArray(this.value);
                }
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendRows(JSCNArray newRows) {
        if (newRows == null) {
            throw new IllegalArgumentException("Argument was null for " + this.toString() + ".");
        }
        if (newRows.isEmpty()) {
            return;
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        double[][] newVal = null;
        double[][] oldValue = null;
        double[][] toAppend = null;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            JSCNArray jSCNArray2 = newRows;
            synchronized (jSCNArray2) {
                if (newRows.isEmpty()) {
                    return;
                }
                int cols = this.cols();
                int otherCols = newRows.cols();
                if (cols > 0 && cols != otherCols) {
                    throw new IllegalArgumentException("Number of cols do not match between\n" + this.toString() + " and\n" + newRows.toString() + ".");
                }
                toAppend = newRows.doubleArray();
            }
            if (this.isEmpty()) {
                wasEmpty = true;
                oldValue = this.value;
                this.value = toAppend;
                isEmpty = this.isEmpty();
                if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                    newVal = UMatrix.cloneDoubleArray(toAppend);
                }
            } else {
                wasEmpty = false;
                oldValue = this.value;
                this.value = UMatrix.appendDoubleRows(this.value, toAppend);
                isEmpty = this.isEmpty();
                if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                    newVal = UMatrix.cloneDoubleArray(this.value);
                }
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
    }

    private void checkIndices(int i, int j) {
        if (i >= this.rows() || j >= this.cols() || i < 0 || j < 0) {
            throw new IllegalArgumentException("[" + i + "," + j + "] is not a valid index for " + this.toString() + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        double[][] oldValue;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            if (this.isEmpty()) {
                return;
            }
            oldValue = this.value;
            this.value = new double[0][0];
        }
        if (this.clearEvent == null) {
            this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(this.clearEvent);
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, new double[0][0]));
    }

    public synchronized int cols() {
        if (this.value == null || this.value.length == 0) {
            return 0;
        }
        return this.value[0].length;
    }

    @Override
    public synchronized JSCNArray copy() {
        return new JSCNArray(this.name, this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delCol(int i) {
        double[][] oldValue = null;
        boolean isEmpty = false;
        double[][] newVal = null;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            if (this.isEmpty()) {
                throw new IllegalStateException("Cannot delete column " + i + " from empty object " + this.toString() + ".");
            }
            if (i < 0 || this.cols() <= i) {
                throw new IllegalArgumentException("Bad column index " + i + " for " + this.toString() + ".");
            }
            oldValue = this.value;
            this.value = UMatrix.delCol(this.value, i);
            isEmpty = this.isEmpty();
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                newVal = UMatrix.cloneDoubleArray(this.value);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delColsIf(int ... index) {
        double[][] oldValue = null;
        boolean isEmpty = false;
        double[][] newVal = null;
        boolean changed = UMatrix.getNonzeroIntCount(index) > 0;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            if (this.isEmpty()) {
                throw new IllegalStateException("Cannot delete columns from empty object " + this.toString() + ".");
            }
            if (index.length != this.cols()) {
                throw new IllegalArgumentException("Bad column selection index (" + index.length + "x" + "1) for " + this.toString() + ".");
            }
            oldValue = this.value;
            this.value = UMatrix.delColsIf(this.value, index);
            isEmpty = this.isEmpty();
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && changed) {
                newVal = UMatrix.cloneDoubleArray(this.value);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && changed) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delRow(int i) {
        double[][] oldValue = null;
        boolean isEmpty = false;
        double[][] newVal = null;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            if (this.isEmpty()) {
                throw new IllegalStateException("Cannot delete row " + i + " from empty object " + this.toString() + ".");
            }
            if (i < 0 || this.rows() <= i) {
                throw new IllegalArgumentException("Bad row index " + i + " for " + this.toString() + ".");
            }
            oldValue = this.value;
            this.value = UMatrix.delRow(this.value, i);
            isEmpty = this.isEmpty();
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                newVal = UMatrix.cloneDoubleArray(this.value);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delRowsIf(int ... index) {
        double[][] oldValue = null;
        boolean isEmpty = false;
        double[][] newVal = null;
        boolean changed = UMatrix.getNonzeroIntCount(index) > 0;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            if (this.isEmpty()) {
                throw new IllegalStateException("Cannot delete rows from empty object " + this.toString() + ".");
            }
            if (index.length != this.rows()) {
                throw new IllegalArgumentException("Bad row selection index (" + index.length + "x" + "1) for " + this.toString() + ".");
            }
            oldValue = this.value;
            this.value = UMatrix.delRowsIf(this.value, index);
            isEmpty = this.isEmpty();
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && changed) {
                newVal = UMatrix.cloneDoubleArray(this.value);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && changed) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    @Override
    public synchronized String display() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                buffer.append(FArg.sprintf(this.formatString, new FArg(this.value[i][j])));
            }
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    public synchronized double[][] doubleArray() {
        if (this.value == null) {
            return new double[0][0];
        }
        return UMatrix.cloneDoubleArray(this.value);
    }

    public synchronized double doubleAt(int i, int j) {
        this.checkIndices(i, j);
        return this.value[i][j];
    }

    public synchronized Double doubleValAt(int i, int j) {
        this.checkIndices(i, j);
        return new Double(this.value[i][j]);
    }

    public synchronized int[][] intArray() {
        return UMatrix.toIntMatrix(this.value);
    }

    public synchronized int intAt(int i, int j) {
        this.checkIndices(i, j);
        return (int)this.value[i][j];
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.value == null || this.value.length == 0 || this.value[0].length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEqual(JSCData o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JSCNArray)) {
            return false;
        }
        JSCNArray otherNArray = (JSCNArray)o;
        boolean ret = true;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            JSCData jSCData = o;
            synchronized (jSCData) {
                if (this.isEmpty() && otherNArray.isEmpty()) {
                    return true;
                }
                ret = UMatrix.compareDoubleArrays(this.value, otherNArray.doubleArray());
            }
        }
        return ret;
    }

    public synchronized boolean isNaN(int i, int j) {
        this.checkIndices(i, j);
        return Double.isNaN(this.value[i][j]);
    }

    public synchronized Matrix jamaMatrix() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot construct Jama.Matrix from empty data object " + this.toString() + ".");
        }
        return Matrix.constructWithCopy((double[][])this.value);
    }

    @Override
    public String name() {
        return this.name;
    }

    public synchronized int nanCount() {
        int count = 0;
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                count = this.isNaN(i, j) ? ++count : count;
            }
        }
        return count;
    }

    public synchronized int rank() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot compute rank for empty data object " + this.toString() + ".");
        }
        return new Matrix(this.value).rank();
    }

    public synchronized int rows() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    public void setFormatString(String newFormatString) {
        try {
            FArg.sprintf(newFormatString, new FArg(0.0));
        }
        catch (Throwable thr) {
            throw new IllegalArgumentException("\"" + newFormatString + "\" is not a valid format string.");
        }
        this.formatString = newFormatString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(double[][] newValue) {
        if (newValue == null) {
            this.clear();
            return;
        }
        if (newValue.length > 0) {
            UMatrix.checkRowLengths(newValue);
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        double[][] oldValue = null;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = UMatrix.cloneDoubleArray(newValue);
            isEmpty = this.isEmpty();
        }
        if (wasEmpty && isEmpty) {
            return;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && !UMatrix.compareDoubleArrays(oldValue, newValue)) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newValue));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
        if (!wasEmpty && isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(int[][] newValue) {
        double[][] toCompare;
        if (newValue == null) {
            this.clear();
            return;
        }
        if (newValue.length > 0) {
            UMatrix.checkRowLengths(newValue);
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        double[][] oldValue = null;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = UMatrix.toDoubleMatrix(newValue);
            isEmpty = this.isEmpty();
        }
        if (wasEmpty && isEmpty) {
            return;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && !UMatrix.compareDoubleArrays(oldValue, toCompare = UMatrix.toDoubleMatrix(newValue))) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, toCompare));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
        if (!wasEmpty && isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(double[] newValue) {
        double[][] toCompare;
        if (newValue == null) {
            this.clear();
            return;
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        double[][] oldValue = null;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = UMatrix.toDoubleMatrix(newValue);
            isEmpty = this.isEmpty();
        }
        if (wasEmpty && isEmpty) {
            return;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && !UMatrix.compareDoubleArrays(oldValue, toCompare = UMatrix.toDoubleMatrix(newValue))) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, toCompare));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
        if (!wasEmpty && isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(int[] newValue) {
        double[][] toCompare;
        if (newValue == null) {
            this.clear();
            return;
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        double[][] oldValue = null;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = UMatrix.toDoubleMatrix(newValue);
            isEmpty = this.isEmpty();
        }
        if (wasEmpty && isEmpty) {
            return;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && !UMatrix.compareDoubleArrays(oldValue, toCompare = UMatrix.toDoubleMatrix(newValue))) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, toCompare));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
        if (!wasEmpty && isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(JSCNArray val) {
        if (val == null) {
            throw new IllegalArgumentException("Argument was null for " + this.toString() + ".");
        }
        double[][] newValue = val.doubleArray();
        if (newValue == null) {
            this.clear();
            return;
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        double[][] valToCompare = null;
        double[][] oldValue = null;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = newValue;
            isEmpty = this.isEmpty();
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                valToCompare = UMatrix.cloneDoubleArray(newValue);
            }
        }
        if (wasEmpty && isEmpty) {
            return;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && !UMatrix.compareDoubleArrays(oldValue, valToCompare)) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, valToCompare));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
        if (!wasEmpty && isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    public void setVal(Matrix mat) {
        this.setVal(mat.getArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValAt(double val, int i, int j) {
        double oldVal;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            this.checkIndices(i, j);
            oldVal = this.value[i][j];
            this.value[i][j] = val;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (Double.doubleToLongBits(oldVal) != Double.doubleToLongBits(val)) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, new double[]{oldVal, i, j}, new double[]{val, i, j}));
        }
    }

    @Override
    public synchronized String toString() {
        String display = this.isEmpty() ? "{}" : this.value.length + "x" + this.value[0].length + ",[0,0]=" + this.value[0][0];
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + " [name=" + this.name + ",type=" + JSCTypes.NARRAY + ",value=" + display + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transpose() {
        double[][] valToCompare = null;
        double[][] oldValue = null;
        JSCNArray jSCNArray = this;
        synchronized (jSCNArray) {
            if (this.isEmpty()) {
                return;
            }
            double[][] newValue = new Matrix(this.value).transpose().getArray();
            oldValue = this.value;
            this.value = newValue;
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                valToCompare = UMatrix.cloneDoubleArray(newValue);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && !UMatrix.compareDoubleArrays(oldValue, valToCompare)) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, valToCompare));
        }
    }

    @Override
    public JSCTypes type() {
        return JSCTypes.NARRAY;
    }

    @Override
    public synchronized Object value() {
        if (this.value == null) {
            return new double[0][0];
        }
        return UMatrix.cloneDoubleArray(this.value);
    }

    public synchronized int zeroCount() {
        int count = 0;
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                count = this.value[i][j] == 0.0 ? ++count : count;
            }
        }
        return count;
    }

    public static JSCNArray valueOf(File file, String name) {
        if (file == null || name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        JSCConstants.checkNameThrowEx(name);
        if (!file.isFile()) {
            throw new IllegalArgumentException("File " + file + " does not exist.");
        }
        ArrayList<String> list = new ArrayList<String>();
        boolean inComment = false;
        try {
            String str = null;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                int index;
                str = str.replaceAll("#", "");
                str = str.replaceAll("/\\*", "#");
                str = str.replaceAll("\\*/", "#");
                if (!inComment) {
                    index = (str = str.replaceAll("#[^#]*#", "")).indexOf("#");
                    if (index > -1) {
                        inComment = true;
                        str = str.substring(0, index);
                    }
                } else {
                    index = str.indexOf("#");
                    if (index > -1) {
                        inComment = false;
                        str = str.substring(index + 1, str.length());
                        index = (str = str.replaceAll("#[^#]*#", "")).indexOf("#");
                        if (index > -1) {
                            inComment = true;
                            str = str.substring(0, index);
                        }
                    } else {
                        str = "";
                    }
                }
                if ((str = str.trim()).length() <= 0) continue;
                list.add(str);
            }
            in.close();
        }
        catch (IOException str) {
            // empty catch block
        }
        if (list.size() == 0) {
            return new JSCNArray(name);
        }
        int maxCols = 0;
        for (int i = 0; i < list.size(); ++i) {
            StringTokenizer tokenizer = new StringTokenizer((String)list.get(i) + "");
            int count = tokenizer.countTokens();
            maxCols = count > maxCols ? count : maxCols;
        }
        double[][] dataArray = new double[list.size()][maxCols];
        for (int i = 0; i < dataArray.length; ++i) {
            StringTokenizer t = new StringTokenizer((String)list.get(i) + "");
            int k = 0;
            while (t.hasMoreTokens() && k < maxCols) {
                Double val = UString.parseToNumber(t.nextToken());
                if (val != null) {
                    dataArray[i][k++] = val;
                    continue;
                }
                dataArray[i][k++] = Double.NaN;
            }
            for (int j = k; j < maxCols; ++j) {
                dataArray[i][j] = Double.NaN;
            }
        }
        return new JSCNArray(name, dataArray);
    }

    public synchronized double[] getCol(int colIndex) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot get cols from empty object " + this.toString() + ".");
        }
        return UMatrix.getDoubleCol(this.value, colIndex);
    }

    public synchronized double[] vec() {
        if (this.isEmpty()) {
            return new double[0];
        }
        return UMatrix.vec(this.value);
    }

    public synchronized double[] getRow(int rowIndex) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot get rows from empty object " + this.toString() + ".");
        }
        return UMatrix.getDoubleRow(this.value, rowIndex);
    }

    public synchronized double[][] getCols(int startCol, int endCol) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot get cols from empty object " + this.toString() + ".");
        }
        return UMatrix.getDoubleCols(this.value, startCol, endCol);
    }

    public synchronized double[][] getRows(int startRow, int endRow) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot get rows from empty object " + this.toString() + ".");
        }
        return UMatrix.getDoubleRows(this.value, startRow, endRow);
    }

    public synchronized double[][] selColsIf(int ... colIndex) {
        return UMatrix.selColsIf(this.value, colIndex);
    }

    public synchronized double[][] selRowsIf(int ... rowIndex) {
        return UMatrix.selRowsIf(this.value, rowIndex);
    }

    public synchronized double[][] getTransposed() {
        if (this.value == null) {
            this.value = new double[0][0];
        }
        return UMatrix.transpose(this.value);
    }

    public synchronized double[][] getPow(double pow) {
        if (this.value == null) {
            this.value = new double[0][0];
        }
        return UMatrix.pow(this.value, pow);
    }
}

