/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.AbstractJSCData;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCDataEventTypes;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.util.SerializationHelper;
import com.jstatcom.util.UMatrix;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class JSCMap
extends AbstractJSCData {
    private final Map<String, Object> valueMap = new LinkedHashMap<String, Object>();
    private final String name;
    private JSCDataEvent clearEvent = null;
    private JSCDataEvent notEmptyEvent = null;
    public static final XmlFormat<JSCMap> JSCMap_XML = new XmlFormat<JSCMap>(JSCMap.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void format(JSCMap data, XmlElement xml) {
            JSCMap jSCMap = data;
            synchronized (jSCMap) {
                xml.setAttribute("name", data.name);
                for (String key : data.valueMap.keySet()) {
                    xml.add(key, "key");
                    xml.add(SerializationHelper.encode(data.valueMap.get(key)), "value");
                }
            }
        }

        @Override
        public JSCMap parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            JSCMap rtn = new JSCMap(nam);
            while (xml.hasNext()) {
                String key = (String)xml.getNext();
                String encoded = (String)xml.getNext();
                rtn.valueMap.put(key, SerializationHelper.decode(encoded));
            }
            return rtn;
        }
    };

    public JSCMap(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
    }

    public JSCMap() {
        this(JSCTypes.MAP + "_DEFAULT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        String[] oldValue = null;
        boolean valChangedListeners = false;
        if (this.eventSupport != null) {
            valChangedListeners = this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0;
        }
        JSCMap jSCMap = this;
        synchronized (jSCMap) {
            if (this.valueMap.size() == 0) {
                return;
            }
            if (valChangedListeners) {
                oldValue = this.getCurrentKeys();
            }
            this.valueMap.clear();
        }
        if (this.clearEvent == null) {
            this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(this.clearEvent);
        if (valChangedListeners) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, new String[0]));
        }
    }

    private String[] getCurrentKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.valueMap.keySet());
        return keys.toArray(new String[0]);
    }

    @Override
    public synchronized JSCMap copy() {
        JSCMap copy = new JSCMap(this.name);
        this.deepCopyMap(this.valueMap, copy.valueMap);
        return copy;
    }

    private void deepCopyMap(Map<String, Object> fromMap, Map<String, Object> toMap) {
        for (String s : fromMap.keySet()) {
            Object val = fromMap.get(s);
            toMap.put(s, this.deepCopyObject(val));
        }
    }

    private Object deepCopyObject(Object val) {
        if (val instanceof String || val instanceof Integer || val instanceof Double || val instanceof Boolean) {
            return val;
        }
        if (val instanceof String[]) {
            String[] valsArr = (String[])val;
            String[] newVal = new String[valsArr.length];
            System.arraycopy(valsArr, 0, newVal, 0, valsArr.length);
            return newVal;
        }
        if (val instanceof int[]) {
            int[] valsArr = (int[])val;
            int[] newVal = new int[valsArr.length];
            System.arraycopy(valsArr, 0, newVal, 0, valsArr.length);
            return newVal;
        }
        if (val instanceof double[]) {
            double[] valsArr = (double[])val;
            double[] newVal = new double[valsArr.length];
            System.arraycopy(valsArr, 0, newVal, 0, valsArr.length);
            return newVal;
        }
        if (val instanceof boolean[]) {
            boolean[] valsArr = (boolean[])val;
            boolean[] newVal = new boolean[valsArr.length];
            System.arraycopy(valsArr, 0, newVal, 0, valsArr.length);
            return newVal;
        }
        if (val instanceof int[][]) {
            int[][] valsArr = (int[][])val;
            int[][] newVal = UMatrix.cloneIntArray(valsArr);
            return newVal;
        }
        if (val instanceof double[][]) {
            double[][] valsArr = (double[][])val;
            double[][] newVal = UMatrix.cloneDoubleArray(valsArr);
            return newVal;
        }
        if (val == null) {
            return null;
        }
        throw new IllegalArgumentException("Value type cannot be handled: " + val);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.valueMap.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isEqual(JSCData o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JSCMap)) {
            return false;
        }
        JSCMap otherMap = (JSCMap)o;
        boolean ret = true;
        JSCMap jSCMap = this;
        synchronized (jSCMap) {
            JSCData jSCData = o;
            synchronized (jSCData) {
                if (!this.valueMap.keySet().equals(otherMap.valueMap.keySet())) {
                    return false;
                }
            }
        }
        return ret;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object val) {
        String[] newValue;
        String[] oldValue;
        if (key == null) {
            throw new IllegalArgumentException("Key was null.");
        }
        boolean wasEmpty = false;
        JSCMap jSCMap = this;
        synchronized (jSCMap) {
            wasEmpty = this.isEmpty();
            oldValue = this.getCurrentKeys();
            this.valueMap.put(key, this.deepCopyObject(val));
            newValue = this.getCurrentKeys();
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.getEventSupport().getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newValue));
        }
        if (wasEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String key) {
        String[] newValue;
        Object rtnVal;
        String[] oldValue;
        if (key == null) {
            throw new IllegalArgumentException("Key was null.");
        }
        JSCMap jSCMap = this;
        synchronized (jSCMap) {
            if (this.isEmpty()) {
                return null;
            }
            if (!this.valueMap.containsKey(key)) {
                return null;
            }
            oldValue = this.getCurrentKeys();
            rtnVal = this.valueMap.remove(key);
            newValue = this.getCurrentKeys();
        }
        if (this.eventSupport == null) {
            return rtnVal;
        }
        if (this.getEventSupport().getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newValue));
        }
        if (newValue.length == 0) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key was null.");
        }
        JSCMap jSCMap = this;
        synchronized (jSCMap) {
            return this.valueMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAll() {
        LinkedHashMap<String, Object> rtnMap = new LinkedHashMap<String, Object>();
        JSCMap jSCMap = this;
        synchronized (jSCMap) {
            this.deepCopyMap(this.valueMap, rtnMap);
        }
        return rtnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key was null.");
        }
        JSCMap jSCMap = this;
        synchronized (jSCMap) {
            return this.valueMap.containsKey(key);
        }
    }

    public synchronized int size() {
        return this.valueMap.size();
    }

    @Override
    public JSCTypes type() {
        return JSCTypes.MAP;
    }

    @Override
    public synchronized Object value() {
        LinkedHashMap<String, Object> toMap = new LinkedHashMap<String, Object>();
        this.deepCopyMap(this.valueMap, toMap);
        return toMap;
    }

    @Override
    public synchronized String display() {
        if (this.valueMap.size() == 0) {
            return "{}";
        }
        StringBuilder b = new StringBuilder();
        b.append("{");
        for (String key : this.valueMap.keySet()) {
            int cols;
            int rows;
            Object valsArr;
            Object val = this.valueMap.get(key);
            b.append(key + "=");
            if (val instanceof Integer || val instanceof Double || val instanceof Boolean) {
                b.append(val);
            } else if (val instanceof String) {
                b.append("\"" + val + "\"");
            } else if (val instanceof String[]) {
                valsArr = (String[])val;
                b.append("String[" + ((String[])valsArr).length + "]");
            } else if (val instanceof int[]) {
                valsArr = (int[])val;
                b.append("int[" + ((String[])valsArr).length + "]");
            } else if (val instanceof double[]) {
                valsArr = (double[])val;
                b.append("double[" + ((String[])valsArr).length + "]");
            } else if (val instanceof boolean[]) {
                valsArr = (boolean[])val;
                b.append("boolean[" + ((String[])valsArr).length + "]");
            } else if (val instanceof int[][]) {
                valsArr = (int[][])val;
                rows = ((String[])valsArr).length;
                cols = 0;
                if (rows > 0) {
                    cols = ((String)valsArr[0]).length;
                }
                b.append("int[" + rows + "][" + cols + "]");
            } else if (val instanceof double[][]) {
                valsArr = (double[][])val;
                rows = ((String[])valsArr).length;
                cols = 0;
                if (rows > 0) {
                    cols = ((String)valsArr[0]).length;
                }
                b.append("double[" + rows + "][" + cols + "]");
            } else if (val == null) {
                b.append("null");
            }
            b.append(",");
        }
        b.delete(b.length() - 1, b.length());
        b.append("}");
        return b.toString();
    }
}

