/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCDataEventTypes;
import com.jstatcom.model.JSCDataListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JSCDataEventSupport {
    private Map<JSCDataEventTypes, List<JSCDataListener>> typeMap = null;

    public void addListener(JSCDataListener evtListener, JSCDataEventTypes evtType) {
        if (evtListener == null || evtType == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.typeMap == null) {
            this.typeMap = new HashMap<JSCDataEventTypes, List<JSCDataListener>>();
        }
        List<Object> toPut = null;
        if (!this.typeMap.containsKey(evtType)) {
            toPut = new ArrayList();
            this.typeMap.put(evtType, toPut);
        } else {
            toPut = this.typeMap.get(evtType);
        }
        if (!toPut.contains(evtListener)) {
            toPut.add(evtListener);
        }
    }

    public void dispatchEvent(JSCDataEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.typeMap == null || this.typeMap.size() == 0) {
            return;
        }
        if (!this.typeMap.containsKey(evt.getType())) {
            return;
        }
        ArrayList currentList = (ArrayList)this.typeMap.get(evt.getType());
        for (int i = 0; i < currentList.size(); ++i) {
            ((JSCDataListener)currentList.get(i)).valueChanged(evt);
        }
    }

    public List<JSCDataListener> getListenersForType(JSCDataEventTypes evtType) {
        if (!this.typeMap.containsKey(evtType)) {
            return new ArrayList<JSCDataListener>();
        }
        List<JSCDataListener> list = this.typeMap.get(evtType);
        return new ArrayList<JSCDataListener>(list);
    }

    public void removeListener(JSCDataListener evtListener) {
        if (evtListener == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.typeMap == null || this.typeMap.size() == 0) {
            return;
        }
        Collection<List<JSCDataListener>> lists = this.typeMap.values();
        for (ArrayList arrayList : lists) {
            arrayList.remove(evtListener);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer(super.toString() + "\n");
        if (this.typeMap == null || this.typeMap.size() == 0) {
            str.append("no listeners registered\n");
        } else {
            Collection<List<JSCDataListener>> lists = this.typeMap.values();
            Set<JSCDataEventTypes> keys = this.typeMap.keySet();
            Iterator<List<JSCDataListener>> it = lists.iterator();
            Iterator kit = keys.iterator();
            while (it.hasNext()) {
                str.append(kit.next() + " " + it.next() + "\n");
            }
        }
        return str.toString();
    }
}

