/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.component.JHelpContextMgr;
import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.io.AbstractImportPanel;
import com.jstatcom.io.DataHandler;
import com.jstatcom.io.DataHandlerTypes;
import com.jstatcom.io.FileSupport;
import com.jstatcom.io.TSImportTypes;
import com.jstatcom.model.JSCDate;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSHolder;
import com.jstatcom.ts.TSList;
import com.jstatcom.ts.TSProject;
import com.jstatcom.ts.TSTable;
import com.jstatcom.ts.TSTableScrollPane;
import com.jstatcom.util.UMatrix;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.Logger;

public final class TSImportPanel
extends AbstractImportPanel {
    private static final Logger log = Logger.getLogger(TSImportPanel.class);
    private boolean hideAfterLoad = true;
    private TSProject project = null;
    private JTextArea ivjJTextArea_Description = null;
    private JTextField ivjJTextField_FileName = null;
    private JLabel ivjJLabel_DescriptionLabel = null;
    private JLabel ivjJLabel_FileLabel = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JScrollPane ivjJScrollPane1 = null;
    private JScrollPane ivjJScrollPane2 = null;
    private JButton ivjBrowseButton = null;
    private JButton ivjLoadButton = null;
    private TSList ivjTSList = null;
    private TSTableScrollPane jScrollPane = null;
    private TSTable TSTable = null;

    public TSImportPanel() {
        this.initialize();
    }

    @Override
    public boolean importData() {
        File file = FileSupport.getInstance().selectDataFile(TopFrameReference.getTopFrameRef(), DataHandlerTypes.EXCEL, DataHandlerTypes.MATLAB, DataHandlerTypes.GAUSS_DAT, DataHandlerTypes.GAUSS_FMT, DataHandlerTypes.DAT);
        if (file == null) {
            return false;
        }
        DataHandlerTypes type = DataHandlerTypes.getTypeFromFileName(file.getAbsolutePath());
        return this.displayDataFile(file, type.getHandler());
    }

    @Override
    public boolean importData(File importFile) {
        if (importFile == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (!importFile.canRead()) {
            throw new RuntimeException("Cannot read from file \"" + importFile.getAbsolutePath() + "\".");
        }
        DataHandlerTypes type = DataHandlerTypes.getTypeFromFileName(importFile.getAbsolutePath());
        return this.displayDataFile(importFile, type.getHandler());
    }

    private void connEtoC1() {
        try {
            this.importData();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4() {
        try {
            this.loadButton_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private boolean displayDataFile(File file, DataHandler handler) {
        String fName = file.getName();
        try {
            if (!handler.importData(file)) {
                return false;
            }
            JSCNArray data = (JSCNArray)handler.getData(TSImportTypes.DATA);
            JSCDate startDate = (JSCDate)handler.getData(TSImportTypes.STARTDATE);
            JSCSArray varNames = (JSCSArray)handler.getData(TSImportTypes.VARNAMES);
            JSCString description = (JSCString)handler.getData(TSImportTypes.DESCRIPTION);
            TS[] tsArray = new TS[data.cols()];
            double[][] values = data.doubleArray();
            String pName = fName;
            if (fName.indexOf(46) >= 0) {
                pName = fName.substring(0, fName.indexOf(46));
            }
            this.project = new TSProject(pName, description.string());
            for (int i = 0; i < tsArray.length; ++i) {
                tsArray[i] = new TS(UMatrix.getDoubleCol(values, i), varNames.stringAt(i, 0), startDate.getTSDate());
            }
            this.getJTextArea_Description().setText(description.string());
            this.getJTextField_FileName().setText(file.getAbsolutePath());
            this.getTSTable().setTS(tsArray);
        }
        catch (Throwable ex) {
            String msg = "Error reading data file \"" + file.getAbsolutePath() + "\".\n";
            String message = msg + ex.getMessage();
            StdMessages.error(message, "Data Import Error");
            log.error((Object)msg, ex);
            return false;
        }
        return true;
    }

    private JButton getBrowseButton() {
        if (this.ivjBrowseButton == null) {
            try {
                this.ivjBrowseButton = new JButton();
                this.ivjBrowseButton.setName("BrowseButton");
                this.ivjBrowseButton.setToolTipText("Choose a file with ascii data.");
                this.ivjBrowseButton.setLocation(new Point(385, 15));
                this.ivjBrowseButton.setText("Browse...");
                this.ivjBrowseButton.setActionCommand("browse");
                this.ivjBrowseButton.setPreferredSize(new Dimension(110, 27));
                this.ivjBrowseButton.setBounds(new Rectangle(385, 15, 85, 27));
                this.ivjBrowseButton.setMinimumSize(new Dimension(110, 27));
                this.ivjBrowseButton.setMargin(new Insets(2, 5, 2, 5));
                URL url = this.getClass().getResource("/images/open.gif");
                if (url != null) {
                    this.ivjBrowseButton.setIcon(new ImageIcon(url));
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBrowseButton;
    }

    private JLabel getJLabel_DescriptionLabel() {
        if (this.ivjJLabel_DescriptionLabel == null) {
            try {
                this.ivjJLabel_DescriptionLabel = new JLabel();
                this.ivjJLabel_DescriptionLabel.setName("JLabel_DescriptionLabel");
                this.ivjJLabel_DescriptionLabel.setLocation(new Point(11, 45));
                this.ivjJLabel_DescriptionLabel.setText("Description");
                this.ivjJLabel_DescriptionLabel.setMaximumSize(new Dimension(150, 20));
                this.ivjJLabel_DescriptionLabel.setHorizontalTextPosition(0);
                this.ivjJLabel_DescriptionLabel.setPreferredSize(new Dimension(140, 20));
                this.ivjJLabel_DescriptionLabel.setBounds(new Rectangle(11, 45, 151, 17));
                this.ivjJLabel_DescriptionLabel.setMinimumSize(new Dimension(140, 20));
                this.ivjJLabel_DescriptionLabel.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel_DescriptionLabel;
    }

    private JLabel getJLabel_FileLabel() {
        if (this.ivjJLabel_FileLabel == null) {
            try {
                this.ivjJLabel_FileLabel = new JLabel();
                this.ivjJLabel_FileLabel.setName("JLabel_FileLabel");
                this.ivjJLabel_FileLabel.setLocation(new Point(11, 15));
                this.ivjJLabel_FileLabel.setText("Filename");
                this.ivjJLabel_FileLabel.setMaximumSize(new Dimension(150, 20));
                this.ivjJLabel_FileLabel.setHorizontalTextPosition(0);
                this.ivjJLabel_FileLabel.setPreferredSize(new Dimension(140, 20));
                this.ivjJLabel_FileLabel.setBounds(new Rectangle(11, 15, 151, 17));
                this.ivjJLabel_FileLabel.setMinimumSize(new Dimension(140, 20));
                this.ivjJLabel_FileLabel.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel_FileLabel;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.ivjJScrollPane1.setPreferredSize(new Dimension(3, 80));
                this.ivjJScrollPane1.setMinimumSize(new Dimension(22, 80));
                this.getJScrollPane1().setViewportView(this.getJTextArea_Description());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JScrollPane getJScrollPane2() {
        if (this.ivjJScrollPane2 == null) {
            try {
                this.ivjJScrollPane2 = new JScrollPane();
                this.ivjJScrollPane2.setName("JScrollPane2");
                this.ivjJScrollPane2.setPreferredSize(new Dimension(100, 131));
                this.getJScrollPane2().setViewportView(this.getTSList());
                TitledBorder title = new TitledBorder(new BevelBorder(1), "Loaded Data", 3, 2);
                this.getJScrollPane2().setBorder(title);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane2;
    }

    private JTextArea getJTextArea_Description() {
        if (this.ivjJTextArea_Description == null) {
            try {
                this.ivjJTextArea_Description = new JTextArea();
                this.ivjJTextArea_Description.setName("JTextArea_Description");
                this.ivjJTextArea_Description.setBounds(new Rectangle(0, 0, 200, 39));
                this.ivjJTextArea_Description.setEditable(false);
                this.ivjJTextArea_Description.setBounds(0, 0, 297, 52);
                this.ivjJTextArea_Description.setMargin(new Insets(0, 2, 0, 2));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextArea_Description;
    }

    private JTextField getJTextField_FileName() {
        if (this.ivjJTextField_FileName == null) {
            try {
                this.ivjJTextField_FileName = new JTextField();
                this.ivjJTextField_FileName.setName("JTextField_FileName");
                this.ivjJTextField_FileName.setLocation(new Point(177, 15));
                this.ivjJTextField_FileName.setBounds(new Rectangle(177, 15, 200, 21));
                this.ivjJTextField_FileName.setMargin(new Insets(0, 2, 0, 0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextField_FileName;
    }

    private JButton getLoadButton() {
        if (this.ivjLoadButton == null) {
            try {
                this.ivjLoadButton = new JButton();
                this.ivjLoadButton.setName("LoadButton");
                this.ivjLoadButton.setToolTipText("<html>\nLoad data shown in table to time series list.<br>\nYour changes will then apply. If you have edited<br>\nexisting series, then you have to confirm to overwrite<br>\nthese series</html>");
                this.ivjLoadButton.setLocation(new Point(77, 195));
                this.ivjLoadButton.setText("Load Dataset");
                this.ivjLoadButton.setMaximumSize(new Dimension(110, 27));
                this.ivjLoadButton.setActionCommand("load");
                this.ivjLoadButton.setPreferredSize(new Dimension(110, 27));
                this.ivjLoadButton.setBounds(new Rectangle(77, 195, 85, 27));
                this.ivjLoadButton.setMinimumSize(new Dimension(110, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLoadButton;
    }

    private TSList getTSList() {
        if (this.ivjTSList == null) {
            try {
                this.ivjTSList = new TSList();
                this.ivjTSList.setName("TSList");
                this.ivjTSList.setTSListPopup(null);
                this.ivjTSList.setTSKeyListener(null);
                this.ivjTSList.setBounds(0, 0, 100, 175);
                this.ivjTSList.setTSMouseListener(null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTSList;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.getLoadButton().addActionListener(this.ivjEventHandler);
        this.getBrowseButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("UIReadData");
            this.setPreferredSize(new Dimension(550, 350));
            this.setLayout(new GridBagLayout());
            this.setSize(650, 400);
            this.setMinimumSize(new Dimension(550, 350));
            GridBagConstraints constraintsJTextField_FileName = new GridBagConstraints();
            constraintsJTextField_FileName.gridx = 1;
            constraintsJTextField_FileName.gridy = 0;
            constraintsJTextField_FileName.fill = 2;
            constraintsJTextField_FileName.weightx = 1.0;
            constraintsJTextField_FileName.insets = new Insets(0, 0, 5, 0);
            GridBagConstraints constraintsBrowseButton = new GridBagConstraints();
            constraintsBrowseButton.gridx = 2;
            constraintsBrowseButton.gridy = 0;
            constraintsBrowseButton.gridheight = 2;
            constraintsBrowseButton.insets = new Insets(0, 10, 0, 10);
            this.add((Component)this.getBrowseButton(), constraintsBrowseButton);
            GridBagConstraints constraintsJLabel_DescriptionLabel = new GridBagConstraints();
            constraintsJLabel_DescriptionLabel.gridx = 0;
            constraintsJLabel_DescriptionLabel.gridy = 2;
            constraintsJLabel_DescriptionLabel.fill = 2;
            constraintsJLabel_DescriptionLabel.anchor = 12;
            GridBagConstraints constraintsLoadButton = new GridBagConstraints();
            constraintsLoadButton.gridx = 2;
            constraintsLoadButton.gridy = 2;
            constraintsLoadButton.insets = new Insets(5, 0, 5, 0);
            this.add((Component)this.getLoadButton(), constraintsLoadButton);
            GridBagConstraints constraintsJLabel_FileLabel = new GridBagConstraints();
            constraintsJLabel_FileLabel.gridx = 0;
            constraintsJLabel_FileLabel.gridy = 0;
            constraintsJLabel_FileLabel.anchor = 12;
            constraintsJLabel_FileLabel.insets = new Insets(0, 0, 5, 10);
            GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
            constraintsJScrollPane1.gridx = 1;
            constraintsJScrollPane1.gridy = 1;
            constraintsJScrollPane1.gridheight = 2;
            constraintsJScrollPane1.fill = 1;
            constraintsJScrollPane1.weightx = 1.0;
            constraintsJScrollPane1.insets = new Insets(0, 0, 0, 0);
            GridBagConstraints constraintsJScrollPane2 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints1 = new GridBagConstraints();
            constraintsJLabel_DescriptionLabel.insets = new Insets(0, 0, 0, 10);
            consGridBagConstraints1.fill = 1;
            consGridBagConstraints1.weighty = 1.0;
            consGridBagConstraints1.weightx = 1.0;
            consGridBagConstraints1.gridy = 9;
            consGridBagConstraints1.gridx = 1;
            consGridBagConstraints1.gridwidth = 2;
            consGridBagConstraints1.insets = new Insets(5, 0, 0, 0);
            constraintsJScrollPane2.gridx = 0;
            constraintsJScrollPane2.gridy = 9;
            constraintsJScrollPane2.fill = 1;
            constraintsJScrollPane2.weighty = 1.0;
            constraintsJScrollPane2.insets = new Insets(5, 0, 0, 0);
            this.add((Component)this.getJTextField_FileName(), constraintsJTextField_FileName);
            this.add((Component)this.getJLabel_DescriptionLabel(), constraintsJLabel_DescriptionLabel);
            this.add((Component)this.getJLabel_FileLabel(), constraintsJLabel_FileLabel);
            this.add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
            this.add((Component)this.getJScrollPane2(), constraintsJScrollPane2);
            this.add((Component)this.getTSTableScrollPane(), consGridBagConstraints1);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        TitledBorder title = new TitledBorder(new BevelBorder(1), "Open Data File", 3, 2);
        this.setBorder(title);
        JHelpContextMgr.register(this);
    }

    private void loadButton_ActionEvents() {
        TableCellEditor ed = this.getTSTable().getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
        TS[] sel = this.getTSTable().getTS();
        for (int i = 0; i < sel.length; ++i) {
            sel[i].setTSProject(this.project);
            int res = TSHolder.getInstance().addTS(sel[i]);
            if (res != 2) continue;
            return;
        }
        if (this.hideAfterLoad && this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private TSTableScrollPane getTSTableScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new TSTableScrollPane();
            this.jScrollPane.setViewportView(this.getTSTable());
        }
        return this.jScrollPane;
    }

    private TSTable getTSTable() {
        if (this.TSTable == null) {
            this.TSTable = new TSTable();
        }
        return this.TSTable;
    }

    public boolean isHideAfterLoad() {
        return this.hideAfterLoad;
    }

    public void setHideAfterLoad(boolean b) {
        this.hideAfterLoad = b;
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TSImportPanel.this.getLoadButton()) {
                TSImportPanel.this.connEtoC4();
            }
            if (e.getSource() == TSImportPanel.this.getBrowseButton()) {
                TSImportPanel.this.connEtoC1();
            }
        }
    }
}

