/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.component.TopFrameReference;
import com.jstatcom.io.DataHandler;
import com.jstatcom.io.ExcelHelper;
import com.jstatcom.io.ImportTypes;
import com.jstatcom.io.TSExcelDialog;
import com.jstatcom.io.TSImportTypes;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDate;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import jxl.Sheet;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public final class TSExcelHandler
implements DataHandler {
    private boolean noDialog = false;
    private TSExcelDialog tableDialog = null;
    private final SymbolTable symbolTable = new SymbolTable("TSExcelImport", false);
    private static final TSExcelHandler handler = new TSExcelHandler();

    private TSExcelHandler() {
    }

    public static TSExcelHandler getInstance() {
        return handler;
    }

    @Override
    public boolean importData(File dataFile) {
        if (dataFile == null || !dataFile.isFile()) {
            throw new IllegalArgumentException("Invalid data file " + dataFile + ".");
        }
        Workbook w = null;
        this.symbolTable.clear();
        try {
            w = Workbook.getWorkbook((File)dataFile);
            this.parseToDataSet(w);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
        w.close();
        return !this.symbolTable.isEmpty();
    }

    @Override
    public JSCData getData(ImportTypes type) {
        if (this.symbolTable == null) {
            throw new IllegalStateException("There was nothing imported yet.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        return this.symbolTable.getJSCData(new JSCTypeDef(type.name(), type.type()));
    }

    private TSExcelDialog getTableDialog() {
        if (this.tableDialog == null) {
            this.tableDialog = new TSExcelDialog((Frame)TopFrameReference.getTopFrameRef(), true);
        }
        this.tableDialog.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
        return this.tableDialog;
    }

    private void parseToDataSet(Workbook w) {
        int sheet = 0;
        String[] sheetNames = new String[w.getNumberOfSheets()];
        Sheet[] sheets = w.getSheets();
        for (int i = 0; i < sheetNames.length; ++i) {
            sheetNames[i] = sheets[i].getName();
        }
        if (w.getNumberOfSheets() > 0) {
            this.getTableDialog().setSheets(sheetNames);
            if (!this.noDialog) {
                this.getTableDialog().setVisible(true);
            }
            sheet = this.getTableDialog().getSelectedSheet();
            if (this.getTableDialog().isCanceled()) {
                return;
            }
        } else {
            throw new RuntimeException("File contains no sheets.");
        }
        Sheet s = w.getSheet(sheet);
        ArrayList<String> labelsList = new ArrayList<String>();
        double[][] data = ExcelHelper.extractNumberArray(w, sheet, false, null, labelsList);
        String[] varNames = new String[s.getColumns()];
        for (int i = 0; i < s.getColumns(); ++i) {
            varNames[i] = "var" + (i + 1) + "_sheet" + (sheet + 1);
            String name = (String)labelsList.get(i);
            if (JSCConstants.isValidName(name = name.replace(' ', '_')) != null) continue;
            varNames[i] = name;
        }
        this.symbolTable.set(new JSCNArray(TSImportTypes.DATA.name(), data));
        this.symbolTable.set(new JSCDate(TSImportTypes.STARTDATE.name(), this.getTableDialog().getTSDate()));
        this.symbolTable.set(new JSCSArray(TSImportTypes.VARNAMES.name(), varNames));
    }

    @Override
    public void exportTS(File file, TS[] ts, String description) {
        if (file == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        if (ts == null) {
            throw new IllegalArgumentException("Time series argument was null.");
        }
        if (ts.length == 0) {
            return;
        }
        TSDateRange mergedRange = TSDateRange.getMergedRange(ts);
        Label[] labels = new Label[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            labels[i] = new Label(i, 0, ts[i].name());
        }
        try {
            int i;
            WritableWorkbook workbook = Workbook.createWorkbook((File)file);
            WritableSheet s1 = workbook.createSheet("Time Series", 0);
            for (i = 0; i < labels.length; ++i) {
                s1.addCell((WritableCell)labels[i]);
                s1.setColumnView(i, 25);
            }
            for (i = 0; i < mergedRange.numOfObs(); ++i) {
                TSDate currentDate = mergedRange.dateForIndex(i);
                for (int j = 0; j < ts.length; ++j) {
                    Number num = new Number(j, i + 1, ts[j].valueAt(currentDate));
                    s1.addCell((WritableCell)num);
                }
            }
            workbook.write();
            workbook.close();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public void exportData(File file, JSCData data, String description) {
        if (file == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data argument was null.");
        }
        if (data.type() != JSCTypes.NARRAY) {
            throw new IllegalArgumentException("Data of type \"" + data.type() + "\" cannot be stored in Excel format.");
        }
        if (data.isEmpty()) {
            return;
        }
        JSCNArray nArray = (JSCNArray)data;
        Label[] labels = new Label[nArray.cols()];
        if (labels.length == 1) {
            labels[0] = new Label(0, 0, nArray.name());
        } else {
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = new Label(i, 0, nArray.name() + "_" + (i + 1));
            }
        }
        try {
            int i;
            WritableWorkbook workbook = Workbook.createWorkbook((File)file);
            WritableSheet s1 = workbook.createSheet(nArray.name(), 0);
            for (i = 0; i < labels.length; ++i) {
                s1.addCell((WritableCell)labels[i]);
                s1.setColumnView(i, 25);
            }
            for (i = 0; i < nArray.rows(); ++i) {
                for (int j = 0; j < nArray.cols(); ++j) {
                    Number num = new Number(j, i + 1, nArray.doubleAt(i, j));
                    s1.addCell((WritableCell)num);
                }
            }
            workbook.write();
            workbook.close();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setTestMode(boolean noDialog) {
        this.noDialog = noDialog;
    }
}

