/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.component.StdMessages;
import com.jstatcom.ts.TSDate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import org.apache.log4j.Logger;

public class TSExcelDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(TSExcelDialog.class);
    private TSDate tsDate = TSDate.valueOf("1960 Q1");
    private JTextArea jTextArea = null;
    private Frame frame = null;
    private String[] sheetNames = new String[0];
    private int selectedSheet = 0;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JComboBox ivjJComboBox1 = null;
    private JPanel ivjJDialogContentPane = null;
    private JLabel ivjJLabel1 = null;
    private JButton ivjOK = null;
    public boolean canceled = false;
    private JButton ivjCancel = null;
    private JPanel ivjJPanel1 = null;
    private JPanel ivjJPanel2 = null;
    private JLabel ivjJLabel3 = null;
    private JTextField ivjStartDate = null;

    public TSExcelDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
        this.frame = owner;
    }

    private void cancel_ActionEvents() {
        this.setVisible(false);
        this.setCanceled(true);
    }

    private void connEtoC1() {
        try {
            this.oK_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.jComboBox1_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.cancel_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getCancel() {
        if (this.ivjCancel == null) {
            try {
                this.ivjCancel = new JButton();
                this.ivjCancel.setName("Cancel");
                this.ivjCancel.setPreferredSize(new Dimension(85, 25));
                this.ivjCancel.setText("Cancel");
                this.ivjCancel.setMaximumSize(new Dimension(100, 25));
                this.ivjCancel.setMinimumSize(new Dimension(85, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCancel;
    }

    private JComboBox getJComboBox1() {
        if (this.ivjJComboBox1 == null) {
            try {
                this.ivjJComboBox1 = new JComboBox();
                this.ivjJComboBox1.setName("JComboBox1");
                this.ivjJComboBox1.setBounds(20, 20, 150, 23);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJComboBox1;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setBorder(new BevelBorder(1));
                this.ivjJDialogContentPane.setLayout(new BorderLayout());
                this.getJDialogContentPane().add((Component)this.getJPanel1(), "Center");
                this.getJDialogContentPane().add((Component)this.getJPanel2(), "South");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setPreferredSize(new Dimension(146, 21));
                this.ivjJLabel1.setText("Select the Excel sheet with data");
                this.ivjJLabel1.setBounds(180, 22, 205, 21);
                this.ivjJLabel1.setMinimumSize(new Dimension(146, 21));
                this.ivjJLabel1.setMaximumSize(new Dimension(146, 21));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setText("Date of first observation");
                this.ivjJLabel3.setBounds(180, 63, 210, 17);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel3;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setBorder(new BevelBorder(1));
                this.ivjJPanel1.setLayout(null);
                this.getJPanel1().add((Component)this.getJLabel1(), this.getJLabel1().getName());
                this.getJPanel1().add((Component)this.getJComboBox1(), this.getJComboBox1().getName());
                this.getJPanel1().add((Component)this.getStartDate(), this.getStartDate().getName());
                this.getJPanel1().add((Component)this.getJLabel3(), this.getJLabel3().getName());
                this.ivjJPanel1.add((Component)this.getJTextArea(), null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setBackground(this.getJDialogContentPane().getBackground());
            this.jTextArea.setMargin(new Insets(5, 5, 5, 5));
            StringBuffer txt = new StringBuffer();
            txt.append("quarterly: \"1960 Q1\"\n");
            txt.append("monthly: \"1960 M10\"\n");
            txt.append("annual: \"1960\"\n");
            txt.append("semi-annual: \"1960 I\" or \"1960 II\"\n");
            txt.append("daily (5 day week): \"11/25/2004 (5)\"\n");
            txt.append("daily (7 day week): \"12/11/1982 (7)\"\n");
            txt.append("undated: \"1\" \n");
            txt.append("arbitrary spec: \"1960 30/265\"");
            this.jTextArea.setText(txt.toString());
            this.jTextArea.setEditable(false);
            this.jTextArea.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Examples", 0, 0, null, null));
            this.jTextArea.setBounds(20, 90, 370, 175);
        }
        return this.jTextArea;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setPreferredSize(new Dimension(0, 50));
                this.ivjJPanel2.setLayout(this.getJPanel2FlowLayout());
                this.ivjJPanel2.setMinimumSize(new Dimension(0, 50));
                this.getJPanel2().add((Component)this.getOK(), this.getOK().getName());
                this.getJPanel2().add((Component)this.getCancel(), this.getCancel().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private FlowLayout getJPanel2FlowLayout() {
        FlowLayout ivjJPanel2FlowLayout = null;
        try {
            ivjJPanel2FlowLayout = new FlowLayout();
            ivjJPanel2FlowLayout.setVgap(10);
            ivjJPanel2FlowLayout.setHgap(40);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel2FlowLayout;
    }

    private JButton getOK() {
        if (this.ivjOK == null) {
            try {
                this.ivjOK = new JButton();
                this.ivjOK.setName("OK");
                this.ivjOK.setPreferredSize(new Dimension(85, 25));
                this.ivjOK.setText("OK");
                this.ivjOK.setMaximumSize(new Dimension(100, 25));
                this.ivjOK.setMinimumSize(new Dimension(85, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOK;
    }

    public int getSelectedSheet() {
        return this.selectedSheet;
    }

    private JTextField getStartDate() {
        if (this.ivjStartDate == null) {
            try {
                this.ivjStartDate = new JTextField();
                this.ivjStartDate.setName("StartDate");
                this.ivjStartDate.setText("1960 Q1");
                this.ivjStartDate.setBounds(20, 60, 150, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStartDate;
    }

    public TSDate getTSDate() {
        return this.tsDate;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.getOK().addActionListener(this.ivjEventHandler);
        this.getJComboBox1().addActionListener(this.ivjEventHandler);
        this.getCancel().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setBounds(31, 0, 420, 368);
            this.setName("TableChooser");
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.setTitle("Specify Excel Dataset");
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getRootPane().setDefaultButton(this.getOK());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void jComboBox1_ActionEvents() {
        this.setSelectedSheet(this.getJComboBox1().getSelectedIndex());
    }

    private void oK_ActionEvents() {
        String exp = this.getStartDate().getText();
        try {
            this.tsDate = TSDate.valueOf(exp);
        }
        catch (Throwable ex) {
            StdMessages.errorInput("Could not parse \"" + exp + "\" to a valid date.");
            return;
        }
        this.setVisible(false);
        this.setCanceled(false);
    }

    private void setCanceled(boolean newCanceled) {
        this.canceled = newCanceled;
    }

    private void setSelectedSheet(int newSelectedSheet) {
        this.selectedSheet = newSelectedSheet;
    }

    public void setSheets(String[] sheetNames) {
        if (sheetNames == null) {
            sheetNames = new String[]{};
        }
        this.sheetNames = sheetNames;
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (isVisible) {
            if (this.frame != null) {
                this.setLocationRelativeTo(this.frame);
            }
            this.selectedSheet = 0;
            this.getJComboBox1().removeAllItems();
            for (int i = 0; i < this.sheetNames.length; ++i) {
                this.getJComboBox1().addItem(this.sheetNames[i]);
            }
        }
        super.setVisible(isVisible);
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TSExcelDialog.this.getOK()) {
                TSExcelDialog.this.connEtoC1();
            }
            if (e.getSource() == TSExcelDialog.this.getJComboBox1()) {
                TSExcelDialog.this.connEtoC2();
            }
            if (e.getSource() == TSExcelDialog.this.getCancel()) {
                TSExcelDialog.this.connEtoC3();
            }
        }
    }
}

