/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.io.AbstractImportPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ImportDataFrame
extends JInternalFrame {
    private static final Logger log = Logger.getLogger(ImportDataFrame.class);
    private AbstractImportPanel importPanel = null;
    private JPanel ivjContentPane = null;

    public ImportDataFrame() {
        this.initialize();
    }

    public boolean importData() {
        if (this.importPanel == null) {
            throw new IllegalStateException("No import panel set.");
        }
        return this.importPanel.importData();
    }

    public boolean importData(File importFile) {
        if (this.importPanel == null) {
            throw new IllegalStateException("No import panel set.");
        }
        return this.importPanel.importData(importFile);
    }

    private JPanel getIvjContentPane() {
        if (this.ivjContentPane == null) {
            try {
                this.ivjContentPane = new JPanel();
                this.ivjContentPane.setName("InternalFrameContentPane");
                this.ivjContentPane.setLayout(new BoxLayout(this.getIvjContentPane(), 0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjContentPane;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initialize() {
        try {
            this.setClosable(true);
            this.setResizable(true);
            this.setMaximizable(true);
            this.setIconifiable(true);
            this.setName("OpenFrame");
            this.setSize(600, 400);
            this.setMinimumSize(new Dimension(600, 400));
            this.setTitle("Import Dataset");
            this.setContentPane(this.getIvjContentPane());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        URL url = this.getClass().getResource("/images/import.gif");
        if (url != null) {
            this.setFrameIcon(new ImageIcon(url));
        }
    }

    public void setImportPanel(AbstractImportPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException("Panel was null.");
        }
        this.importPanel = panel;
        this.getIvjContentPane().add((Component)this.importPanel, this.importPanel.getName());
    }
}

