/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import EDU.oswego.cs.dl.util.concurrent.misc.SwingWorker;
import com.jstatcom.io.DataHandlerTypes;
import com.jstatcom.io.ExtensionFileFilter;
import com.jstatcom.io.FileSupportSettings;
import com.jstatcom.model.JSCSArray;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public final class FileSupport {
    private static final Logger log = Logger.getLogger(FileSupport.class);
    private static final FileSupport fileSupport = new FileSupport();
    private JFileChooser fileChooserOpenDat = null;
    private JFileChooser fileChooserSave = null;
    private final ExtensionFileFilter projectFileFilter = new ExtensionFileFilter("jsc", "Project Files");
    private final ExtensionFileFilter textFileFilter = new ExtensionFileFilter("txt", "ASCII Text Files");
    private String saveTextDirectory = null;
    private String dataDirectory = null;
    private String projectFile = "";
    private String projectDirectory = null;
    private FileFilter currentSaveFilter = null;
    private final WorkerFileChooser fileChooserOpenDat_Worker = new WorkerFileChooser();
    private final WorkerFileChooser fileChooserSave_Worker = new WorkerFileChooser();

    private FileSupport() {
    }

    public File chooseDirectory(Component parent, String titleText) {
        File dir = null;
        this.getFileChooserOpenDat().setDialogTitle(titleText);
        this.getFileChooserOpenDat().setFileSelectionMode(1);
        int returnVal = this.getFileChooserOpenDat().showOpenDialog(parent);
        if (returnVal == 0) {
            dir = this.getFileChooserOpenDat().getSelectedFile();
        }
        return dir;
    }

    private JFileChooser getFileChooserOpenDat() {
        if (this.fileChooserOpenDat == null) {
            Object obj = this.fileChooserOpenDat_Worker.get();
            this.fileChooserOpenDat = obj instanceof JFileChooser ? (JFileChooser)obj : new JFileChooser();
        }
        return this.fileChooserOpenDat;
    }

    private JFileChooser getFileChooserSave() {
        if (this.fileChooserSave == null) {
            Object obj = this.fileChooserSave_Worker.get();
            this.fileChooserSave = obj instanceof JFileChooser ? (JFileChooser)obj : new JFileChooser();
        }
        return this.fileChooserSave;
    }

    public static FileSupport getInstance() {
        return fileSupport;
    }

    public String readTextFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Filename was null.");
        }
        BufferedReader in = null;
        StringBuffer str = new StringBuffer();
        String tmp = null;
        try {
            in = new BufferedReader(new FileReader(fileName));
            while ((tmp = in.readLine()) != null) {
                str.append(tmp + "\n");
            }
            in.close();
        }
        catch (IOException e) {
            log.error((Object)("Error reading text from \"" + fileName + "\"."), (Throwable)e);
            return "Error reading text from \"" + fileName + "\".";
        }
        return str.toString();
    }

    public File saveDataFile(Component parent, String filenameShort, DataHandlerTypes ... types) {
        if (filenameShort != null) {
            filenameShort = filenameShort.trim();
        }
        if (this.dataDirectory != null) {
            Object dir = null;
            if (filenameShort == null || filenameShort.length() == 0) {
                dir = new File(this.dataDirectory);
                if (((File)dir).isDirectory()) {
                    this.getFileChooserSave().setCurrentDirectory((File)dir);
                }
            } else {
                dir = new File(this.dataDirectory + File.separator + filenameShort);
                this.getFileChooserSave().setSelectedFile((File)dir);
            }
        }
        this.getFileChooserSave().setDialogTitle("Save Data As ...");
        this.getFileChooserSave().resetChoosableFileFilters();
        for (DataHandlerTypes type : types) {
            if (!type.canWriteFormat()) continue;
            this.getFileChooserSave().addChoosableFileFilter(type.getFileFilter());
        }
        if (this.currentSaveFilter != null) {
            this.getFileChooserSave().setFileFilter(this.currentSaveFilter);
        }
        this.getFileChooserSave().setMultiSelectionEnabled(false);
        this.getFileChooserSave().rescanCurrentDirectory();
        int returnVal = this.getFileChooserSave().showSaveDialog(parent);
        if (returnVal == 0) {
            int accept;
            File file = this.getFileChooserSave().getSelectedFile();
            if (file.getName().indexOf(".") < 1) {
                String ext = this.getSelectedSaveHandlerType().getFileExtension();
                file = new File(file.getAbsolutePath() + "." + ext);
            }
            if (file.exists() && (accept = JOptionPane.showConfirmDialog(parent, "The file " + file.getAbsolutePath() + " already exists, overwrite?", "Overwrite Existing File?", 0)) == 1) {
                return null;
            }
            this.dataDirectory = file.getParent();
            this.currentSaveFilter = this.getFileChooserSave().getFileFilter();
            return file;
        }
        return null;
    }

    public File saveProjectFile(Component parent) {
        int returnVal;
        if (this.projectDirectory != null) {
            this.getFileChooserSave().setCurrentDirectory(new File(this.projectDirectory));
        }
        this.getFileChooserSave().setDialogTitle("Save Project As ...");
        this.getFileChooserSave().resetChoosableFileFilters();
        this.getFileChooserSave().addChoosableFileFilter(this.projectFileFilter);
        this.getFileChooserSave().setMultiSelectionEnabled(false);
        this.getFileChooserSave().rescanCurrentDirectory();
        if (this.projectFile != null) {
            this.getFileChooserSave().setSelectedFile(new File(this.projectFile));
        }
        if ((returnVal = this.getFileChooserSave().showSaveDialog(parent)) == 0) {
            int accept;
            File file = this.getFileChooserSave().getSelectedFile();
            if (file.exists() && (accept = JOptionPane.showConfirmDialog(parent, "The file " + file.toString() + " already exists, overwrite?", "Overwrite Existing File?", 0)) == 1) {
                return null;
            }
            String fileName = file.toString();
            if (fileName.indexOf(".", fileName.lastIndexOf("/")) < 0) {
                fileName = fileName + ".jsc";
                file = new File(fileName);
            }
            this.projectDirectory = file.getParent();
            this.projectFile = file.getName();
            return file;
        }
        return null;
    }

    public void saveStringToFile(File file, String stringDat, boolean append) {
        if (file != null) {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(file, append));
                out.write(stringDat);
                out.flush();
                out.close();
            }
            catch (IOException ivjExc) {
                log.error((Object)("error saving data to file: " + file.getAbsolutePath()), (Throwable)ivjExc);
            }
        }
    }

    public File saveTextFile(Component parent) {
        if (this.saveTextDirectory != null) {
            this.getFileChooserSave().setCurrentDirectory(new File(this.saveTextDirectory));
        }
        this.getFileChooserSave().setDialogTitle("Save Results As ...");
        this.getFileChooserSave().resetChoosableFileFilters();
        this.getFileChooserSave().addChoosableFileFilter(this.textFileFilter);
        this.getFileChooserSave().setMultiSelectionEnabled(false);
        this.getFileChooserSave().rescanCurrentDirectory();
        int returnVal = this.getFileChooserSave().showSaveDialog(parent);
        if (returnVal == 0) {
            int accept;
            File file = this.getFileChooserSave().getSelectedFile();
            if (file.exists() && (accept = JOptionPane.showConfirmDialog(parent, "The file " + file.toString() + " already exists, overwrite?", "Overwrite Existing File?", 0)) == 1) {
                return null;
            }
            this.saveTextDirectory = file.getParent();
            return file;
        }
        return null;
    }

    public File selectDataFile(Component parent, DataHandlerTypes ... types) {
        if (this.dataDirectory == null) {
            if (new File(this.dataDirectory, "dataset").isDirectory()) {
                this.getFileChooserOpenDat().setCurrentDirectory(new File(this.dataDirectory, "dataset"));
            }
        } else {
            this.getFileChooserOpenDat().setCurrentDirectory(new File(this.dataDirectory));
        }
        this.getFileChooserOpenDat().setDialogTitle("Import Dataset");
        if (this.getFileChooserOpenDat().getChoosableFileFilters().length < 3) {
            this.getFileChooserOpenDat().resetChoosableFileFilters();
            for (DataHandlerTypes type : types) {
                this.getFileChooserOpenDat().addChoosableFileFilter(type.getFileFilter());
            }
        }
        this.getFileChooserOpenDat().rescanCurrentDirectory();
        this.getFileChooserOpenDat().setMultiSelectionEnabled(false);
        int returnVal = this.getFileChooserOpenDat().showOpenDialog(parent);
        if (returnVal == 0) {
            File file = this.getFileChooserOpenDat().getSelectedFile();
            this.dataDirectory = file.getParent();
            return file;
        }
        return null;
    }

    public File selectProjectFile(Component parent) {
        if (this.projectDirectory != null) {
            this.getFileChooserOpenDat().setCurrentDirectory(new File(this.projectDirectory));
        }
        this.getFileChooserOpenDat().setDialogTitle("Open Project");
        this.getFileChooserOpenDat().resetChoosableFileFilters();
        this.getFileChooserOpenDat().addChoosableFileFilter(this.projectFileFilter);
        this.getFileChooserOpenDat().rescanCurrentDirectory();
        this.getFileChooserOpenDat().setMultiSelectionEnabled(false);
        int returnVal = this.getFileChooserOpenDat().showOpenDialog(parent);
        if (returnVal == 0) {
            File file = this.getFileChooserOpenDat().getSelectedFile();
            this.projectDirectory = file.getParent();
            this.projectFile = file.getName();
            return file;
        }
        return null;
    }

    public void setDefaultPath(String newDefaultPath) {
        this.dataDirectory = newDefaultPath;
        this.saveTextDirectory = newDefaultPath;
    }

    public void startWorkers() {
        this.fileChooserOpenDat_Worker.start();
        this.fileChooserSave_Worker.start();
    }

    public void setFileSupportSettings(FileSupportSettings settings) {
        if (settings == null) {
            return;
        }
        JSCSArray sel = settings.getSelectedFiles();
        if (sel.isEmpty() || sel.rows() < 4) {
            return;
        }
        this.saveTextDirectory = sel.stringAt(0, 0);
        this.dataDirectory = sel.stringAt(1, 0);
        this.projectFile = sel.stringAt(2, 0);
        this.projectDirectory = sel.stringAt(3, 0);
    }

    public FileSupportSettings getFileSupportSettings() {
        FileSupportSettings settings = new FileSupportSettings();
        JSCSArray sel = new JSCSArray("files", this.saveTextDirectory, this.dataDirectory, this.projectFile, this.projectDirectory);
        settings.setSelectedFiles(sel);
        return settings;
    }

    public DataHandlerTypes getSelectedImportHandlerType() {
        FileFilter filter = this.getFileChooserOpenDat().getFileFilter();
        DataHandlerTypes type = DataHandlerTypes.DAT;
        if (filter instanceof ExtensionFileFilter) {
            type = ((ExtensionFileFilter)filter).getHandlerType();
        }
        if (type == null) {
            type = DataHandlerTypes.DAT;
        }
        return type;
    }

    public DataHandlerTypes getSelectedSaveHandlerType() {
        FileFilter filter = this.getFileChooserSave().getFileFilter();
        DataHandlerTypes type = DataHandlerTypes.DAT;
        if (filter instanceof ExtensionFileFilter) {
            type = ((ExtensionFileFilter)filter).getHandlerType();
        }
        if (type == null) {
            type = DataHandlerTypes.DAT;
        }
        return type;
    }

    private static class WorkerFileChooser
    extends SwingWorker {
        private JFileChooser ret = null;

        private WorkerFileChooser() {
        }

        public Object construct() {
            if (this.ret == null) {
                this.ret = new JFileChooser();
            }
            return this.ret;
        }

        public Object get() {
            return this.ret;
        }
    }
}

