/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.equation;

import com.jstatcom.equation.EqPanel;
import com.jstatcom.equation.EqTerm;
import com.jstatcom.equation.EqTermDefault;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Scope;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolEvent;
import com.jstatcom.model.SymbolListener;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.table.JSCPopupTypes;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

public final class EqTermAR
extends EqTerm
implements PropertyChangeListener,
SymbolListener {
    private EqTermDefault firstTerm = null;
    private JSCTypeDef lagsDef = null;
    private List<EqTerm> allTerms;
    private boolean addTermsToParent = true;
    private EqPanel equationPanelParent = null;
    private JPopupMenu tablePopup = JSCPopupTypes.PRECISION;
    private Symbol lagsSymbol = null;

    public EqTermAR() {
        super(new FlowLayout(0, 0, 0));
        this.allTerms = new ArrayList<EqTerm>();
        this.firstTerm = new EqTermDefault();
        this.allTerms.add(this.firstTerm);
        this.firstTerm.addPropertyChangeListener(this);
        this.firstTerm.setCoeffMatRequired(true);
        this.firstTerm.setOpaque(false);
        this.firstTerm.setVisible(false);
        this.add(this.firstTerm);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container parent = this.getParent();
        if (parent != null && parent instanceof EqPanel) {
            this.equationPanelParent = (EqPanel)parent;
        }
        Runnable thread = new Runnable(){

            @Override
            public void run() {
                EqTermAR.this.updateLagsSymbol();
            }
        };
        SwingUtilities.invokeLater(thread);
    }

    public int getColumnWidth() {
        return ((EqTermDefault)this.allTerms.get(0)).getColumnWidth();
    }

    public MouseListener getMouseListenerCoeff() {
        return ((EqTermDefault)this.allTerms.get(0)).getMouseListenerCoeff();
    }

    public int getPrecision() {
        return ((EqTermDefault)this.allTerms.get(0)).getPrecision();
    }

    public TableCellRenderer getRendererCoeff() {
        return ((EqTermDefault)this.allTerms.get(0)).getRendererCoeff();
    }

    public int getStartLag() {
        return -1 * ((EqTermDefault)this.allTerms.get(0)).getLagIndex();
    }

    public String getSymbolNameCoeff() {
        return ((EqTermDefault)this.allTerms.get(0)).getSymbolNameCoeff();
    }

    public String getSymbolNameLags() {
        if (this.lagsDef == null) {
            return null;
        }
        return this.lagsDef.name;
    }

    public String getSymbolNameSubsetRes() {
        return ((EqTermDefault)this.allTerms.get(0)).getSymbolNameSubsetRes();
    }

    public String getSymbolNameVariables() {
        return ((EqTermDefault)this.allTerms.get(0)).getSymbolNameVariables();
    }

    public JPopupMenu getTablePopup() {
        return this.tablePopup;
    }

    public boolean isEditable() {
        return ((EqTermDefault)this.allTerms.get(0)).isEditable();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.allTerms.get(0)) && evt.getPropertyName() == "visible") {
            this.setDataAvailable((Boolean)evt.getNewValue());
        }
    }

    public void setColumnWidth(int colWidth) {
        for (int i = 0; i < this.allTerms.size(); ++i) {
            ((EqTermDefault)this.allTerms.get(i)).setColumnWidth(colWidth);
        }
    }

    public void setEditable(boolean isEditable) {
        for (int i = 0; i < this.allTerms.size(); ++i) {
            ((EqTermDefault)this.allTerms.get(i)).setEditable(isEditable);
        }
    }

    @Override
    public void setLeadingSignVisible(boolean isVisible) {
        ((EqTermDefault)this.allTerms.get(0)).setLeadingSignVisible(isVisible);
    }

    @Override
    public void setSymbolScope(Scope scope) {
        super.setSymbolScope(scope);
        for (int i = 0; i < this.allTerms.size(); ++i) {
            this.allTerms.get(i).setSymbolScope(scope);
        }
        this.updateLagsSymbol();
    }

    public void setMouseListenerCoeff(MouseListener listener) {
        for (int i = 0; i < this.allTerms.size(); ++i) {
            ((EqTermDefault)this.allTerms.get(i)).setMouseListenerCoeff(listener);
        }
    }

    public void setPrecision(int precision) {
        for (int i = 0; i < this.allTerms.size(); ++i) {
            ((EqTermDefault)this.allTerms.get(i)).setPrecision(precision);
        }
    }

    public void setRendererCoeff(TableCellRenderer renderer) {
        for (int i = 0; i < this.allTerms.size(); ++i) {
            ((EqTermDefault)this.allTerms.get(i)).setRendererCoeff(renderer);
        }
    }

    public void setStartLag(int startLag) {
        if (startLag < 0) {
            throw new IllegalArgumentException("Start lag " + startLag + " < 0.");
        }
        ((EqTermDefault)this.allTerms.get(0)).setLagIndex(-1 * startLag);
    }

    public void setSymbolNameCoeff(String symbolName) {
        for (int i = 0; i < this.allTerms.size(); ++i) {
            ((EqTermDefault)this.allTerms.get(i)).setSymbolNameCoeff(symbolName);
        }
    }

    public void setSymbolNameLags(String newSymbolNameLags) {
        if (this.lagsSymbol != null) {
            this.lagsSymbol.removeSymbolListener(this);
        }
        if (newSymbolNameLags == null) {
            this.lagsDef = null;
            return;
        }
        this.lagsDef = new JSCTypeDef(newSymbolNameLags, JSCTypes.INT);
        this.updateLagsSymbol();
    }

    public void setSymbolNameSubsetRes(String symbolName) {
        for (int i = 0; i < this.allTerms.size(); ++i) {
            ((EqTermDefault)this.allTerms.get(i)).setSymbolNameSubsetRes(symbolName);
        }
    }

    public void setSymbolNameVariables(String symbolName) {
        for (int i = 0; i < this.allTerms.size(); ++i) {
            ((EqTermDefault)this.allTerms.get(i)).setSymbolNameVariables(symbolName);
        }
    }

    public void setTablePopup(JPopupMenu newTablePopup) {
        this.tablePopup = newTablePopup;
        for (int i = 0; i < this.allTerms.size(); ++i) {
            ((EqTermDefault)this.allTerms.get(i)).setTablePopup(this.tablePopup);
        }
    }

    private void updateLayout() {
        if (this.lagsSymbol == null) {
            return;
        }
        if (this.lagsSymbol.isEmpty()) {
            this.updateVisibility(-1);
            return;
        }
        int oldNumber = this.allTerms.size();
        int newNumber = this.lagsSymbol.getJSCInt().intVal();
        int startLag = this.getStartLag();
        if (oldNumber < (newNumber = newNumber - startLag + 1)) {
            String variableNames = this.getSymbolNameVariables();
            String coefficientNames = this.getSymbolNameCoeff();
            String subsetRestrictionsNames = this.getSymbolNameSubsetRes();
            int columnWidth = this.getColumnWidth();
            int precision = this.getPrecision();
            boolean editable = this.isEditable();
            MouseListener mouseListener = this.getMouseListenerCoeff();
            for (int i = oldNumber; i < newNumber; ++i) {
                EqTermDefault newEquationTerm = new EqTermDefault(i, -1 * (i + startLag));
                newEquationTerm.setSymbolNameCoeff(coefficientNames);
                newEquationTerm.setSymbolNameSubsetRes(subsetRestrictionsNames);
                newEquationTerm.setSymbolNameVariables(variableNames);
                newEquationTerm.setCoeffMatRequired(true);
                newEquationTerm.setOpaque(false);
                newEquationTerm.setColumnWidth(columnWidth);
                newEquationTerm.setPrecision(precision);
                newEquationTerm.setEditable(editable);
                newEquationTerm.setSymbolScope(this.getSymbolScope());
                newEquationTerm.setTablePopup(this.tablePopup);
                newEquationTerm.setMouseListenerCoeff(this.getMouseListenerCoeff());
                newEquationTerm.setRendererCoeff(this.getRendererCoeff());
                if (mouseListener != null) {
                    newEquationTerm.setMouseListenerCoeff(mouseListener);
                }
                if (this.addTermsToParent && this.equationPanelParent != null) {
                    int offset;
                    Component[] c = this.equationPanelParent.getComponents();
                    for (offset = 0; offset < c.length && !c[offset].equals(this); ++offset) {
                    }
                    int j = offset;
                    if (this.allTerms.size() > 1) {
                        ++j;
                        EqTerm lastTerm = this.allTerms.get(this.allTerms.size() - 1);
                        while (j < c.length && !c[j].equals(lastTerm)) {
                            ++j;
                        }
                    }
                    if (c.length <= ++j) {
                        j = -1;
                    }
                    this.equationPanelParent.add((Component)newEquationTerm, j);
                } else {
                    this.add(newEquationTerm);
                }
                this.allTerms.add(newEquationTerm);
            }
        }
        this.updateVisibility(newNumber);
    }

    private void updateVisibility(int arg) {
        int n = this.allTerms.size();
        boolean doNotRevalidate = true;
        for (int i = 0; i < n; ++i) {
            EqTerm et = this.allTerms.get(i);
            boolean wasVisible = et.isVisible();
            et.setVisible(i < arg);
            doNotRevalidate = doNotRevalidate && et.isVisible() == wasVisible;
        }
        if (!doNotRevalidate) {
            if (this.addTermsToParent) {
                if (this.equationPanelParent != null) {
                    this.equationPanelParent.revalidate();
                }
            } else {
                this.revalidate();
            }
        }
    }

    @Override
    public void valueChanged(SymbolEvent evt) {
        this.lagsSymbol = evt.getSource();
        this.updateLayout();
    }

    private void updateLagsSymbol() {
        SymbolTable sTable = this.getSymbolScope().getSymbolTable(this);
        if (sTable != null && this.lagsDef != null) {
            if (this.lagsSymbol != null) {
                this.lagsSymbol.removeSymbolListener(this);
            }
            this.lagsSymbol = sTable.get(this.lagsDef);
            this.lagsSymbol.addSymbolListener(this);
        }
        this.updateLayout();
    }
}

