/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.equation;

import com.jstatcom.equation.EqTerm;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public final class EqLayout
extends FlowLayout {
    protected int numberLHS = 0;
    private int indentRHS = 20;
    private JScrollPane enclosingScrollPane = null;

    public EqLayout() {
        super(0, 0, 5);
    }

    private void adjustScrollBar(JScrollBar scrollBar) {
        if (scrollBar == null) {
            return;
        }
        if (scrollBar.isVisible()) {
            int max = scrollBar.getMaximum();
            int visibleAmount = scrollBar.getVisibleAmount();
            scrollBar.setVisible(visibleAmount != max);
        }
    }

    private void centerComponents(Container target, int rowHeight, int rowStart, int rowEnd) {
        Point p = new Point();
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            p = m.getLocation(p);
            m.setLocation(p.x, p.y + (rowHeight - m.getHeight()) / 2);
        }
    }

    private void initializeScrollPaneListener(final Container target, JScrollPane scrollPane) {
        scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ((JComponent)target).revalidate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Component m;
            int membersTreated;
            boolean leadingSignVisible = false;
            Insets insets = target.getInsets();
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            int maxwidth = target.getWidth() - (insets.right + hgap);
            int nmembers = target.getComponentCount();
            int x = insets.left + hgap;
            int y = insets.top + vgap;
            int rowHeight = 0;
            for (int i = 0; i < Math.min(this.numberLHS, nmembers); ++i) {
                Component m2 = target.getComponent(i);
                if (!m2.isVisible()) continue;
                Dimension d2 = m2.getPreferredSize();
                m2.setSize(d2.width, d2.height);
                m2.setLocation(x, y);
                x += d2.width + hgap;
                rowHeight = Math.max(rowHeight, d2.height);
            }
            int indent = x;
            int i = membersTreated = Math.min(this.numberLHS, nmembers);
            while (i < nmembers) {
                m = target.getComponent(i);
                if (m.isVisible()) {
                    if (m instanceof EqTerm) {
                        ((EqTerm)m).setLeadingSignVisible(leadingSignVisible);
                        leadingSignVisible = true;
                    }
                    d = m.getPreferredSize();
                    if (x + d.width <= maxwidth) {
                        m.setSize(d.width, d.height);
                        m.setLocation(x, y);
                        x += d.width + hgap;
                        rowHeight = Math.max(rowHeight, d.height);
                    } else {
                        leadingSignVisible = membersTreated != this.numberLHS;
                        break;
                    }
                }
                ++i;
                ++membersTreated;
            }
            this.centerComponents(target, rowHeight, 0, membersTreated);
            if (membersTreated == this.numberLHS) {
                indent = this.indentRHS;
            }
            int firstItem = membersTreated;
            block5: while (membersTreated < nmembers) {
                firstItem = membersTreated;
                if (!(m = target.getComponent(membersTreated++)).isVisible()) continue;
                x = indent;
                y += rowHeight + vgap;
                rowHeight = 0;
                if (m instanceof EqTerm) {
                    ((EqTerm)m).setLeadingSignVisible(leadingSignVisible);
                    leadingSignVisible = true;
                }
                d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                m.setLocation(x, y);
                x += d.width;
                rowHeight = d.height;
                int i2 = membersTreated;
                while (i2 < nmembers) {
                    Component comp = target.getComponent(i2);
                    if (comp.isVisible()) {
                        if (comp instanceof EqTerm) {
                            ((EqTerm)comp).setLeadingSignVisible(true);
                        }
                        Dimension compPrefSize = comp.getPreferredSize();
                        if (x + hgap + compPrefSize.width <= maxwidth) {
                            comp.setSize(compPrefSize.width, compPrefSize.height);
                            comp.setLocation(hgap + x, y);
                            x += compPrefSize.width;
                            rowHeight = Math.max(rowHeight, compPrefSize.height);
                        } else {
                            membersTreated = i2;
                            this.centerComponents(target, rowHeight, firstItem, membersTreated);
                            continue block5;
                        }
                    }
                    ++i2;
                    ++membersTreated;
                }
            }
            this.centerComponents(target, rowHeight, firstItem, membersTreated);
            if (this.enclosingScrollPane != null && this.enclosingScrollPane.getVerticalScrollBarPolicy() == 20) {
                this.adjustScrollBar(this.enclosingScrollPane.getVerticalScrollBar());
            }
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        if (this.enclosingScrollPane == null) {
            for (Container parent = target.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof JScrollPane)) continue;
                this.enclosingScrollPane = (JScrollPane)parent;
                break;
            }
            if (this.enclosingScrollPane != null) {
                this.initializeScrollPaneListener(target, this.enclosingScrollPane);
            }
        }
        if (this.enclosingScrollPane == null) {
            return super.preferredLayoutSize(target);
        }
        Object object = target.getTreeLock();
        synchronized (object) {
            boolean leadingSignVisible = false;
            Dimension prefSize = this.preferredLayoutSizeLHS(target);
            int indent = prefSize.width;
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Dimension viewSize = this.enclosingScrollPane.getViewport().getSize();
            Point point = SwingUtilities.convertPoint(target, 0, 0, this.enclosingScrollPane.getViewport());
            Insets insets = target.getInsets();
            int maxWidth = viewSize.width - point.x - (insets.left + insets.right + hgap * 2);
            int nmembers = target.getComponentCount();
            int membersTreated = this.numberLHS;
            int i = this.numberLHS;
            while (i < nmembers) {
                Component comp = target.getComponent(i);
                if (comp.isVisible()) {
                    if (comp instanceof EqTerm) {
                        ((EqTerm)comp).setLeadingSignVisible(leadingSignVisible);
                        leadingSignVisible = true;
                    }
                    Dimension compPrefSize = comp.getPreferredSize();
                    if (prefSize.width + hgap + compPrefSize.width <= maxWidth) {
                        prefSize.width += hgap + compPrefSize.width;
                        prefSize.height = Math.max(prefSize.height, compPrefSize.height);
                    } else {
                        membersTreated = i;
                        leadingSignVisible = membersTreated != this.numberLHS;
                        break;
                    }
                }
                ++i;
                ++membersTreated;
            }
            if (indent == prefSize.width) {
                indent = this.indentRHS;
            }
            while (membersTreated < nmembers) {
                Component comp;
                if (!(comp = target.getComponent(membersTreated++)).isVisible()) continue;
                if (comp instanceof EqTerm) {
                    ((EqTerm)comp).setLeadingSignVisible(leadingSignVisible);
                    leadingSignVisible = true;
                }
                Dimension compPrefSize = comp.getPreferredSize();
                int rowWidth = indent + compPrefSize.width;
                int rowHeight = compPrefSize.height;
                int i2 = membersTreated;
                while (i2 < nmembers) {
                    comp = target.getComponent(i2);
                    if (comp.isVisible()) {
                        if (comp instanceof EqTerm) {
                            ((EqTerm)comp).setLeadingSignVisible(leadingSignVisible);
                        }
                        compPrefSize = comp.getPreferredSize();
                        if (rowWidth + hgap + compPrefSize.width <= maxWidth) {
                            rowWidth += hgap + compPrefSize.width;
                            rowHeight = Math.max(rowHeight, compPrefSize.height);
                        } else {
                            membersTreated = i2;
                            break;
                        }
                    }
                    ++i2;
                    ++membersTreated;
                }
                prefSize.height += vgap + rowHeight;
                prefSize.width = Math.max(prefSize.width, rowWidth);
            }
            prefSize.width += insets.left + insets.right + hgap * 2;
            prefSize.height += insets.top + insets.bottom + vgap * 2;
            return prefSize;
        }
    }

    private Dimension preferredLayoutSizeLHS(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = Math.min(this.numberLHS, target.getComponentCount());
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            dim.height = Math.max(dim.height, d.height);
            if (i > 0) {
                dim.width += this.getHgap();
            }
            dim.width += d.width;
        }
        return dim;
    }
}

