/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.stub;

import com.jstatcom.engine.CFunc;
import com.jstatcom.engine.CMalloc;
import com.jstatcom.engine.CPtr;
import com.jstatcom.engine.Engine;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.engine.LoadTypes;
import com.jstatcom.engine.stub.CSignTypes;
import com.jstatcom.engine.stub.StubLoadTypes;
import com.jstatcom.model.AbstractJSCData;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCInt;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCNumber;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.util.UMatrix;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class StubEngine
implements Engine {
    private final List<CPtr> pointerHolder = new ArrayList<CPtr>();
    private static StubEngine stub = null;
    private String systemLib = null;

    private StubEngine() {
    }

    public static StubEngine getInstance() {
        if (stub == null) {
            stub = new StubEngine();
        }
        return stub;
    }

    @Override
    public void call(String procName, JSCData[] args, JSCData[] retData) {
        if (this.systemLib == null) {
            throw new IllegalStateException("No system library was loaded.");
        }
        if (procName == null || procName.length() == 0) {
            throw new IllegalArgumentException("Procedure name was empty.");
        }
        if (args == null) {
            args = new JSCData[]{};
        }
        if (retData == null) {
            retData = new JSCData[]{};
        }
        if (retData.length > 1) {
            throw new IllegalArgumentException("Only one return parameter allowed for StubEngine (current:" + retData.length + ").");
        }
        CFunc funcPtr = null;
        try {
            funcPtr = new CFunc(this.systemLib, procName);
        }
        catch (Throwable e) {
            throw new RuntimeException("The adress of procedure\n\"" + procName + "\"\ncould not be found in library\n" + this.systemLib);
        }
        JSCTypes rtype = null;
        if (retData.length > 0) {
            if (retData[0] == null) {
                throw new IllegalArgumentException("Return argument is null.");
            }
            rtype = retData[0].type();
            if (!this.isValid(rtype)) {
                throw new IllegalArgumentException("Return type " + retData[0].type() + " cannot be handled by StubEngine.");
            }
        }
        Object[] argArray = this.prepareInputArgs(args);
        if (rtype == null) {
            funcPtr.callVoid(argArray);
        } else if (rtype == JSCTypes.NARRAY || rtype == JSCTypes.SARRAY) {
            CPtr rtnPtr = funcPtr.callCPtr(argArray);
            this.getDataFromPtr(new CPtr[]{rtnPtr}, retData);
        } else if (rtype == JSCTypes.INT) {
            int rtnInt = funcPtr.callInt(argArray);
            ((JSCInt)retData[0]).setVal(rtnInt);
        } else if (rtype == JSCTypes.NUMBER) {
            JSCNumber num = (JSCNumber)retData[0];
            double rtnDouble = 0.0;
            rtnDouble = Boolean.valueOf(num.getJSCProperty(CSignTypes.FLOAT) + "") != false ? funcPtr.callDouble(argArray) : (double)funcPtr.callFloat(argArray);
            num.setVal(rtnDouble);
        } else {
            throw new IllegalArgumentException("Return type " + rtype + " cannot be handled by StubEngine.");
        }
        this.getDataFromPtr(argArray, args);
        Iterator<CPtr> iter = this.pointerHolder.iterator();
        while (iter.hasNext()) {
            ((CMalloc)iter.next()).free();
        }
        this.pointerHolder.clear();
    }

    private Object[] prepareInputArgs(JSCData[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (args.length == 0) {
            return new Object[0];
        }
        Object[] oArray = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                throw new IllegalArgumentException("Argument at array position [" + i + "] is null.");
            }
            JSCTypes type = args[i].type();
            if (!this.isValid(type)) {
                throw new IllegalArgumentException("Argument " + args[i].type() + " at array position [" + i + "] cannot be handled by StubEngine.");
            }
            if (type == JSCTypes.STRING) {
                if (args[i].isEmpty()) {
                    throw new IllegalArgumentException("Argument " + args[i].name() + " at array position [" + i + "] is empty.");
                }
                oArray[i] = args[i].value();
                continue;
            }
            if (type == JSCTypes.INT) {
                if (!Boolean.valueOf(args[i].getJSCProperty(CSignTypes.BYREF) + "").booleanValue()) {
                    if (args[i].isEmpty()) {
                        throw new IllegalArgumentException("Argument " + args[i].name() + " at array position [" + i + "] is empty.");
                    }
                    oArray[i] = args[i].value();
                    continue;
                }
                CMalloc refPtr = new CMalloc(4);
                this.pointerHolder.add(refPtr);
                if (!args[i].isEmpty()) {
                    refPtr.setInt(0, ((JSCInt)args[i]).intVal());
                }
                oArray[i] = refPtr;
                continue;
            }
            if (type == JSCTypes.NUMBER) {
                JSCNumber num = (JSCNumber)args[i];
                if (!Boolean.valueOf(args[i].getJSCProperty(CSignTypes.BYREF) + "").booleanValue()) {
                    if (args[i].isEmpty()) {
                        throw new IllegalArgumentException("Argument " + args[i].name() + " at array position [" + i + "] is empty.");
                    }
                    Object toSet = args[i].value();
                    if (Boolean.valueOf(num.getJSCProperty(CSignTypes.FLOAT) + "").booleanValue()) {
                        toSet = new Float(num.doubleVal());
                    }
                    oArray[i] = toSet;
                    continue;
                }
                CMalloc refPtr = null;
                new CMalloc(8);
                if (!args[i].isEmpty()) {
                    if (Boolean.valueOf(num.getJSCProperty(CSignTypes.FLOAT) + "").booleanValue()) {
                        refPtr = new CMalloc(4);
                        refPtr.setFloat(0, num.getNumber().floatValue());
                    } else {
                        refPtr = new CMalloc(8);
                        refPtr.setDouble(0, num.doubleVal());
                    }
                }
                this.pointerHolder.add(refPtr);
                oArray[i] = refPtr;
                continue;
            }
            if (type == JSCTypes.NARRAY) {
                JSCNArray nArray = (JSCNArray)args[i];
                if (Boolean.valueOf(nArray.getJSCProperty(CSignTypes.VECTOR) + "").booleanValue()) {
                    oArray[i] = this.getNArrayVecPtr(nArray);
                    continue;
                }
                oArray[i] = this.getNArrayPtr(nArray);
                continue;
            }
            if (type == JSCTypes.SARRAY) {
                JSCSArray sArray = (JSCSArray)args[i];
                if (Boolean.valueOf(sArray.getJSCProperty(CSignTypes.VECTOR) + "").booleanValue()) {
                    oArray[i] = this.getStringVecPtr(sArray);
                    continue;
                }
                oArray[i] = this.getStringArrayPtr(sArray);
                continue;
            }
            throw new RuntimeException("Unsupported type " + type + ". Code should not be reached.");
        }
        return oArray;
    }

    private CPtr getNArrayPtr(JSCNArray nArray) {
        CMalloc argPtr = new CMalloc(CPtr.SIZE * nArray.rows());
        CMalloc[] argsi = new CMalloc[nArray.rows()];
        this.pointerHolder.add(argPtr);
        if (!Boolean.valueOf(nArray.getJSCProperty(CSignTypes.FLOAT) + "").booleanValue()) {
            double[][] values = nArray.doubleArray();
            this.pointerHolder.add(argPtr);
            for (int j = 0; j < nArray.rows(); ++j) {
                argsi[j] = new CMalloc(8 * nArray.cols());
                this.pointerHolder.add(argsi[j]);
                argsi[j].copyIn(0, values[j], 0, nArray.cols());
                argPtr.setCPtr(j * CPtr.SIZE, argsi[j]);
            }
        } else {
            float[][] values = new float[nArray.rows()][nArray.cols()];
            for (int i = 0; i < nArray.rows(); ++i) {
                for (int j = 0; j < nArray.cols(); ++j) {
                    values[i][j] = (float)nArray.doubleAt(i, j);
                }
            }
            this.pointerHolder.add(argPtr);
            for (int j = 0; j < nArray.rows(); ++j) {
                argsi[j] = new CMalloc(4 * nArray.cols());
                this.pointerHolder.add(argsi[j]);
                argsi[j].copyIn(0, values[j], 0, nArray.cols());
                argPtr.setCPtr(j * CPtr.SIZE, argsi[j]);
            }
        }
        return argPtr;
    }

    private CPtr getNArrayVecPtr(JSCNArray nArray) {
        CMalloc argPtr = null;
        if (!Boolean.valueOf(nArray.getJSCProperty(CSignTypes.FLOAT) + "").booleanValue()) {
            double[] values = UMatrix.vec(nArray.doubleArray());
            argPtr = new CMalloc(8 * values.length);
            this.pointerHolder.add(argPtr);
            argPtr.copyIn(0, values, 0, values.length);
        } else {
            float[] values = new float[nArray.rows() * nArray.cols()];
            int index = 0;
            for (int i = 0; i < nArray.rows(); ++i) {
                for (int j = 0; j < nArray.cols(); ++j) {
                    values[index++] = (float)nArray.doubleAt(i, j);
                }
            }
            argPtr = new CMalloc(4 * values.length);
            this.pointerHolder.add(argPtr);
            argPtr.copyIn(0, values, 0, values.length);
        }
        return argPtr;
    }

    private CPtr getStringArrayPtr(JSCSArray sArray) {
        CMalloc argPtr = new CMalloc(CPtr.SIZE * sArray.rows());
        this.pointerHolder.add(argPtr);
        for (int j = 0; j < sArray.rows(); ++j) {
            CMalloc argPtri = new CMalloc(CPtr.SIZE * sArray.cols());
            this.pointerHolder.add(argPtri);
            CMalloc[] argsi = new CMalloc[sArray.cols()];
            for (int k = 0; k < sArray.cols(); ++k) {
                String el = sArray.stringAt(j, k);
                if (el == null) {
                    throw new IllegalArgumentException("Argument " + sArray.name() + " contains null element at index [" + j + "," + k + "].");
                }
                argsi[k] = new CMalloc(el.length() + 1);
                argsi[k].setString(0, el);
                argPtri.setCPtr(k * CPtr.SIZE, argsi[k]);
                this.pointerHolder.add(argsi[k]);
            }
            argPtr.setCPtr(CPtr.SIZE * j, argPtri);
        }
        return argPtr;
    }

    private CPtr getStringVecPtr(JSCSArray sArray) {
        String[] values = new String[sArray.rows() * sArray.cols()];
        int index = 0;
        for (int j = 0; j < sArray.cols(); ++j) {
            for (int k = 0; k < sArray.rows(); ++k) {
                String el = sArray.stringAt(k, j);
                if (el == null) {
                    throw new IllegalArgumentException("Argument " + sArray.name() + " contains null element at index [" + k + "," + j + "].");
                }
                values[index++] = el;
            }
        }
        CMalloc argPtr = new CMalloc(CPtr.SIZE * values.length);
        this.pointerHolder.add(argPtr);
        CMalloc[] argsi = new CMalloc[values.length];
        for (int j = 0; j < values.length; ++j) {
            argsi[j] = new CMalloc(values[j].length() + 1);
            this.pointerHolder.add(argsi[j]);
            argsi[j].setString(0, values[j]);
            argPtr.setCPtr(CPtr.SIZE * j, argsi[j]);
        }
        return argPtr;
    }

    private void getDataFromPtr(Object[] args, JSCData[] rtns) {
        if (args == null || rtns == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (args.length != rtns.length) {
            throw new IllegalArgumentException("Array lengths do not match.");
        }
        for (int i = 0; i < args.length; ++i) {
            AbstractJSCData num;
            if (!(args[i] instanceof CPtr)) continue;
            if (rtns[i] == null) {
                throw new RuntimeException("Argument at index " + i + " was null.");
            }
            JSCTypes type = rtns[i].type();
            CPtr ptr = (CPtr)args[i];
            if (type == JSCTypes.NARRAY) {
                JSCNArray nArray = (JSCNArray)rtns[i];
                this.setNArrayFromPtr(nArray, ptr);
                continue;
            }
            if (type == JSCTypes.SARRAY) {
                CPtr ptri;
                int k;
                int j;
                JSCSArray sArray = (JSCSArray)rtns[i];
                String[][] vals = new String[sArray.rows()][sArray.cols()];
                if (Boolean.valueOf(sArray.getJSCProperty(CSignTypes.VECTOR) + "").booleanValue()) {
                    int index = 0;
                    for (j = 0; j < sArray.cols(); ++j) {
                        for (k = 0; k < sArray.rows(); ++k) {
                            ptri = ptr.getCPtr(CPtr.SIZE * index++);
                            vals[k][j] = ptri.getString(0);
                        }
                    }
                } else {
                    for (j = 0; j < sArray.rows(); ++j) {
                        CPtr ptrRow = ptr.getCPtr(CPtr.SIZE * j);
                        for (k = 0; k < sArray.cols(); ++k) {
                            ptri = ptrRow.getCPtr(CPtr.SIZE * k);
                            vals[j][k] = ptri.getString(0);
                        }
                    }
                }
                sArray.setVal(vals);
                continue;
            }
            if (type == JSCTypes.STRING) {
                ((JSCString)rtns[i]).setVal(ptr.getString(0));
                continue;
            }
            if (type == JSCTypes.INT && Boolean.valueOf(rtns[i].getJSCProperty(CSignTypes.BYREF) + "").booleanValue()) {
                num = (JSCInt)rtns[i];
                ((JSCInt)num).setVal(ptr.getInt(0));
                continue;
            }
            if (type == JSCTypes.NUMBER && Boolean.valueOf(rtns[i].getJSCProperty(CSignTypes.BYREF) + "").booleanValue()) {
                num = (JSCNumber)rtns[i];
                if (Boolean.valueOf(rtns[i].getJSCProperty(CSignTypes.FLOAT) + "").booleanValue()) {
                    ((JSCNumber)num).setVal(ptr.getFloat(0));
                    continue;
                }
                ((JSCNumber)num).setVal(ptr.getDouble(0));
                continue;
            }
            throw new RuntimeException("Argument type " + type + " at index " + i + " does not correspond to pointer.");
        }
    }

    private void setNArrayFromPtr(JSCNArray nArray, CPtr ptr) {
        double[][] vals = new double[nArray.rows()][nArray.cols()];
        if (!Boolean.valueOf(nArray.getJSCProperty(CSignTypes.FLOAT) + "").booleanValue()) {
            if (Boolean.valueOf(nArray.getJSCProperty(CSignTypes.VECTOR) + "").booleanValue()) {
                double[] values = new double[nArray.rows() * nArray.cols()];
                ptr.copyOut(0, values, 0, values.length);
                int index = 0;
                for (int j = 0; j < nArray.rows(); ++j) {
                    for (int k = 0; k < nArray.cols(); ++k) {
                        vals[j][k] = values[index++];
                    }
                }
            } else {
                for (int j = 0; j < nArray.rows(); ++j) {
                    ptr.getCPtr(j * CPtr.SIZE).copyOut(0, vals[j], 0, nArray.cols());
                }
            }
        } else if (Boolean.valueOf(nArray.getJSCProperty(CSignTypes.VECTOR) + "").booleanValue()) {
            float[] values = new float[nArray.rows() * nArray.cols()];
            ptr.copyOut(0, values, 0, values.length);
            int index = 0;
            for (int j = 0; j < nArray.rows(); ++j) {
                for (int k = 0; k < nArray.cols(); ++k) {
                    vals[j][k] = values[index++];
                }
            }
        } else {
            int j;
            float[][] fvals = new float[nArray.rows()][nArray.cols()];
            for (j = 0; j < nArray.rows(); ++j) {
                ptr.getCPtr(j * CPtr.SIZE).copyOut(0, fvals[j], 0, nArray.cols());
            }
            for (j = 0; j < nArray.rows(); ++j) {
                for (int k = 0; k < nArray.cols(); ++k) {
                    vals[j][k] = fvals[j][k];
                }
            }
        }
        nArray.setVal(vals);
    }

    @Override
    public boolean isValid(JSCTypes type) {
        return type == JSCTypes.NARRAY || type == JSCTypes.NUMBER || type == JSCTypes.INT || type == JSCTypes.SARRAY || type == JSCTypes.STRING;
    }

    @Override
    public void load(String module, LoadTypes loadType, JSCData ... args) {
        if (module == null || loadType == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (module.length() == 0) {
            throw new IllegalArgumentException("Library name was empty.");
        }
        String osName = System.getProperty("os.name").toUpperCase();
        String sysExt = null;
        if (osName.indexOf("WIN") > -1) {
            sysExt = ".dll";
        } else if (osName.indexOf("SUNOS") > -1 || osName.indexOf("SOLARIS") > -1 || osName.indexOf("LINUX") > -1) {
            sysExt = ".so";
        } else {
            throw new RuntimeException("Operating system " + System.getProperty("os.name") + " is not supported by StubEngine.");
        }
        if (loadType == StubLoadTypes.USERLIB) {
            File f = new File(EngineTypes.STUB.DIR_NAME + File.separator + module + sysExt);
            if (!f.isFile()) {
                throw new RuntimeException("The system library " + f.getAbsolutePath() + " does not exist.");
            }
            this.systemLib = f.getAbsolutePath();
        }
        if (loadType == StubLoadTypes.SYSLIB) {
            this.systemLib = module;
        }
    }

    public String getCurrentSysLib() {
        return this.systemLib;
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException(this.toString() + " tasks cannot be stopped.");
    }

    @Override
    public void shutdown() {
    }
}

