/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.ox;

import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.Engine;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.engine.LoadTypes;
import com.jstatcom.engine.SysRun;
import com.jstatcom.engine.ox.OxConfigKeys;
import com.jstatcom.engine.ox.OxLoadTypes;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCTypes;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class OxEngine
implements Engine {
    private static final Logger log = Logger.getLogger(OxEngine.class);
    private static OxEngine ox = null;
    private boolean EXIT_STATUS = true;
    private List<String> loadedModules = new ArrayList<String>();

    public static OxEngine getInstance() {
        if (ox == null) {
            ox = new OxEngine();
        }
        return ox;
    }

    private OxEngine() {
        String dllLocation = ConfigHolder.valueOf(EngineTypes.OX).getConfig(OxConfigKeys.OXDLL);
        File f = new File(dllLocation);
        if (!f.isFile()) {
            throw new RuntimeException("The system library " + f.getAbsolutePath() + " does not exist.");
        }
        System.load(f.getAbsolutePath());
        String oxjavadll = EngineTypes.OX.DIR_NAME + File.separator + System.mapLibraryName("jox");
        f = new File(oxjavadll);
        if (!f.isFile()) {
            throw new RuntimeException("The system library " + f.getAbsolutePath() + " does not exist.");
        }
        System.load(f.getAbsolutePath());
        this.joxInitEx();
    }

    @Override
    public void call(String procName, JSCData[] args, JSCData[] retData) {
        if (procName == null || procName.length() == 0) {
            throw new IllegalArgumentException("Procedure name was empty.");
        }
        if (retData == null) {
            retData = new JSCData[]{};
        }
        this.checkArgs(retData, false);
        this.checkArgs(args, true);
        if (JSCConstants.DEBUG) {
            StringBuffer msg = new StringBuffer();
            msg.append("procedure: " + procName + "\n");
            msg.append("arguments:\n");
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    msg.append("arg_" + (i + 1) + ": " + args[i] + "\n");
                }
            } else {
                msg.append("none\n");
            }
            log.info((Object)msg);
        }
        this.joxCallMemberEx(procName, args, retData);
    }

    @Override
    public boolean isValid(JSCTypes type) {
        return type == JSCTypes.NARRAY || type == JSCTypes.NUMBER || type == JSCTypes.INT || type == JSCTypes.SARRAY || type == JSCTypes.STRING;
    }

    @Override
    public void load(String loadName, LoadTypes loadType, JSCData ... args) {
        if (loadName == null || loadType == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (loadName.length() == 0) {
            throw new IllegalArgumentException("Module name was empty.");
        }
        if (loadType == OxLoadTypes.VIEWER) {
            String command = ConfigHolder.valueOf(EngineTypes.OX).getConfig(OxConfigKeys.GRAPH_VIEWER);
            File f = new File(loadName);
            if (!f.isFile()) {
                throw new RuntimeException("The file " + f.getAbsolutePath() + " does not exist.");
            }
            log.debug((Object)("Invoking: " + command + " " + f.getAbsolutePath()));
            SysRun.invoke(command, f.getAbsolutePath());
            return;
        }
        if (loadType == OxLoadTypes.OXO) {
            File f;
            String checker;
            if (this.EXIT_STATUS) {
                this.EXIT_STATUS = false;
                this.joxInitEx();
            }
            if (this.loadedModules.contains(checker = loadName.toUpperCase())) {
                return;
            }
            this.loadedModules.add(checker);
            String oxSuffix = ".oxo";
            String otherSuffix = ".ox";
            if (JSCConstants.DEBUG) {
                oxSuffix = ".ox";
                otherSuffix = ".oxo";
            }
            if (!(f = new File(EngineTypes.OX.DIR_NAME + File.separator + loadName + oxSuffix)).isFile() && !(f = new File(EngineTypes.OX.DIR_NAME + File.separator + loadName + otherSuffix)).isFile()) {
                throw new RuntimeException("The OX resource " + f.getAbsolutePath() + " does not exist.");
            }
            log.debug((Object)("load: " + f.getAbsolutePath()));
            this.joxSetModuleEx(f.getAbsolutePath());
            return;
        }
        if (loadType == OxLoadTypes.CLASS) {
            this.checkArgs(args, true);
            if (log.isDebugEnabled()) {
                StringBuffer msg = new StringBuffer();
                msg.append("class: " + loadName + "\n");
                msg.append("arguments:\n");
                if (args != null && args.length > 0) {
                    for (int i = 0; i < args.length; ++i) {
                        msg.append("arg_" + (i + 1) + ": " + args[i] + "\n");
                    }
                } else {
                    msg.append("none\n");
                }
                log.debug((Object)msg);
            }
            this.joxCreateObjectEx(loadName, args);
            return;
        }
    }

    private void checkArgs(JSCData[] args, boolean checkEmpty) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                throw new IllegalArgumentException("Argument array contains null element at position [" + i + "].");
            }
            if (!this.isValid(args[i].type())) {
                throw new IllegalArgumentException("Type " + args[i].type() + " of argument at position [" + i + "] is not supported by OxEngine.");
            }
            if (!checkEmpty || !args[i].isEmpty()) continue;
            throw new IllegalArgumentException("Argument at position [" + i + "] is empty.");
        }
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException(this.toString() + " tasks cannot be stopped.");
    }

    @Override
    public void shutdown() {
        this.joxExitEx();
        this.EXIT_STATUS = true;
        this.loadedModules.clear();
    }

    private native void joxCallMemberEx(String var1, JSCData[] var2, JSCData[] var3);

    private native void joxCreateObjectEx(String var1, JSCData[] var2);

    private native void joxSetModuleEx(String var1);

    private native void joxInitEx();

    private native void joxExitEx();
}

