/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.matlab;

import com.jstatcom.engine.ConfigKeys;

public abstract class MatlabConfigKeys
extends ConfigKeys {
    public static final MatlabConfigKeys DLL_NAME = new MatlabConfigKeys("DLL_NAME"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be null.";
            }
            return null;
        }

        @Override
        public String defaultVal() {
            return "mclmcrrt72";
        }
    };
    public static final MatlabConfigKeys RUNTIME_SUBDIR = new MatlabConfigKeys("RUNTIME_SUBDIR"){

        @Override
        public String isValid(String value) {
            return null;
        }

        @Override
        public String defaultVal() {
            return "MATLAB Component Runtime\\v72\\runtime\\win32";
        }
    };
    public static final MatlabConfigKeys SHARED_MEM_SIZE = new MatlabConfigKeys("SHARED_MEM_SIZE"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be null.";
            }
            int number = 0;
            int lowerBound = 1000;
            int upperBound = 1000000000;
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException nEx) {
                return "SHARED_MEM_SIZE value \"" + value + "\" is not a valid integer number.";
            }
            if (number < lowerBound || number > upperBound) {
                return "SHARED_MEM_SIZE value \"" + value + "\" is not in the valid range of [" + lowerBound + ";" + upperBound + "].\nA reasonable default value is " + this.defaultVal() + ".";
            }
            return null;
        }

        @Override
        public String defaultVal() {
            return "10000000";
        }
    };
    public static final MatlabConfigKeys MATLAB_COMPILER_VERSION = new MatlabConfigKeys("MATLAB_COMPILER_VERSION"){

        @Override
        public String isValid(String value) {
            return null;
        }

        @Override
        public String defaultVal() {
            return "4.0";
        }
    };

    MatlabConfigKeys(String name) {
        super(name);
    }
}

