/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.grte;

import com.aptech.gaussApi5_0.Gauss;
import com.aptech.gaussApi5_0.GaussLibrary;
import com.aptech.gaussApi5_0.GaussMatrix;
import com.aptech.gaussApi5_0.GaussReader;
import com.aptech.gaussApi5_0.GaussStringArray;
import com.aptech.gaussApi5_0.GaussWorkspace;
import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.Engine;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.engine.LoadTypes;
import com.jstatcom.engine.grte.GRTEConfigKeys;
import com.jstatcom.engine.grte.GRTELoadTypes;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCInt;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCNumber;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.model.JSCTypes;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Date;
import org.apache.log4j.Logger;

public final class GRTEngine
implements Engine {
    private static final Logger log = Logger.getLogger(GRTEngine.class);
    private String workSpaceName = null;
    private GaussWorkspace wk = null;
    private static ConfigHolder cf = null;
    private static GRTEngine grte = null;
    private File graphicsDir = null;

    public GRTEngine() {
        this.init();
    }

    private void init() {
        if (this.wk != null && !this.wk.hasBeenDisposed()) {
            return;
        }
        if (cf == null) {
            cf = ConfigHolder.valueOf(EngineTypes.GRTE);
        }
        if (!GaussLibrary.isLoaded()) {
            GaussLibrary.setName(cf.getConfig(GRTEConfigKeys.GAUSSAPI_SYSLIBNAME));
            Gauss.setHome(EngineTypes.GRTE.DIR_NAME);
        }
        if (this.workSpaceName == null) {
            this.workSpaceName = "JGRTE_" + new Date().toString();
        }
        this.wk = new GaussWorkspace(this.workSpaceName);
        GaussWorkspace.setGaussReader(new GaussReader(new StringReader("a")));
        GaussWorkspace.addOutputWriter(new PrintWriter(System.out));
        GaussWorkspace.addErrorWriter(new PrintWriter(System.out));
        String gcgFile = EngineTypes.GRTE.DIR_NAME + File.separator + cf.getConfig(GRTEConfigKeys.GCG_FILENAME);
        this.wk.load(new File(gcgFile));
        if (!Boolean.valueOf(cf.getConfig(GRTEConfigKeys.DO_JGRTE_INIT)).booleanValue()) {
            return;
        }
        String graphicsPath = cf.getConfig(GRTEConfigKeys.GRAPHICS_DIR);
        if (graphicsPath == null || graphicsPath.length() == 0) {
            graphicsPath = GRTEConfigKeys.GRAPHICS_DIR.defaultVal();
        }
        String error = null;
        error = GRTEConfigKeys.GRAPHICS_DIR.isValid(graphicsPath);
        if (error != null) {
            throw new RuntimeException(error);
        }
        try {
            this.graphicsDir = File.createTempFile("jst", "", new File(graphicsPath));
            String tmpDir = this.graphicsDir.getAbsolutePath();
            this.graphicsDir = new File(tmpDir);
            this.graphicsDir.delete();
            this.graphicsDir.mkdir();
        }
        catch (IOException e) {
            throw new RuntimeException("Graphics directory " + this.graphicsDir + " could not be created.");
        }
        if (this.wk.getSymbolType("initJGRTE") == 8) {
            this.wk.call("initJGRTE", new Object[]{this.graphicsDir + File.separator, "jgrte.tkf", EngineTypes.GRTE.DIR_NAME});
        }
    }

    @Override
    public void call(String procName, JSCData[] args, JSCData[] retData) {
        int i;
        this.init();
        if (procName == null || procName.length() == 0) {
            throw new IllegalArgumentException("Procedure name was empty.");
        }
        if (this.wk.getSymbolType(procName) != 8) {
            throw new IllegalArgumentException("Procedure " + procName + " is unknown.");
        }
        if (args == null) {
            args = new JSCData[]{};
        }
        if (retData == null) {
            retData = new JSCData[]{};
        }
        Object[] gaussArgs = new Object[args.length];
        for (i = 0; i < gaussArgs.length; ++i) {
            if (args[i] == null) {
                throw new IllegalArgumentException("Argument at array position [" + i + "] is null.");
            }
            if (!this.isValid(args[i].type())) {
                throw new IllegalArgumentException("Argument " + args[i].type() + " at array position [" + i + "] cannot be handled by GRTE.");
            }
            gaussArgs[i] = this.getGaussEngineObject(args[i]);
        }
        for (i = 0; i < retData.length; ++i) {
            if (retData[i] == null) {
                throw new IllegalArgumentException("Return at array position [" + i + "] is null.");
            }
            if (this.isValid(retData[i].type())) continue;
            throw new IllegalArgumentException("Return type " + retData[i].type() + " at array position [" + i + "] cannot be handled by GRTE.");
        }
        Object[] rtnArgs = null;
        try {
            rtnArgs = this.wk.call(procName, gaussArgs);
        }
        catch (Throwable ex) {
            StringBuffer msg = new StringBuffer();
            msg.append("Gauss procedure: \"" + procName + "\"\n");
            msg.append(ex.getMessage());
            throw new RuntimeException(msg.toString());
        }
        if (log.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("procedure: \"" + procName + "\"\n");
            msg.append("arguments:\n");
            if (gaussArgs != null && args.length > 0) {
                for (int i2 = 0; i2 < args.length; ++i2) {
                    msg.append("arg_" + (i2 + 1) + ": " + args[i2] + "\n");
                }
            } else {
                msg.append("none\n");
            }
            log.debug((Object)msg);
        }
        if (rtnArgs != null && rtnArgs.length != retData.length) {
            throw new IllegalArgumentException("Error calling procedure: \"" + procName + "\":\n" + "Specified number of returns (" + retData.length + ") is different from actual number (" + rtnArgs.length + ").");
        }
        this.setJSCDataFromGaussData(rtnArgs, retData);
    }

    private Object getGaussEngineObject(JSCData arg) {
        if (arg.isEmpty()) {
            return new GaussMatrix(new double[0][0]);
        }
        JSCTypes type = arg.type();
        if (type == JSCTypes.NARRAY) {
            return new GaussMatrix(((JSCNArray)arg).doubleArray());
        }
        if (type == JSCTypes.NUMBER) {
            return new GaussMatrix(((JSCNumber)arg).doubleVal());
        }
        if (type == JSCTypes.INT) {
            return new GaussMatrix(((JSCInt)arg).doubleVal());
        }
        if (type == JSCTypes.SARRAY) {
            GaussStringArray gsa = new GaussStringArray(((JSCSArray)arg).stringArray());
            return gsa;
        }
        if (type == JSCTypes.STRING) {
            return ((JSCString)arg).string();
        }
        throw new IllegalArgumentException(type + " is not recognized.");
    }

    private void setJSCDataFromGaussData(Object[] gaussData, JSCData[] jscData) {
        if (gaussData == null || jscData == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        if (gaussData.length != jscData.length) {
            throw new IllegalArgumentException("Array lengths do not match.");
        }
        for (int i = 0; i < gaussData.length; ++i) {
            if (gaussData[i] == null || jscData[i] == null) {
                throw new IllegalArgumentException("Return at array index [" + i + "] was null.");
            }
            JSCTypes type = jscData[i].type();
            if (gaussData[i] instanceof String) {
                if (type != JSCTypes.STRING && type != JSCTypes.SARRAY) {
                    throw new IllegalArgumentException("Specified return type " + type + " at array position [" + i + "] does not match with actual return type " + JSCTypes.STRING + "/" + JSCTypes.SARRAY + ".");
                }
                if (type == JSCTypes.STRING) {
                    ((JSCString)jscData[i]).setVal(gaussData[i].toString());
                    continue;
                }
                ((JSCSArray)jscData[i]).setVal(new String[][]{{gaussData[i].toString()}});
                continue;
            }
            if (gaussData[i] instanceof GaussMatrix) {
                GaussMatrix gMat = (GaussMatrix)gaussData[i];
                if (gMat.getCols() == 0 || gMat.getRows() == 0 || Double.isNaN(gMat.getReal(0, 0)) && gMat.getCols() == 1 && gMat.getRows() == 1) {
                    jscData[i].clear();
                    continue;
                }
                if (gMat.getCols() > 1 || gMat.getRows() > 1) {
                    if (type != JSCTypes.NARRAY) {
                        throw new IllegalArgumentException("Specified return type " + type + " at array position [" + i + "] does not match with actual return type " + JSCTypes.NARRAY + ".");
                    }
                    ((JSCNArray)jscData[i]).setVal(gMat.getReals());
                    continue;
                }
                if (type != JSCTypes.NUMBER && type != JSCTypes.NARRAY && type != JSCTypes.INT) {
                    throw new IllegalArgumentException("Specified return type " + type + " at array position [" + i + "] does not match with actual return type " + JSCTypes.NARRAY + "/" + JSCTypes.NUMBER + "/" + JSCTypes.INT + ".");
                }
                if (type == JSCTypes.NARRAY) {
                    ((JSCNArray)jscData[i]).setVal(gMat.getReals());
                    continue;
                }
                if (type == JSCTypes.NUMBER) {
                    ((JSCNumber)jscData[i]).setVal(gMat.getReal(0, 0));
                    continue;
                }
                ((JSCInt)jscData[i]).setVal(new Double(gMat.getReal(0, 0)).intValue());
                continue;
            }
            if (gaussData[i] instanceof GaussStringArray) {
                GaussStringArray gSArray = (GaussStringArray)gaussData[i];
                if (gSArray.getCols() == 0 || gSArray.getRows() == 0) {
                    jscData[i].clear();
                    continue;
                }
                if (gSArray.getCols() > 1 || gSArray.getRows() > 1) {
                    if (type != JSCTypes.SARRAY) {
                        throw new IllegalArgumentException("Specified return type " + type + " at array position [" + i + "] does not match with actual return type " + JSCTypes.SARRAY + ".");
                    }
                    ((JSCSArray)jscData[i]).setVal(gSArray.getStrings());
                    continue;
                }
                if (type != JSCTypes.SARRAY && type != JSCTypes.STRING) {
                    throw new IllegalArgumentException("Specified return type " + type + " at array position [" + i + "] does not match with actual return type " + JSCTypes.SARRAY + "/" + JSCTypes.STRING + ".");
                }
                if (type == JSCTypes.SARRAY) {
                    ((JSCSArray)jscData[i]).setVal(gSArray.getStrings());
                    continue;
                }
                ((JSCString)jscData[i]).setVal(gSArray.getString(0, 0));
                continue;
            }
            throw new RuntimeException("Unknown GRTE return argument at position [" + i + "]: " + gaussData[i]);
        }
    }

    public static GRTEngine getInstance() {
        if (grte == null) {
            grte = new GRTEngine();
        } else {
            grte.init();
        }
        return grte;
    }

    @Override
    public boolean isValid(JSCTypes type) {
        return type == JSCTypes.NARRAY || type == JSCTypes.NUMBER || type == JSCTypes.INT || type == JSCTypes.SARRAY || type == JSCTypes.STRING;
    }

    @Override
    public void load(String loadName, LoadTypes loadType, JSCData ... args) {
        if (loadName == null || loadType == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (loadName.length() == 0) {
            throw new IllegalArgumentException("Module name was empty.");
        }
        this.init();
        if (loadType == GRTELoadTypes.GCG) {
            log.debug((Object)("\nload " + loadType + ": " + loadName + "\n"));
            this.loadGCG(loadName);
        }
        if (loadType == GRTELoadTypes.GLOBAL) {
            if (args == null) {
                throw new IllegalArgumentException("Global symbol agument missing.");
            }
            if (args.length != 1) {
                throw new IllegalArgumentException("Global symbol agument length was " + args.length + " instead of 1.");
            }
            JSCConstants.checkNameThrowEx(loadName);
            this.wk.getGlobal(loadName);
            this.wk.setGlobal(loadName, this.getGaussEngineObject(args[0]));
            log.debug((Object)("\nload " + loadType + ": " + loadName));
            log.debug((Object)("argument: " + args[0]));
        }
    }

    private void loadGCG(String toLoad) {
        String loadName = EngineTypes.GRTE.DIR_NAME + "/" + toLoad.trim();
        File gcgFile = new File(loadName);
        if (!gcgFile.isFile()) {
            throw new RuntimeException("File " + gcgFile.getAbsolutePath() + " does not exist.");
        }
        if (this.wk == null) {
            throw new IllegalStateException("GaussWorkspace is null.");
        }
        this.wk.load(gcgFile);
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException(this.toString() + " tasks cannot be stopped.");
    }

    @Override
    public void shutdown() {
        if (this.graphicsDir != null && this.graphicsDir.isDirectory()) {
            File[] tmpFiles = this.graphicsDir.listFiles();
            for (int i = 0; i < tmpFiles.length; ++i) {
                tmpFiles[i].delete();
            }
            this.graphicsDir.delete();
        }
        if (this.wk.getSymbolType("shutdownJGRTE") == 8) {
            this.wk.execute("shutdownJGRTE");
        }
        this.wk.clear();
        Gauss.shutdown();
        this.workSpaceName = null;
    }

    public GaussWorkspace getGaussWorkSpace() {
        return this.wk;
    }

    public GaussWorkspace getWk() {
        return this.wk;
    }
}

