/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.grte;

import com.jstatcom.engine.ConfigKeys;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.model.JSCConstants;
import java.io.File;
import java.io.IOException;

public abstract class GRTEConfigKeys
extends ConfigKeys {
    public static final GRTEConfigKeys DO_JGRTE_INIT = new GRTEConfigKeys("DO_JGRTE_INIT"){

        @Override
        public String isValid(String value) {
            return null;
        }

        @Override
        public String defaultVal() {
            return "true";
        }
    };
    public static final GRTEConfigKeys GAUSSAPI_SYSLIBNAME = new GRTEConfigKeys("GAUSSAPI_SYSLIBNAME"){

        @Override
        public String isValid(String value) {
            if (value == null || value.length() == 0) {
                return "System library name cannot be empty.";
            }
            return null;
        }

        @Override
        public String defaultVal() {
            return "gaussjavaapirt";
        }
    };
    public static final GRTEConfigKeys GRAPHICS_DIR = new GRTEConfigKeys("GRAPHICS_DIR"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be null.";
            }
            if ((value = value.trim()).length() == 0) {
                value = JSCConstants.getUserDir();
            }
            if (value.indexOf(126) >= 0 || value.indexOf(32) >= 0) {
                return "Graphics directory \n\"" + value + "\"\ncontains the invalid characters \"~\" or \" \".\n" + "Please change the GRAPHICS_DIR value.";
            }
            if (!new File(value).isDirectory()) {
                return "Graphics directory \"" + value + "\" is not a directory.";
            }
            File file = new File(value + "/tmp.tmp");
            if (file.canWrite()) {
                return null;
            }
            try {
                if (file.createNewFile()) {
                    file.delete();
                    return null;
                }
                return "No write permission to \"" + value + "\".";
            }
            catch (IOException ioEx) {
                return "No write permission to \"" + value + "\".";
            }
        }

        @Override
        public String defaultVal() {
            return JSCConstants.getUserDir();
        }
    };
    public static final GRTEConfigKeys GCG_FILENAME = new GRTEConfigKeys("GCG_FILENAME"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be empty.";
            }
            String fName = EngineTypes.GRTE.DIR_NAME + File.separator + value;
            if (!new File(fName).isFile()) {
                return "GCG file \"" + fName + "\" does not exist.";
            }
            return null;
        }

        @Override
        public String defaultVal() {
            return "jgrte.gcg";
        }
    };

    GRTEConfigKeys(String name) {
        super(name);
    }
}

