/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.gauss;

import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.Engine;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.engine.LoadTypes;
import com.jstatcom.engine.gauss.GCGSet;
import com.jstatcom.engine.gauss.GaussConfigKeys;
import com.jstatcom.engine.gauss.GaussEngineType;
import com.jstatcom.engine.gauss.GaussLoadTypes;
import com.jstatcom.engine.gauss.LIBSet;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCInt;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCNumber;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.util.FArg;
import com.jstatcom.util.UString;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javolution37.javolution.xml.ObjectReader;
import org.apache.log4j.Logger;

public final class GaussEngine
implements Engine {
    private static final Logger log = Logger.getLogger(GaussEngine.class);
    private static String sysSuffix = ".dll";
    private volatile boolean stopped = false;
    private volatile boolean isRunning = false;
    private static GaussEngine gauss;
    private static ConfigHolder cf;
    private List<String> libList = new ArrayList<String>();
    private StringBuffer libBuffer = new StringBuffer();
    private List<String> dlibList = null;
    private StringBuffer dlibBuffer = null;
    private String gaussLibName = null;
    private static String tmpDir;

    private GaussEngine() {
    }

    public String compileGCG() {
        String failed = "GAUSS gcg compilation failed:\n";
        String error = null;
        File tmpFile = null;
        try {
            tmpFile = GaussEngineType.INSTANCE.getTempFile();
        }
        catch (RuntimeException ex) {
            error = failed + ex.getMessage();
            return error;
        }
        GCGSet gcgSet = null;
        ObjectReader constructor = new ObjectReader();
        try {
            gcgSet = (GCGSet)constructor.read(new FileInputStream(new File(EngineTypes.GAUSS.DIR_NAME + "/" + cf.getConfig(GaussConfigKeys.COMPILE_CFG))));
        }
        catch (Throwable ex) {
            error = failed + ex.getMessage();
            return error;
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(tmpFile));
            Iterator it = gcgSet.iterator();
            while (it.hasNext()) {
                String fName = it.next() + "";
                File srcFile = new File(EngineTypes.GAUSS.DIR_NAME + "/" + fName);
                out.write("#include \"" + srcFile.getAbsolutePath() + "\";\r\n");
            }
            out.close();
        }
        catch (IOException e) {
            error = failed + e.getMessage();
            return error;
        }
        if (!this.isRunning) {
            this.start(true);
        }
        File gcgFile = new File(EngineTypes.GAUSS.DIR_NAME + "/" + gcgSet.GCG_NAME);
        gcgFile.delete();
        StringBuffer execBuffer = new StringBuffer();
        String libraries = gcgSet.LIBS;
        if (libraries != null && (libraries = libraries.trim()).length() > 0) {
            execBuffer.append("library " + libraries + ";\n");
        }
        execBuffer.append("compile \"" + tmpFile.getAbsolutePath() + "\" \"" + gcgFile.getAbsolutePath() + "\";\n");
        String exec = UString.replaceAllSubStrings(execBuffer.toString(), "\\", "\\\\");
        log.info((Object)("\nGAUSS gcg compilation:\n" + exec));
        error = this.executeCommandEx(exec);
        if (error != null) {
            return failed + error;
        }
        return null;
    }

    public String createLibs() {
        String failed = "GAUSS library generation failed:\n";
        String error = null;
        LIBSet libSet = null;
        ObjectReader constructor = new ObjectReader();
        try {
            libSet = (LIBSet)constructor.read(new FileInputStream(new File(EngineTypes.GAUSS.DIR_NAME + "/" + cf.getConfig(GaussConfigKeys.LIB_CFG))));
        }
        catch (Throwable ex) {
            error = failed + ex.getMessage();
            return error;
        }
        String libraries = libSet.LIBS;
        if (libraries != null && (libraries = libraries.trim()).length() > 0) {
            this.load(libraries, GaussLoadTypes.LIB, new JSCData[0]);
        }
        log.info((Object)"\nGAUSS library generation:\n");
        Iterator it = libSet.iterator();
        while (it.hasNext()) {
            LIBSet.SRCLibPair pair = (LIBSet.SRCLibPair)it.next();
            File srcFile = new File(EngineTypes.GAUSS.DIR_NAME + "/" + pair.srcFile);
            String exec = "lib " + pair.libraryName + " \"" + UString.replaceAllSubStrings(srcFile.getAbsolutePath(), "\\", "\\\\") + "\"";
            log.info((Object)exec);
            error = this.executeCommandEx(exec);
            if (error != null) {
                return failed + error;
            }
            log.info((Object)" ... ok");
        }
        return null;
    }

    public void execute(String command) {
        if (command == null) {
            throw new IllegalArgumentException("Command was null.");
        }
        if (!this.isRunning) {
            this.start(true);
        }
        if ((command = command.trim()).length() == 0) {
            return;
        }
        if (command.charAt(command.length() - 1) == ';') {
            command = command.substring(0, command.length() - 1);
        }
        log.debug((Object)("command:\n" + command + ";\n"));
        String error = null;
        error = this.executeCommandEx(command);
        if (error != null) {
            throw new RuntimeException(error);
        }
        this.checkStopped();
    }

    @Override
    public void call(String procName, JSCData[] args, JSCData[] retData) {
        int i;
        if (args == null) {
            args = new JSCData[]{};
        }
        if (retData == null) {
            retData = new JSCData[]{};
        }
        String[] names = new String[retData.length];
        JSCTypes[] retTypes = new JSCTypes[retData.length];
        StringBuffer exec = new StringBuffer();
        for (i = 0; i < retData.length; ++i) {
            if (i == 0) {
                exec.append("{");
            }
            if (retData[i] == null) {
                throw new IllegalArgumentException("Return at array position [" + i + "] is null.");
            }
            names[i] = retData[i].name();
            retTypes[i] = retData[i].type();
            if (i > 0) {
                exec.append(", ");
            }
            exec.append(names[i]);
            if (i != retData.length - 1) continue;
            exec.append("} = ");
        }
        exec.append(procName);
        for (i = 0; i < args.length; ++i) {
            if (i == 0) {
                exec.append("(");
            }
            if (args[i] == null) {
                throw new IllegalArgumentException("Argument at array position [" + i + "] is null.");
            }
            if (i > 0) {
                exec.append(", ");
            }
            exec.append(args[i].name());
            if (i != args.length - 1) continue;
            exec.append(")");
        }
        this.write(args);
        this.checkStopped();
        this.execute(exec.toString());
        this.checkStopped();
        this.read(retData);
    }

    private native String executeCommandEx(String var1);

    public static GaussEngine getInstance() {
        String sysPath;
        String dllName;
        if (gauss != null) {
            return gauss;
        }
        gauss = new GaussEngine();
        cf = ConfigHolder.valueOf(EngineTypes.GAUSS);
        String osName = System.getProperty("os.name");
        if (osName == null) {
            throw new RuntimeException("OS name is null.");
        }
        if (osName.indexOf("Win") > -1) {
            dllName = null;
            if (cf.getConfig(GaussConfigKeys.GAUSS_VERSION).equals("3.2")) {
                GaussEngine.gauss.gaussLibName = "glm1.dll";
                dllName = "jgauss1.dll";
            } else {
                GaussEngine.gauss.gaussLibName = "glm2.dll";
                dllName = "jgauss2.dll";
            }
            String loadName = EngineTypes.GAUSS.DIR_NAME + "/" + GaussEngine.gauss.gaussLibName;
            File sysFile = new File(loadName);
            sysPath = sysFile.getAbsolutePath();
            if (!sysFile.isFile()) {
                throw new RuntimeException("System library " + sysPath + " does not exist.");
            }
        } else {
            throw new RuntimeException("OS " + osName + " is not supported.");
        }
        GaussEngine.gauss.dlibList = new ArrayList<String>();
        GaussEngine.gauss.dlibList.add(sysPath);
        GaussEngine.gauss.dlibBuffer = new StringBuffer(sysPath);
        System.load(new File(EngineTypes.GAUSS.DIR_NAME + "/" + dllName).getAbsolutePath());
        tmpDir = cf.getConfig(GaussConfigKeys.TEMP_DIR);
        if (!new File(tmpDir).isDirectory()) {
            tmpDir = JSCConstants.getSystemTemp();
        }
        int memSize = Integer.parseInt(cf.getConfig(GaussConfigKeys.SHARED_MEM_SIZE));
        String error = gauss.initializeGaussEx(cf.getConfig(GaussConfigKeys.EXE_LOCATION), tmpDir, memSize, cf.getConfig(GaussConfigKeys.GAUSS_VERSION));
        if (error != null) {
            throw new RuntimeException(error);
        }
        return gauss;
    }

    private native boolean isExecutingEx();

    private native String initializeGaussEx(String var1, String var2, int var3, String var4);

    @Override
    public boolean isValid(JSCTypes type) {
        return type == JSCTypes.NARRAY || type == JSCTypes.NUMBER || type == JSCTypes.INT || type == JSCTypes.SARRAY || type == JSCTypes.STRING;
    }

    @Override
    public void load(String loadName, LoadTypes loadType, JSCData ... args) {
        if (loadName == null || loadType == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (loadName.length() == 0) {
            throw new IllegalArgumentException("Module name was empty.");
        }
        if (!this.isRunning) {
            this.start(true);
        }
        if (loadType == GaussLoadTypes.GCG) {
            this.loadGCG(loadName);
        }
        if (loadType == GaussLoadTypes.LIB) {
            this.loadLIB(loadName);
        }
        if (loadType == GaussLoadTypes.SYS) {
            this.loadSYS(loadName);
        }
        if (loadType == GaussLoadTypes.GLOBAL) {
            if (args == null) {
                throw new IllegalArgumentException("Global symbol agument missing.");
            }
            if (args.length != 1) {
                throw new IllegalArgumentException("Global symbol agument length was " + args.length + " instead of 1.");
            }
            JSCConstants.checkNameThrowEx(loadName);
            this.write(args);
            this.execute(loadName + " = " + args[0].name());
        }
        this.checkStopped();
    }

    private void loadGCG(String toLoad) {
        if (JSCConstants.DEBUG) {
            return;
        }
        String loadName = EngineTypes.GAUSS.DIR_NAME + "/" + toLoad.trim();
        String error = null;
        File gcgFile = new File(loadName);
        if (!gcgFile.isFile() && (error = this.compileGCG()) != null) {
            throw new RuntimeException(error);
        }
        gcgFile = new File(loadName);
        if (!gcgFile.isFile()) {
            throw new RuntimeException("File " + gcgFile.getAbsolutePath() + " could not be created.");
        }
        String exec = UString.replaceAllSubStrings(gcgFile.getAbsolutePath(), "\\", "\\\\");
        log.debug((Object)("\nload gcg file:\nuse " + exec + ";\n"));
        error = this.executeCommandEx("use " + exec);
        if (error != null && (error = this.compileGCG()) != null) {
            throw new RuntimeException(error);
        }
        error = this.executeCommandEx("use " + exec);
        if (error != null) {
            throw new RuntimeException(error);
        }
    }

    private void loadLIB(String toLoad) {
        if (!JSCConstants.DEBUG) {
            return;
        }
        String loadName = toLoad.toLowerCase().trim();
        ArrayList<String> oldList = new ArrayList<String>(this.libList);
        StringBuffer oldBuffer = new StringBuffer(this.libBuffer.toString());
        StringTokenizer st = new StringTokenizer(loadName, ",");
        while (st.hasMoreTokens()) {
            String toPut = st.nextToken().trim();
            if (this.libList.contains(toPut) || toPut.length() <= 0) continue;
            this.libList.add(toPut);
            if (this.libBuffer.length() > 0) {
                this.libBuffer.append(", " + toPut);
                continue;
            }
            this.libBuffer.append(toPut);
        }
        String error = null;
        log.debug((Object)("\nload libraries: " + this.libBuffer.toString()));
        error = this.executeCommandEx("library " + this.libBuffer.toString());
        if (error != null) {
            this.libBuffer = oldBuffer;
            this.libList = oldList;
            throw new RuntimeException(error);
        }
    }

    private void loadSYS(String toLoad) {
        if (this.isExecutingEx()) {
            throw new RuntimeException("Gauss is busy.");
        }
        ArrayList<String> oldList = new ArrayList<String>(this.dlibList);
        StringBuffer oldBuffer = new StringBuffer(this.dlibBuffer.toString());
        String error = null;
        StringTokenizer st = new StringTokenizer(toLoad, ",");
        while (st.hasMoreTokens()) {
            String toPut = st.nextToken().trim();
            if (!toPut.toLowerCase().endsWith(sysSuffix)) {
                toPut = toPut + sysSuffix;
            }
            String loadName = EngineTypes.GAUSS.DIR_NAME + "/" + toPut;
            File sysFile = new File(loadName);
            String sysPath = sysFile.getAbsolutePath();
            if (!sysFile.isFile()) {
                throw new RuntimeException("System library " + sysPath + " does not exist.");
            }
            if (this.dlibList.contains(sysPath)) continue;
            this.dlibList.add(sysPath);
            if (this.dlibBuffer.length() > 0) {
                this.dlibBuffer.append(", " + sysPath);
                continue;
            }
            this.dlibBuffer.append(sysPath);
        }
        String exec = "dlibrary " + this.dlibBuffer.toString();
        exec = UString.replaceAllSubStrings(exec, "\\", "\\\\");
        log.debug((Object)("\nload system library:\n" + exec + ";\n"));
        error = this.executeCommandEx(exec);
        if (error != null) {
            this.dlibBuffer = oldBuffer;
            this.dlibList = oldList;
            throw new RuntimeException(error);
        }
    }

    public void read(JSCData[] rtArray) {
        if (rtArray == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (!this.isRunning) {
            this.start(true);
        }
        for (int i = 0; i < rtArray.length; ++i) {
            if (rtArray[i] == null) {
                throw new IllegalArgumentException("Return at array position [" + i + "] was null");
            }
            JSCTypes type = rtArray[i].type();
            String name = rtArray[i].name();
            log.debug((Object)("read: name=" + name + ", type=" + type));
            if (!this.isValid(type)) {
                throw new IllegalArgumentException("Return type " + type + " at array position [" + i + "] cannot be handled by GAUSS");
            }
            Object readObj = null;
            try {
                readObj = this.readDataEx(name);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Reading variable " + name + " failed with error message:\n\n" + ex.getMessage());
            }
            this.checkStopped();
            if (readObj == null) {
                rtArray[i].clear();
                continue;
            }
            if (type == JSCTypes.NARRAY) {
                if (!(readObj instanceof double[][])) {
                    throw new RuntimeException("Values for variable " + name + " do not match with type " + type + ".");
                }
                ((JSCNArray)rtArray[i]).setVal((double[][])readObj);
                continue;
            }
            if (type == JSCTypes.SARRAY) {
                if (!(readObj instanceof String[][]) && !(readObj instanceof String)) {
                    throw new RuntimeException("Values for variable " + name + " do not match with type " + type + ".");
                }
                if (readObj instanceof String[][]) {
                    ((JSCSArray)rtArray[i]).setVal((String[][])readObj);
                    continue;
                }
                ((JSCSArray)rtArray[i]).setVal(new String[][]{{(String)readObj}});
                continue;
            }
            if (type == JSCTypes.NUMBER || type == JSCTypes.INT) {
                if (!(readObj instanceof double[][])) {
                    throw new RuntimeException("Values for variable " + name + " do not match with type " + type + ".");
                }
                double[][] ret = (double[][])readObj;
                if (ret.length < 1 || ret[0].length < 1 || ret.length > 1 || ret[0].length > 1) {
                    throw new RuntimeException("Variable " + name + " is not a 1x1 scalar for type " + type + ".");
                }
                if (type == JSCTypes.NUMBER) {
                    ((JSCNumber)rtArray[i]).setVal(ret[0][0]);
                    continue;
                }
                ((JSCInt)rtArray[i]).setVal(new Double(ret[0][0]).intValue());
                continue;
            }
            if (type != JSCTypes.STRING) continue;
            if (!(readObj instanceof String)) {
                throw new RuntimeException("Values for variable " + name + " do not match with type " + type + ".");
            }
            ((JSCString)rtArray[i]).setVal((String)readObj);
        }
    }

    private native Object readDataEx(String var1);

    public void start(boolean compileIfNecessary) {
        if (this.isRunning) {
            return;
        }
        String error = null;
        error = this.startGaussEx();
        if (error != null) {
            throw new RuntimeException(error);
        }
        this.isRunning = true;
        try {
            log.info((Object)FArg.sprintf("%-20s%s", new FArg("GAUSS version:").add(cf.getConfig(GaussConfigKeys.GAUSS_VERSION))));
            log.info((Object)FArg.sprintf("%-20s%s", new FArg("GAUSS tempdir:").add(cf.getConfig(GaussConfigKeys.TEMP_DIR))));
            log.info((Object)FArg.sprintf("%-20s%s", new FArg("GAUSS executable:").add(cf.getConfig(GaussConfigKeys.EXE_LOCATION))));
            this.checkStopped();
            if (!JSCConstants.DEBUG && compileIfNecessary) {
                this.load(cf.getConfig(GaussConfigKeys.GCG_FILENAME), GaussLoadTypes.GCG, new JSCData[0]);
            } else {
                this.load("jgauss, pgraph", GaussLoadTypes.LIB, new JSCData[0]);
            }
            Thread outPut = new Thread(){

                @Override
                public void run() {
                    GaussEngine.this.startGaussOutEx();
                }
            };
            outPut.start();
        }
        catch (RuntimeException ex) {
            this.terminateGaussEx();
            this.isRunning = false;
            throw ex;
        }
    }

    private native String startGaussEx();

    private native void startGaussOutEx();

    @Override
    public void stop() {
        String error = null;
        this.stopped = true;
        error = this.stopExecutionEx();
        if (error != null) {
            throw new RuntimeException(error);
        }
    }

    private native String stopExecutionEx();

    private native void stopGaussOutEx();

    @Override
    public void shutdown() {
        String error = null;
        error = this.terminateGaussEx();
        if (error != null) {
            throw new RuntimeException(error);
        }
        this.stopGaussOutEx();
    }

    private native String terminateGaussEx();

    public void write(JSCData[] engineData) {
        if (engineData == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (!this.isRunning) {
            this.start(true);
        }
        String error = null;
        for (int i = 0; i < engineData.length; ++i) {
            this.checkStopped();
            JSCData data = engineData[i];
            if (data == null) {
                throw new IllegalArgumentException("Argument at array position [" + i + "] was null.");
            }
            log.debug((Object)("write: " + data));
            JSCTypes type = data.type();
            if (!this.isValid(type)) {
                throw new IllegalArgumentException("Argument type " + type + " at array position [" + i + "] cannot be handled by GAUSS.");
            }
            if (data.isEmpty()) {
                error = this.executeCommandEx(data.name() + "=0;\n" + data.name() + "={}");
                if (error == null) continue;
                throw new RuntimeException(error);
            }
            if (type == JSCTypes.NARRAY) {
                double[][] dataVal = ((JSCNArray)data).doubleArray();
                error = this.writeDoubleArrayEx(data.name(), dataVal);
                if (error == null) continue;
                throw new RuntimeException(error);
            }
            if (type == JSCTypes.NUMBER || type == JSCTypes.INT) {
                double number = type == JSCTypes.NUMBER ? ((Double)data.value()).doubleValue() : ((Integer)data.value()).doubleValue();
                error = this.writeDoubleArrayEx(data.name(), new double[][]{{number}});
                if (error == null) continue;
                throw new RuntimeException(error);
            }
            if (type == JSCTypes.SARRAY) {
                error = this.writeStringArrayEx(data.name(), (String[][])data.value());
                if (error == null) continue;
                throw new RuntimeException(error);
            }
            if (type != JSCTypes.STRING) continue;
            String val = "\"" + (String)data.value() + "\"";
            error = this.executeCommandEx(data.name() + " = " + val);
            if (error == null) continue;
            throw new RuntimeException(error);
        }
    }

    private void checkStopped() {
        if (this.stopped) {
            this.stopped = false;
            throw new RuntimeException(Thread.currentThread().getName() + " was interrupted.");
        }
    }

    private native String writeDoubleArrayEx(String var1, double[][] var2);

    private native String writeStringArrayEx(String var1, String[][] var2);

    static {
        if (System.getProperty("os.name", "Windows").toUpperCase().indexOf("WIN") < 0) {
            sysSuffix = ".so";
        }
        gauss = null;
        cf = null;
        tmpDir = null;
    }
}

