/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ConfigKeys {
    private static final Logger log = Logger.getLogger(ConfigKeys.class);
    private final String name;

    public ConfigKeys(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null");
        }
        this.name = name;
    }

    public abstract String defaultVal();

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public static Map<String, ConfigKeys> getAllKeys(Class c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (c.getSuperclass() != ConfigKeys.class) {
            throw new IllegalArgumentException("Class argument: " + c + " not inherited from ConfigKeys.");
        }
        Field[] publicFields = c.getFields();
        HashMap<String, ConfigKeys> keysMap = new HashMap<String, ConfigKeys>();
        try {
            for (int i = 0; i < publicFields.length; ++i) {
                Object obj = null;
                if (publicFields[i].getType().equals(c)) {
                    obj = publicFields[i].get(publicFields[i].getType());
                }
                if (!(obj instanceof ConfigKeys)) continue;
                ConfigKeys key = (ConfigKeys)obj;
                keysMap.put(key.name, (ConfigKeys)obj);
            }
        }
        catch (SecurityException e) {
            log.error((Object)"Security error while reflective inspection", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Access error while reflective inspection", (Throwable)e);
        }
        return keysMap;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public abstract String isValid(String var1);

    public final String name() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }
}

